/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.io.WriteListener;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.socket.transport.WriteBuffer;

public abstract class BufferOutputStream
extends OutputStream
implements Reset {
    private static final Map<String, byte[]> HEADER_NAME_EXT_MAP = new ConcurrentHashMap<String, byte[]>();
    protected final WriteBuffer writeBuffer;
    protected boolean committed = false;
    protected boolean chunkedSupport = true;
    protected boolean closed = false;
    private Supplier<Map<String, String>> trailerSupplier;
    protected long remaining = -1L;
    private WriteListener writeListener;

    public BufferOutputStream(WriteBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
    }

    @Override
    public final void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.write(bytes);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeHeader(HeaderWriteSource.WRITE);
        if (len == 0) {
            return;
        }
        if (this.chunkedSupport) {
            byte[] start = (Integer.toHexString(len) + "\r\n").getBytes();
            this.writeBuffer.write(start);
            this.writeBuffer.write(b, off, len);
            this.writeBuffer.write(Constant.CRLF_BYTES);
        } else {
            if (this.remaining >= 0L) {
                this.remaining -= (long)len;
                if (this.remaining < 0L) {
                    throw new IOException("");
                }
            }
            this.writeBuffer.write(b, off, len);
        }
    }

    public final void write(byte[] b, int off, int len, Consumer<BufferOutputStream> consumer) throws IOException {
        this.writeHeader(HeaderWriteSource.WRITE);
        if (this.chunkedSupport) {
            byte[] start = (Integer.toHexString(len) + "\r\n").getBytes();
            this.writeBuffer.write(start);
            this.writeBuffer.write(b, off, len);
            this.writeBuffer.write(Constant.CRLF_BYTES, 0, 2, writeBuffer -> consumer.accept(this));
        } else {
            this.writeBuffer.write(b, off, len, writeBuffer -> consumer.accept(this));
        }
    }

    public final void transferFrom(ByteBuffer buffer, Consumer<BufferOutputStream> consumer) throws IOException {
        this.writeHeader(HeaderWriteSource.WRITE);
        if (!this.chunkedSupport) {
            this.writeBuffer.transferFrom(buffer, writeBuffer -> consumer.accept(this));
            return;
        }
        byte[] start = (Integer.toHexString(buffer.remaining()) + "\r\n").getBytes();
        if (buffer.position() >= start.length) {
            buffer.put(start, buffer.position() - start.length, start.length);
            buffer.position(buffer.position() - start.length);
        } else {
            this.writeBuffer.write(start);
        }
        if (buffer.capacity() - buffer.limit() >= Constant.CRLF_BYTES.length) {
            buffer.put(Constant.CRLF_BYTES, buffer.limit(), Constant.CRLF_BYTES.length);
            buffer.limit(buffer.limit() + Constant.CRLF_BYTES.length);
            this.writeBuffer.transferFrom(buffer, writeBuffer -> consumer.accept(this));
        } else {
            this.writeBuffer.transferFrom(buffer, writeBuffer -> {
                try {
                    writeBuffer.write(Constant.CRLF_BYTES, 0, 2, buffer1 -> consumer.accept(this));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    public final void flush() throws IOException {
        this.writeHeader(HeaderWriteSource.FLUSH);
        this.writeBuffer.flush();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            throw new IOException("outputStream has already closed");
        }
        this.writeHeader(HeaderWriteSource.CLOSE);
        if (this.chunkedSupport) {
            if (this.trailerSupplier != null) {
                this.writeBuffer.write("0\r\n".getBytes());
                Map<String, String> map = this.trailerSupplier.get();
                for (String key : map.keySet()) {
                    this.writeBuffer.write((key + ":" + map.get(key) + "\r\n").getBytes());
                }
                this.writeBuffer.write(Constant.CRLF_BYTES);
            } else {
                this.writeBuffer.write(Constant.CHUNKED_END_BYTES);
            }
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getHeaderNameBytes(String name) {
        HeaderNameEnum headerNameEnum = HeaderNameEnum.HEADER_NAME_ENUM_MAP.get(name);
        if (headerNameEnum != null) {
            return headerNameEnum.getBytesWithColon();
        }
        byte[] extBytes = HEADER_NAME_EXT_MAP.get(name);
        if (extBytes == null) {
            String string = name;
            synchronized (string) {
                extBytes = this.getBytes(name + ":");
                HEADER_NAME_EXT_MAP.put(name, extBytes);
            }
        }
        return extBytes;
    }

    protected final byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void reset() {
        this.closed = false;
        this.committed = false;
        this.chunkedSupport = true;
    }

    protected abstract void writeHeader(HeaderWriteSource var1) throws IOException;

    public void disableChunked() {
        this.chunkedSupport = false;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isChunkedSupport() {
        return this.chunkedSupport;
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.trailerSupplier = supplier;
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.trailerSupplier;
    }

    protected static enum HeaderWriteSource {
        WRITE,
        FLUSH,
        CLOSE;

    }

    protected static class WriteCache {
        private final byte[] cacheData;
        private final Semaphore semaphore = new Semaphore(1);
        private long expireTime;

        public WriteCache(long cacheTime, byte[] data) {
            this.expireTime = cacheTime;
            this.cacheData = data;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public byte[] getCacheData() {
            return this.cacheData;
        }
    }
}

