/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.io.BodyInputStream;
import org.smartboot.http.common.io.ReadListener;
import org.smartboot.socket.transport.AioSession;

public class ChunkedInputStream
extends BodyInputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
    private Map<String, String> trailerFields;
    private long remainingThreshold;
    private final Consumer<Map<String, String>> consumer;
    private String trailerName;
    private int chunkedRemaining;

    public ChunkedInputStream(AioSession session, long maxPayload, Consumer<Map<String, String>> consumer) {
        super(session);
        this.remainingThreshold = maxPayload;
        this.consumer = consumer;
        this.setFlags(64);
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        this.checkState();
        if (data == null) {
            throw new NullPointerException();
        }
        if (len == 0) {
            return 0;
        }
        this.readChunkedLength();
        if (this.anyAreSet(this.state, 64)) {
            return 0;
        }
        if (this.isFinished()) {
            return -1;
        }
        ByteBuffer byteBuffer = this.session.readBuffer();
        if (this.chunkedRemaining > 0 && !byteBuffer.hasRemaining() && this.readListener == null) {
            this.session.read();
        }
        int readLength = Math.min(len, byteBuffer.remaining());
        readLength = Math.min(readLength, this.chunkedRemaining);
        byteBuffer.get(data, off, readLength);
        this.chunkedRemaining -= readLength;
        if (this.chunkedRemaining > 0) {
            return readLength + this.read(data, off + readLength, len - readLength);
        }
        this.setFlags(96);
        if (len == readLength) {
            return readLength;
        }
        int size = this.read(data, off + readLength, len - readLength);
        if (size <= 0) {
            return readLength;
        }
        return readLength + size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readChunkedLength() throws IOException {
        if (!this.anyAreSet(this.state, 64)) {
            return;
        }
        ByteBuffer byteBuffer = this.session.readBuffer();
        if (this.anyAreSet(this.state, 32)) {
            if (byteBuffer.remaining() < 2) return;
            if (byteBuffer.get() != 13 || byteBuffer.get() != 10) throw new HttpException(HttpStatus.BAD_REQUEST);
            this.clearFlags(32);
        }
        byteBuffer.mark();
        while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            if (b != 10) continue;
            if (byteBuffer.get(byteBuffer.position() - 2) != 13) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            int p = byteBuffer.position() - 2;
            byteBuffer.reset();
            byte[] buffer = new byte[p - byteBuffer.position()];
            byteBuffer.get(buffer);
            this.chunkedRemaining = Integer.parseInt(new String(buffer), 16);
            this.remainingThreshold = this.remainingThreshold - 2L - (long)buffer.length - (long)this.chunkedRemaining;
            if (this.remainingThreshold < 0L) {
                throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
            }
            if (byteBuffer.get() != 13 || byteBuffer.get() != 10) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            this.clearFlags(64);
            if (this.chunkedRemaining > 0) {
                return;
            }
            this.setFlags(16);
            if (this.readListener == null) {
                while (true) {
                    this.parseTrailerFields();
                    if (!this.anyAreSet(this.state, 16)) return;
                    this.session.read();
                }
            }
            this.parseTrailerFields();
            return;
        }
        byteBuffer.reset();
        if (this.readListener != null) return;
        int i = this.session.read();
        if (i == -1) {
            throw new IOException("inputStream is closed");
        }
        this.readChunkedLength();
    }

    private void parseTrailerFields() throws IOException {
        ByteBuffer byteBuffer = this.session.readBuffer();
        byteBuffer.mark();
        while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            if (b == 10) {
                byteBuffer.mark();
                if (this.buffer.size() == 0) {
                    this.consumer.accept(this.trailerFields);
                    this.clearFlags(16);
                    this.setFlags(2);
                    return;
                }
                this.trailerFields.put(this.trailerName, this.buffer.toString());
                this.buffer.reset();
                continue;
            }
            if (b == 58) {
                this.trailerName = this.buffer.toString();
                byteBuffer.mark();
                this.buffer.reset();
                continue;
            }
            if (b == 13) continue;
            if (this.trailerFields == null) {
                this.trailerFields = new HashMap<String, String>();
            }
            this.buffer.write(b);
        }
        byteBuffer.reset();
    }

    @Override
    public void setReadListener(final ReadListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.readListener != null) {
            throw new IllegalStateException();
        }
        this.readListener = new ReadListener(){

            @Override
            public void onDataAvailable() throws IOException {
                if (ChunkedInputStream.this.anyAreSet(ChunkedInputStream.this.state, 16)) {
                    ChunkedInputStream.this.parseTrailerFields();
                }
                if (ChunkedInputStream.this.anyAreSet(ChunkedInputStream.this.state, 2)) {
                    return;
                }
                ChunkedInputStream.this.readChunkedLength();
                if (ChunkedInputStream.this.anyAreSet(ChunkedInputStream.this.state, 64)) {
                    return;
                }
                if (ChunkedInputStream.this.chunkedRemaining > 0 && ChunkedInputStream.this.session.readBuffer().hasRemaining()) {
                    ChunkedInputStream.this.setFlags(1);
                    listener.onDataAvailable();
                    ChunkedInputStream.this.clearFlags(1);
                }
                if (ChunkedInputStream.this.anyAreSet(ChunkedInputStream.this.state, 2)) {
                    listener.onAllDataRead();
                }
            }

            @Override
            public void onAllDataRead() throws IOException {
                listener.onAllDataRead();
            }

            @Override
            public void onError(Throwable t) {
                listener.onError(t);
            }
        };
    }
}

