/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.codec.h2.hpack.Encoder;
import org.smartboot.http.common.utils.StringUtils;

public class HttpUtils {
    private static final String DOMAIN = "$Domain";
    private static final String VERSION = "$Version";
    private static final String PATH = "$Path";

    public static void decodeParamString(String paramStr, Map<String, String[]> paramMap) {
        String[] uriParamStrArray;
        if (StringUtils.isBlank(paramStr)) {
            return;
        }
        for (String param : uriParamStrArray = StringUtils.split(paramStr, "&")) {
            int index = param.indexOf("=");
            if (index == -1) continue;
            try {
                String key = StringUtils.substring(param, 0, index);
                String value = URLDecoder.decode(StringUtils.substring(param, index + 1), "utf8");
                String[] values = paramMap.get(key);
                if (values == null) {
                    paramMap.put(key, new String[]{value});
                    continue;
                }
                String[] newValue = new String[values.length + 1];
                System.arraycopy(values, 0, newValue, 0, values.length);
                newValue[values.length] = value;
                paramMap.put(key, newValue);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<Cookie> decodeCookies(String cookieStr) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        HttpUtils.decode(cookies, cookieStr, 0, new HashMap<String, String>());
        return cookies;
    }

    private static void decode(List<Cookie> cookies, String cookieStr, int offset, Map<String, String> cache) {
        while (offset < cookieStr.length() && cookieStr.charAt(offset) == ' ') {
            ++offset;
        }
        if (offset >= cookieStr.length()) {
            return;
        }
        int index = cookieStr.indexOf(61, offset);
        if (index == -1) {
            return;
        }
        String name = cookieStr.substring(offset, index);
        int end = cookieStr.indexOf(59, index);
        int trimEnd = end;
        if (trimEnd == -1) {
            trimEnd = cookieStr.length();
        }
        while (cookieStr.charAt(trimEnd - 1) == ' ') {
            --trimEnd;
        }
        String value = cookieStr.substring(index + 1, trimEnd);
        if (name.charAt(0) == '$') {
            if (cookies.isEmpty()) {
                cache.put(name, value);
            } else {
                Cookie cookie = cookies.get(cookies.size() - 1);
                switch (name) {
                    case "$Domain": {
                        cookie.setDomain(value);
                        break;
                    }
                    case "$Path": {
                        cookie.setPath(value);
                    }
                }
            }
        } else {
            Cookie cookie = new Cookie(name, value);
            if (!cache.isEmpty()) {
                cache.forEach((key, v) -> {
                    switch (key) {
                        case "$Domain": {
                            cookie.setDomain((String)v);
                            break;
                        }
                        case "$Path": {
                            cookie.setPath((String)v);
                        }
                    }
                });
                cache.clear();
            }
            cookies.add(cookie);
        }
        if (end != -1) {
            HttpUtils.decode(cookies, cookieStr, end + 1, cache);
        }
    }

    public static List<ByteBuffer> HPackEncoder(Encoder encoder, Map<String, HeaderValue> headers) {
        HeaderValue headerValue;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<String, HeaderValue> entry : headers.entrySet()) {
            if (entry.getKey().charAt(0) != ':') continue;
            System.out.println("encode: " + entry.getKey() + ":" + entry.getValue().getValue());
            for (headerValue = entry.getValue(); headerValue != null; headerValue = headerValue.getNextValue()) {
                encoder.header(entry.getKey().toLowerCase(), headerValue.getValue());
                while (!encoder.encode(buffer)) {
                    buffer.flip();
                    buffers.add(buffer);
                    buffer = ByteBuffer.allocate(1024);
                }
            }
        }
        for (Map.Entry<String, HeaderValue> entry : headers.entrySet()) {
            if (entry.getKey().charAt(0) == ':') continue;
            System.out.println("encode: " + entry.getKey() + ":" + entry.getValue().getValue());
            for (headerValue = entry.getValue(); headerValue != null; headerValue = headerValue.getNextValue()) {
                encoder.header(entry.getKey().toLowerCase(), headerValue.getValue());
                while (!encoder.encode(buffer)) {
                    buffer.flip();
                    buffers.add(buffer);
                    buffer = ByteBuffer.allocate(1024);
                }
            }
        }
        buffer.flip();
        if (buffer.hasRemaining()) {
            buffers.add(buffer);
        }
        return buffers;
    }
}

