/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpUriDecoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.MethodWafDecoder;

public class HttpMethodDecoder
extends AbstractDecoder {
    private final HttpUriDecoder decoder = new HttpUriDecoder(this.getConfiguration());

    public HttpMethodDecoder(HttpServerConfiguration configuration) {
        super(configuration, new MethodWafDecoder(configuration));
    }

    @Override
    public Decoder decode0(ByteBuffer byteBuffer, Request request) {
        ByteTree method = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)SP_END_MATCHER, this.getConfiguration().getByteCache());
        if (method != null) {
            request.setMethod(method.getStringValue());
            return this.decoder.decode(byteBuffer, request);
        }
        return this;
    }
}

