/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.multipart.MultipartConfig;
import org.smartboot.http.common.multipart.Part;
import org.smartboot.http.common.multipart.PartImpl;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.LfDecoder;
import org.smartboot.http.server.impl.HttpRequestProtocol;
import org.smartboot.http.server.impl.Request;

public class MultipartFormDecoder
extends AbstractDecoder {
    private final LfDecoder lfDecoder;
    private final byte[] boundary;
    private PartImpl currentPart;
    private final MultipartConfig multipartConfig;
    private long writeFileSize;
    private final Decoder endDecoder = new Decoder(){

        @Override
        public Decoder decode(ByteBuffer byteBuffer, Request request) {
            if (byteBuffer.remaining() < 2) {
                return this;
            }
            if (byteBuffer.get() == 13 && byteBuffer.get() == 10) {
                request.multipartParsed();
                return HttpRequestProtocol.BODY_READY_DECODER;
            }
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    };

    public MultipartFormDecoder(Request request, MultipartConfig configElement) {
        super(request.getConfiguration());
        this.boundary = ("--" + request.getContentType().substring(request.getContentType().indexOf("boundary=") + 9)).getBytes();
        MultipartHeaderDecoder multipartHeaderDecoder = new MultipartHeaderDecoder(request.getConfiguration());
        this.lfDecoder = new LfDecoder(multipartHeaderDecoder, multipartHeaderDecoder.getConfiguration());
        this.multipartConfig = configElement;
    }

    @Override
    protected Decoder decode0(ByteBuffer byteBuffer, Request request) {
        if (byteBuffer.remaining() < this.boundary.length + 2) {
            return this;
        }
        for (byte b : this.boundary) {
            if (byteBuffer.get() == b) continue;
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        byte b = byteBuffer.get();
        if (b == 45 && byteBuffer.get() == 45) {
            return this.endDecoder.decode(byteBuffer, request);
        }
        this.currentPart = new PartImpl(this.multipartConfig);
        return this.lfDecoder.decode0(byteBuffer, request);
    }

    public class MultipartFileDecoder
    implements Decoder {
        private final LfDecoder lfDecoder;

        public MultipartFileDecoder() {
            this.lfDecoder = new LfDecoder(MultipartFormDecoder.this, MultipartFormDecoder.this.getConfiguration());
        }

        @Override
        public Decoder decode(ByteBuffer byteBuffer, Request request) {
            if (byteBuffer.remaining() < MultipartFormDecoder.this.boundary.length + 2) {
                return this;
            }
            byteBuffer.mark();
            boolean match = true;
            while (byteBuffer.hasRemaining()) {
                match = true;
                for (int i = 0; i < MultipartFormDecoder.this.boundary.length; ++i) {
                    byte b = byteBuffer.get();
                    if (MultipartFormDecoder.this.boundary[i] == b) continue;
                    match = false;
                    if (i <= 0) break;
                    byteBuffer.position(byteBuffer.position() - i);
                    break;
                }
                if (!match) continue;
            }
            int position = byteBuffer.position();
            byteBuffer.reset();
            byte[] bytes = new byte[position - byteBuffer.position() - MultipartFormDecoder.this.boundary.length - 2];
            byteBuffer.get(bytes);
            if (MultipartFormDecoder.this.multipartConfig.getMaxFileSize() > 0L) {
                MultipartFormDecoder.this.writeFileSize = MultipartFormDecoder.this.writeFileSize + (long)bytes.length;
                if (MultipartFormDecoder.this.writeFileSize > MultipartFormDecoder.this.multipartConfig.getMaxFileSize()) {
                    throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
                }
            }
            try {
                MultipartFormDecoder.this.currentPart.getDiskOutputStream().write(bytes);
                if (match) {
                    if (byteBuffer.get() != 13) {
                        throw new RuntimeException();
                    }
                    MultipartFormDecoder.this.currentPart.getDiskOutputStream().flush();
                    MultipartFormDecoder.this.currentPart.getDiskOutputStream().close();
                    request.setPart((Part)MultipartFormDecoder.this.currentPart);
                    MultipartFormDecoder.this.currentPart = null;
                    return this.lfDecoder.decode(byteBuffer, request);
                }
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class MultipartFieldValueDecoder
    implements Decoder {
        private final LfDecoder lfDecoder;

        public MultipartFieldValueDecoder() {
            this.lfDecoder = new LfDecoder(MultipartFormDecoder.this, MultipartFormDecoder.this.getConfiguration());
        }

        @Override
        public Decoder decode(ByteBuffer byteBuffer, Request request) {
            byteBuffer.mark();
            boolean match = true;
            while (byteBuffer.hasRemaining()) {
                match = true;
                for (int i = 0; i < MultipartFormDecoder.this.boundary.length; ++i) {
                    byte b = byteBuffer.get();
                    if (MultipartFormDecoder.this.boundary[i] == b) continue;
                    match = false;
                    if (i <= 0) break;
                    byteBuffer.position(byteBuffer.position() - i);
                    break;
                }
                if (!match) continue;
            }
            if (!match) {
                byteBuffer.reset();
                if (byteBuffer.remaining() == byteBuffer.capacity()) {
                    throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                }
                return this;
            }
            int position = byteBuffer.position();
            byteBuffer.reset();
            byte[] bytes = new byte[position - byteBuffer.position() - MultipartFormDecoder.this.boundary.length - 2];
            byteBuffer.get(bytes);
            MultipartFormDecoder.this.currentPart.setInputStream((InputStream)new ByteArrayInputStream(bytes));
            MultipartFormDecoder.this.currentPart.setFormSize(bytes.length);
            request.setPart((Part)MultipartFormDecoder.this.currentPart);
            MultipartFormDecoder.this.currentPart = null;
            if (byteBuffer.get() != 13) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            return this.lfDecoder.decode(byteBuffer, request);
        }
    }

    class ContentDispositionDecoder
    implements Decoder {
        private final Decoder nextDecoder;

        public ContentDispositionDecoder(Decoder nextDecoder) {
            this.nextDecoder = nextDecoder;
        }

        @Override
        public Decoder decode(ByteBuffer byteBuffer, Request request) {
            ByteTree value = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)AbstractDecoder.CR_END_MATCHER, MultipartFormDecoder.this.getConfiguration().getByteCache());
            if (value == null) {
                if (byteBuffer.remaining() == byteBuffer.capacity()) {
                    throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                }
                return this;
            }
            MultipartFormDecoder.this.currentPart.setHeadValue(value.getStringValue());
            for (String partVal : value.getStringValue().split(";")) {
                if (StringUtils.startsWith((CharSequence)(partVal = partVal.trim()), (CharSequence)"filename")) {
                    if (partVal.charAt(8) == '=') {
                        MultipartFormDecoder.this.currentPart.setFileName(StringUtils.substring((String)partVal, (int)10, (int)(partVal.length() - 1)));
                        continue;
                    }
                    if (partVal.charAt(8) == '*' && partVal.charAt(9) == '=') {
                        int characterSetIndex = partVal.indexOf(39, 10);
                        int languageIndex = partVal.indexOf(39, characterSetIndex + 1);
                        String characterSet = partVal.substring(10, characterSetIndex);
                        try {
                            String fileNameURLEncoded = partVal.substring(languageIndex + 1);
                            MultipartFormDecoder.this.currentPart.setFileName(URLDecoder.decode(fileNameURLEncoded, characterSet));
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                if (!StringUtils.startsWith((CharSequence)partVal, (CharSequence)"name")) continue;
                MultipartFormDecoder.this.currentPart.setName(StringUtils.substring((String)partVal, (int)(partVal.indexOf("=\"") + 2), (int)(partVal.length() - 1)));
            }
            return this.nextDecoder.decode(byteBuffer, request);
        }
    }

    class HeaderValueDecoder
    implements Decoder {
        private final Decoder nextDecoder;

        public HeaderValueDecoder(Decoder nextDecoder) {
            this.nextDecoder = nextDecoder;
        }

        @Override
        public Decoder decode(ByteBuffer byteBuffer, Request request) {
            ByteTree value = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)AbstractDecoder.CR_END_MATCHER, MultipartFormDecoder.this.getConfiguration().getByteCache());
            if (value == null) {
                if (byteBuffer.remaining() == byteBuffer.capacity()) {
                    throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                }
                return this;
            }
            MultipartFormDecoder.this.currentPart.setHeadValue(value.getStringValue());
            return this.nextDecoder.decode(byteBuffer, request);
        }
    }

    public class MultipartHeaderDecoder
    extends AbstractDecoder {
        private final LfDecoder lfDecoder;
        private final HeaderValueDecoder headerValueDecoder;
        private final ContentDispositionDecoder contentDispositionDecoder;
        private final MultipartFieldValueDecoder fieldValueDecoder;
        private final MultipartFileDecoder fileDecoder;

        public MultipartHeaderDecoder(HttpServerConfiguration configuration) {
            super(configuration);
            this.lfDecoder = new LfDecoder(this, this.getConfiguration());
            this.headerValueDecoder = new HeaderValueDecoder(this.lfDecoder);
            this.contentDispositionDecoder = new ContentDispositionDecoder(this.lfDecoder);
            this.fieldValueDecoder = new MultipartFieldValueDecoder();
            this.fileDecoder = new MultipartFileDecoder();
        }

        @Override
        protected Decoder decode0(ByteBuffer byteBuffer, Request request) {
            if (byteBuffer.remaining() < 2) {
                return this;
            }
            byteBuffer.mark();
            if (byteBuffer.get() == 13) {
                if (byteBuffer.get() != 10) {
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                if (MultipartFormDecoder.this.currentPart.getSubmittedFileName() == null) {
                    return this.fieldValueDecoder.decode(byteBuffer, request);
                }
                return this.fileDecoder.decode(byteBuffer, request);
            }
            byteBuffer.reset();
            ByteTree name = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)COLON_END_MATCHER, this.getConfiguration().getHeaderNameByteTree());
            if (name == null) {
                return this;
            }
            System.out.println("headerName: " + name.getStringValue());
            MultipartFormDecoder.this.currentPart.setHeaderTemp(name.getStringValue());
            if (HeaderNameEnum.CONTENT_DISPOSITION.getName().equals(name.getStringValue())) {
                return this.contentDispositionDecoder.decode(byteBuffer, request);
            }
            return this.headerValueDecoder.decode(byteBuffer, request);
        }
    }
}

