/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.codec.h2.codec.DataFrame;
import org.smartboot.http.common.codec.h2.codec.GoAwayFrame;
import org.smartboot.http.common.codec.h2.codec.HeadersFrame;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;
import org.smartboot.http.common.codec.h2.codec.ResetStreamFrame;
import org.smartboot.http.common.codec.h2.codec.SettingsFrame;
import org.smartboot.http.common.codec.h2.codec.WindowUpdateFrame;
import org.smartboot.http.common.codec.h2.hpack.DecodingCallback;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.io.BufferOutputStream;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.Http2RequestImpl;
import org.smartboot.http.server.impl.Http2Session;
import org.smartboot.http.server.impl.HttpMessageProcessor;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.Request;

public abstract class Http2ServerHandler
implements ServerHandler<HttpRequest, HttpResponse> {
    private static final byte[] H2C_PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes();
    private static final int FRAME_HEADER_SIZE = 9;
    private ServerHandler<HttpRequest, HttpResponse> serverHandler;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public final void onHeaderComplete(Request request) throws IOException {
        if (HttpProtocolEnum.HTTP_2.getProtocol().equals(request.getProtocol())) {
            if (!"PRI".equals(request.getMethod()) || !"*".equals(request.getUri()) || request.getHeaderSize() > 0) {
                throw new IllegalStateException();
            }
            Http2Session session = request.newHttp2Session();
            session.setState(2);
        } else {
            String http2Settings = request.getHeader(HeaderNameEnum.HTTP2_SETTINGS.getName());
            byte[] bytes = Base64.getUrlDecoder().decode(http2Settings);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            SettingsFrame settingsFrame = new SettingsFrame(0, 0, bytes.length);
            settingsFrame.decode(byteBuffer);
            Http2Session session = request.newHttp2Session();
            session.setState(1);
            session.updateSettings(settingsFrame);
            HttpRequestImpl req = request.newHttpRequest();
            AbstractResponse response = req.getResponse();
            response.setHttpStatus(HttpStatus.SWITCHING_PROTOCOLS);
            response.setContentType(null);
            response.setHeader(HeaderNameEnum.UPGRADE.getName(), HeaderValueEnum.H2C.getName());
            response.setHeader(HeaderNameEnum.CONNECTION.getName(), HeaderValueEnum.UPGRADE.getName());
            BufferOutputStream outputStream = response.getOutputStream();
            outputStream.flush();
            Http2RequestImpl http2Request = session.getStream(1);
            http2Request.setRequestURI(request.getUri());
            http2Request.setMethod(request.getMethod());
            req.getHeaderNames().forEach(name -> http2Request.setHeader(name.toLowerCase(), request.getHeader((String)name)));
        }
    }

    public final void onBodyStream(ByteBuffer buffer, Request request) {
        Http2Session session = request.newHttp2Session();
        switch (session.getState()) {
            case 0: {
                HttpRequestImpl httpRequest = request.newHttpRequest();
                request.setType(HttpTypeEnum.HTTP_2);
                return;
            }
            case 2: {
                if (buffer.remaining() < 6) {
                    return;
                }
                for (int i = H2C_PREFACE.length - 6; i < H2C_PREFACE.length; ++i) {
                    if (H2C_PREFACE[i] == buffer.get()) continue;
                    throw new IllegalStateException();
                }
                session.setPrefaced(true);
                session.setState(4);
                this.onBodyStream(buffer, request);
                return;
            }
            case 1: {
                if (buffer.remaining() < H2C_PREFACE.length) break;
                for (byte b : H2C_PREFACE) {
                    if (b == buffer.get()) continue;
                    throw new IllegalStateException();
                }
                session.setPrefaced(true);
                session.setState(4);
                this.handleHttpRequest(session.getStream(1));
                break;
            }
            case 4: {
                if (buffer.remaining() < 9) break;
                Http2Frame frame = Http2ServerHandler.parseFrame(buffer);
                session.setCurrentFrame(frame);
                session.setState(8);
            }
            case 8: {
                Http2Frame frame = session.getCurrentFrame();
                if (!frame.decode(buffer)) break;
                session.setState(4);
                session.setCurrentFrame(null);
                try {
                    this.doHandler(frame, request);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                this.onBodyStream(buffer, request);
            }
        }
    }

    private void doHandler(Http2Frame frame, Request req) throws IOException {
        Http2Session session = req.newHttp2Session();
        switch (frame.type()) {
            case 4: {
                if (!session.isSettingEnabled()) {
                    throw new IOException();
                }
                SettingsFrame settingsFrame = (SettingsFrame)frame;
                if (settingsFrame.getFlag(1)) {
                    SettingsFrame settingAckFrame = new SettingsFrame(settingsFrame.streamId(), 1, 0);
                    settingAckFrame.writeTo(req.getAioSession().writeBuffer());
                    req.getAioSession().writeBuffer().flush();
                    System.err.println("Setting ACK\u62a5\u6587\u5df2\u53d1\u9001");
                    break;
                }
                System.out.println("settingsFrame:" + settingsFrame);
                session.updateSettings(settingsFrame);
                settingsFrame.writeTo(req.getAioSession().writeBuffer());
                req.getAioSession().writeBuffer().flush();
                System.err.println("Setting\u62a5\u6587\u5df2\u53d1\u9001");
                break;
            }
            case 8: {
                WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)frame;
                System.out.println(windowUpdateFrame.getUpdate());
                SettingsFrame ackFrame = new SettingsFrame(windowUpdateFrame.streamId(), 1, 0);
                ackFrame.writeTo(req.getAioSession().writeBuffer());
                break;
            }
            case 1: {
                session.settingDisable();
                HeadersFrame headersFrame = (HeadersFrame)frame;
                System.out.println("headerFrame Stream:" + headersFrame.streamId());
                final Http2RequestImpl request = session.getStream(headersFrame.streamId());
                request.checkState(0);
                final Map<String, HeaderValue> headers = request.getHeaders();
                session.getHpackDecoder().decode(headersFrame.getFragment(), headersFrame.getFlag(4), new DecodingCallback(){

                    public void onDecoded(CharSequence n, CharSequence v) {
                        System.out.println("name:" + n + " value:" + v);
                        String name = n.toString();
                        String value = v.toString();
                        if (name.charAt(0) == ':') {
                            switch (name) {
                                case ":method": {
                                    request.setMethod(value);
                                    break;
                                }
                                case ":path": {
                                    request.setRequestURI(value);
                                    break;
                                }
                                case ":scheme": 
                                case ":authority": {
                                    return;
                                }
                            }
                        } else {
                            headers.put(name, new HeaderValue(name, value));
                        }
                    }
                });
                if (headersFrame.getFragment().hasRemaining()) {
                    System.out.println("hasRemaining");
                }
                if (!headersFrame.getFlag(4)) break;
                request.setState(1);
                this.onHeaderComplete(request);
                if (HttpMethodEnum.GET.getMethod().equals(request.getMethod())) {
                    this.handleHttpRequest(request);
                    break;
                }
                if (request.getContentLength() > 0L) {
                    request.setBody(new ByteArrayOutputStream((int)request.getContentLength()));
                    break;
                }
                request.setBody(new ByteArrayOutputStream());
                break;
            }
            case 0: {
                session.settingDisable();
                DataFrame dataFrame = (DataFrame)frame;
                Http2RequestImpl request = session.getStream(dataFrame.streamId());
                request.checkState(1);
                request.getBody().write(dataFrame.getData());
                if (!dataFrame.getFlag(1)) break;
                request.bodyDone();
                this.handleHttpRequest(request);
                break;
            }
            case 7: {
                System.out.println("GoAwayFrame:" + ((GoAwayFrame)frame).getLastStream());
                break;
            }
            case 3: {
                ResetStreamFrame resetStreamFrame = (ResetStreamFrame)frame;
                System.out.println("RST_Stream, errorCode: " + resetStreamFrame.getErrorCode());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static Http2Frame parseFrame(ByteBuffer buffer) {
        int first = buffer.getInt();
        int length = first >> 8;
        int type = first & 0xF;
        byte flags = buffer.get();
        int streamId = buffer.getInt();
        if ((streamId & Integer.MIN_VALUE) != 0) {
            throw new IllegalStateException();
        }
        switch (type) {
            case 1: {
                return new HeadersFrame(streamId, (int)flags, length);
            }
            case 4: {
                return new SettingsFrame(streamId, (int)flags, length);
            }
            case 8: {
                return new WindowUpdateFrame(streamId, (int)flags, length);
            }
            case 0: {
                return new DataFrame(streamId, (int)flags, length);
            }
            case 7: {
                return new GoAwayFrame(streamId, (int)flags, length);
            }
            case 3: {
                return new ResetStreamFrame(streamId, (int)flags, length);
            }
        }
        throw new IllegalStateException("invalid type :" + type);
    }

    protected void onHeaderComplete(Http2RequestImpl request) throws IOException {
    }

    public final void handleHttpRequest(Http2RequestImpl abstractRequest) {
        AbstractResponse response = abstractRequest.getResponse();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            this.handle(abstractRequest, response, future);
            abstractRequest.getResponse().close();
        }
        catch (Throwable e) {
            HttpMessageProcessor.responseError(response, e);
        }
    }
}

