/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.Http2RequestImpl;
import org.smartboot.http.server.impl.HttpMessageProcessor;
import org.smartboot.http.server.impl.HttpRequestProtocol;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.transport.AioQuickServer;

public class HttpBootstrap {
    private static final String BANNER = "                               _       _      _    _          \n                              ( )_    ( )    ( )_ ( )_        \n  ___   ___ ___     _ _  _ __ | ,_)   | |__  | ,_)| ,_) _ _   \n/',__)/' _ ` _ `\\ /'_` )( '__)| |     |  _ `\\| |  | |  ( '_`\\ \n\\__, \\| ( ) ( ) |( (_| || |   | |_    | | | || |_ | |_ | (_) )\n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (_) (_)`\\__)`\\__)| ,__/'\n                                                       | |    \n                                                       (_)   ";
    private final HttpMessageProcessor processor;
    private final HttpServerConfiguration configuration = new HttpServerConfiguration();
    private final HttpRequestProtocol protocol = new HttpRequestProtocol(this.configuration);
    private AioQuickServer server;
    private int port = 8080;
    private BufferPagePool readBufferPool;
    private BufferPagePool writeBufferPool;
    private boolean started = false;
    Function<String, ServerHandler<?, ?>> upgradeFunction = upgrade -> {
        if (HeaderValueEnum.WEBSOCKET.getName().equalsIgnoreCase((String)upgrade)) {
            return this.configuration.getWebSocketHandler();
        }
        if (HeaderValueEnum.H2C.getName().equals(upgrade) || HeaderValueEnum.H2.getName().equals(upgrade)) {
            return this.configuration.getHttp2ServerHandler();
        }
        return null;
    };

    public HttpBootstrap() {
        this(new HttpMessageProcessor());
    }

    public HttpBootstrap(HttpMessageProcessor processor) {
        this.processor = processor;
        this.processor.setConfiguration(this.configuration);
    }

    public HttpBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpBootstrap httpHandler(final HttpServerHandler httpHandler) {
        this.processor.httpServerHandler(httpHandler);
        this.processor.http2ServerHandler(new Http2ServerHandler(){

            @Override
            protected void onHeaderComplete(Http2RequestImpl request) throws IOException {
                super.onHeaderComplete(request);
            }

            @Override
            public void handle(HttpRequest request, HttpResponse response, CompletableFuture<Object> completableFuture) throws Throwable {
                httpHandler.handle(request, response, completableFuture);
            }
        });
        return this;
    }

    public HttpBootstrap webSocketHandler(WebSocketHandler webSocketHandler) {
        this.processor.setWebSocketHandler(webSocketHandler);
        return this;
    }

    public HttpServerConfiguration configuration() {
        return this.configuration;
    }

    public synchronized void start() {
        if (this.started) {
            throw new RuntimeException("server is running");
        }
        this.started = true;
        this.initByteCache();
        if (this.configuration.getReadPageSize() > 0) {
            this.readBufferPool = new BufferPagePool(this.configuration.getReadPageSize(), 1, false);
        }
        if (this.configuration.getWritePageSize() > 0 && this.configuration.getWritePageNum() > 0) {
            this.writeBufferPool = new BufferPagePool(this.configuration.getWritePageSize(), this.configuration.getWritePageNum(), true);
        }
        this.configuration.getPlugins().forEach(arg_0 -> ((HttpMessageProcessor)this.processor).addPlugin(arg_0));
        this.server = new AioQuickServer(this.configuration.getHost(), this.port, (Protocol)this.protocol, (MessageProcessor)this.processor);
        this.server.setThreadNum(this.configuration.getThreadNum()).setBannerEnabled(false).setReadBufferSize(this.configuration.getReadBufferSize()).setBufferPagePool(this.readBufferPool, this.writeBufferPool).setWriteBuffer(this.configuration.getWriteBufferSize(), 16);
        if (!this.configuration.isLowMemory()) {
            this.server.disableLowMemory();
        }
        try {
            if (this.configuration.group() == null) {
                this.server.start();
            } else {
                this.server.start(this.configuration.group());
            }
            if (this.configuration.isBannerEnabled()) {
                System.out.println("                               _       _      _    _          \n                              ( )_    ( )    ( )_ ( )_        \n  ___   ___ ___     _ _  _ __ | ,_)   | |__  | ,_)| ,_) _ _   \n/',__)/' _ ` _ `\\ /'_` )( '__)| |     |  _ `\\| |  | |  ( '_`\\ \n\\__, \\| ( ) ( ) |( (_| || |   | |_    | | | || |_ | |_ | (_) )\n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (_) (_)`\\__)`\\__)| ,__/'\n                                                       | |    \n                                                       (_)   \r\n :: smart-http :: (2.1)");
                System.out.println("Technical Support:");
                System.out.println(" - Document: https://smartboot.tech]");
                System.out.println(" - Gitee: https://gitee.com/smartboot/smart-http");
                System.out.println(" - Github: https://github.com/smartboot/smart-http");
                System.out.println("\u001b[32m\ud83c\udf89Congratulations, the smart-http startup is successful.\u001b[0m");
            }
        }
        catch (Throwable e) {
            System.out.println("\u001b[31m\u2757smart-http has failed to start for some reason.\u001b[0m");
            throw new RuntimeException("server start error.", e);
        }
    }

    private void updateHeaderNameByteTree() {
        this.configuration.getHeaderNameByteTree().addNode(HeaderNameEnum.UPGRADE.getName(), this.upgradeFunction);
        this.configuration.getHeaderNameByteTree().addNode(HeaderNameEnum.UPGRADE.getName().toLowerCase(), this.upgradeFunction);
    }

    private void initByteCache() {
        for (HttpMethodEnum httpMethodEnum : HttpMethodEnum.values()) {
            this.configuration.getByteCache().addNode(httpMethodEnum.getMethod());
        }
        for (HttpMethodEnum httpMethodEnum : HttpProtocolEnum.values()) {
            this.configuration.getByteCache().addNode(httpMethodEnum.getProtocol());
        }
        for (HttpMethodEnum httpMethodEnum : HeaderNameEnum.values()) {
            this.configuration.getHeaderNameByteTree().addNode(httpMethodEnum.getName());
        }
        for (HttpMethodEnum httpMethodEnum : HeaderValueEnum.values()) {
            this.configuration.getByteCache().addNode(httpMethodEnum.getName());
        }
        this.updateHeaderNameByteTree();
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
        if (this.readBufferPool != null) {
            this.readBufferPool.release();
        }
        if (this.writeBufferPool != null) {
            this.writeBufferPool.release();
        }
    }
}

