/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.multipart.MultipartConfig;
import org.smartboot.http.common.multipart.Part;
import org.smartboot.http.common.multipart.PartImpl;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.impl.HttpRequestImpl;

public class MultipartFormDecoder {
    private final byte[] boundary;
    private int state;
    private static final int STATE_END_CHECK = 0;
    private static final int STATE_END = 1;
    private static final int STATE_PART_HEADER_NAME = 2;
    private static final int STATE_PART_HEADER_VALUE = 4;
    private static final int STATE_CONTENT_DISPOSITION_DECODER = 8;
    private static final int STATE_HEADER_END = 32;
    private static final int STATE_PART_VALUE_DECODE = 64;
    private static final int STATE_PART_FILE_DECODE = 128;
    private PartImpl currentPart;
    private final MultipartConfig multipartConfig;
    private long writeFileSize;

    public MultipartFormDecoder(HttpRequestImpl request, MultipartConfig configElement) {
        this.boundary = ("--" + request.getContentType().substring(request.getContentType().indexOf("boundary=") + 9)).getBytes();
        this.multipartConfig = configElement;
    }

    public boolean decode(ByteBuffer byteBuffer, HttpRequestImpl request) {
        switch (this.state) {
            case 0: {
                if (byteBuffer.remaining() < this.boundary.length + 2) {
                    return false;
                }
                for (byte b : this.boundary) {
                    if (byteBuffer.get() == b) continue;
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                byte b = byteBuffer.get();
                if (b == 45 && byteBuffer.get() == 45) {
                    this.state = 1;
                    return this.decode(byteBuffer, request);
                }
                if (byteBuffer.get() == 10) {
                    this.state = 2;
                    this.currentPart = new PartImpl(this.multipartConfig);
                    request.setPart((Part)this.currentPart);
                    return this.decode(byteBuffer, request);
                }
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            case 1: {
                if (byteBuffer.remaining() < 2) {
                    return false;
                }
                if (byteBuffer.get() == 13 && byteBuffer.get() == 10) {
                    return true;
                }
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            case 2: {
                if (byteBuffer.remaining() < 2) {
                    return false;
                }
                byteBuffer.mark();
                if (byteBuffer.get() == 13) {
                    if (byteBuffer.get() != 10) {
                        throw new HttpException(HttpStatus.BAD_REQUEST);
                    }
                    this.state = this.currentPart.getSubmittedFileName() == null ? 64 : 128;
                    return this.decode(byteBuffer, request);
                }
                byteBuffer.reset();
                ByteTree name = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)ByteTree.COLON_END_MATCHER, request.getRequest().getConfiguration().getHeaderNameByteTree());
                if (name == null) {
                    return false;
                }
                System.out.println("headerName: " + name.getStringValue());
                this.currentPart.setHeaderTemp(name.getStringValue());
                this.state = HeaderNameEnum.CONTENT_DISPOSITION.getName().equals(name.getStringValue()) ? 8 : 4;
                return this.decode(byteBuffer, request);
            }
            case 4: {
                ByteTree value = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)ByteTree.CR_END_MATCHER, request.getRequest().getConfiguration().getByteCache());
                if (value == null) {
                    if (byteBuffer.remaining() == byteBuffer.capacity()) {
                        throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                    }
                    return false;
                }
                this.currentPart.setHeadValue(value.getStringValue());
                this.state = 32;
                return this.decode(byteBuffer, request);
            }
            case 8: {
                ByteTree value = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)ByteTree.CR_END_MATCHER, request.getRequest().getConfiguration().getByteCache());
                if (value == null) {
                    if (byteBuffer.remaining() == byteBuffer.capacity()) {
                        throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                    }
                    return false;
                }
                this.currentPart.setHeadValue(value.getStringValue());
                for (String partVal : value.getStringValue().split(";")) {
                    if (StringUtils.startsWith((CharSequence)(partVal = partVal.trim()), (CharSequence)"filename")) {
                        if (partVal.charAt(8) == '=') {
                            this.currentPart.setFileName(StringUtils.substring((String)partVal, (int)10, (int)(partVal.length() - 1)));
                            continue;
                        }
                        if (partVal.charAt(8) == '*' && partVal.charAt(9) == '=') {
                            int characterSetIndex = partVal.indexOf(39, 10);
                            int languageIndex = partVal.indexOf(39, characterSetIndex + 1);
                            String characterSet = partVal.substring(10, characterSetIndex);
                            try {
                                String fileNameURLEncoded = partVal.substring(languageIndex + 1);
                                this.currentPart.setFileName(URLDecoder.decode(fileNameURLEncoded, characterSet));
                                continue;
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        throw new HttpException(HttpStatus.BAD_REQUEST);
                    }
                    if (!StringUtils.startsWith((CharSequence)partVal, (CharSequence)"name")) continue;
                    this.currentPart.setName(StringUtils.substring((String)partVal, (int)(partVal.indexOf("=\"") + 2), (int)(partVal.length() - 1)));
                }
                this.state = 32;
            }
            case 32: {
                if (!byteBuffer.hasRemaining()) {
                    return false;
                }
                if (byteBuffer.get() != 10) {
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                this.state = 2;
                return this.decode(byteBuffer, request);
            }
            case 64: {
                byteBuffer.mark();
                int boundaryLimit = this.findBoundary(byteBuffer);
                byteBuffer.reset();
                if (boundaryLimit < 0) {
                    if (byteBuffer.remaining() == byteBuffer.capacity()) {
                        throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                    }
                    return false;
                }
                byte[] bytes = new byte[boundaryLimit];
                byteBuffer.get(bytes);
                this.currentPart.setInputStream((InputStream)new ByteArrayInputStream(bytes));
                this.currentPart.setFormSize(bytes.length);
                this.currentPart = null;
                if (byteBuffer.get() != 13 || byteBuffer.get() != 10) {
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                this.state = 0;
                return this.decode(byteBuffer, request);
            }
            case 128: {
                if (byteBuffer.remaining() < this.boundary.length + 2) {
                    return false;
                }
                byteBuffer.mark();
                int boundaryLimit = this.findBoundary(byteBuffer);
                byteBuffer.reset();
                byte[] bytes = boundaryLimit >= 0 ? new byte[boundaryLimit] : new byte[byteBuffer.remaining() - this.boundary.length - 2];
                byteBuffer.get(bytes);
                if (this.multipartConfig.getMaxFileSize() > 0L) {
                    this.writeFileSize += (long)bytes.length;
                    if (this.writeFileSize > this.multipartConfig.getMaxFileSize()) {
                        throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
                    }
                }
                try {
                    this.currentPart.getDiskOutputStream().write(bytes);
                    if (boundaryLimit >= 0) {
                        if (byteBuffer.get() != 13 || byteBuffer.get() != 10) {
                            throw new HttpException(HttpStatus.BAD_REQUEST);
                        }
                        this.currentPart.getDiskOutputStream().flush();
                        this.currentPart.getDiskOutputStream().close();
                        this.currentPart = null;
                        this.state = 0;
                        return this.decode(byteBuffer, request);
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new HttpException(HttpStatus.BAD_REQUEST);
    }

    private int findBoundary(ByteBuffer byteBuffer) {
        int position = byteBuffer.position();
        while (byteBuffer.remaining() >= this.boundary.length + 2) {
            boolean match = true;
            for (int i = 0; i < this.boundary.length; ++i) {
                if (this.boundary[i] == byteBuffer.get()) continue;
                match = false;
                if (i <= 0) break;
                byteBuffer.position(byteBuffer.position() - i);
                break;
            }
            if (!match) continue;
            return byteBuffer.position() - position - this.boundary.length - 2;
        }
        return -1;
    }
}

