/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handler;

import java.io.IOException;
import java.util.Base64;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.Request;

public final class BasicAuthServerHandler
extends HttpServerHandler {
    private final HttpServerHandler httpServerHandler;
    private final String basic;

    public BasicAuthServerHandler(String username, String password, HttpServerHandler httpServerHandler) {
        this.httpServerHandler = httpServerHandler;
        this.basic = "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    public void onHeaderComplete(Request request) throws IOException {
        String clientBasic = request.getHeader(HeaderNameEnum.AUTHORIZATION.getName());
        if (StringUtils.equals((CharSequence)clientBasic, (CharSequence)this.basic)) {
            this.httpServerHandler.onHeaderComplete(request);
        } else {
            AbstractResponse response = request.newHttpRequest().getResponse();
            response.setHeader(HeaderNameEnum.WWW_AUTHENTICATE.getName(), "Basic realm=\"smart-http\"");
            response.setHttpStatus(HttpStatus.UNAUTHORIZED);
            response.close();
        }
    }

    public void onClose(Request request) {
        this.httpServerHandler.onClose(request);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws Throwable {
        this.httpServerHandler.handle(request, response);
    }
}

