/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.io.BodyInputStream;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.HttpUtils;
import org.smartboot.http.common.utils.NumberUtils;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.util.Attachment;

public abstract class CommonRequest
implements Reset {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonRequest.class);
    private static final Locale defaultLocale = Locale.getDefault();
    private static final int INIT_CONTENT_LENGTH = -2;
    private static final int NONE_CONTENT_LENGTH = -1;
    protected final AioSession aioSession;
    protected final List<HeaderValue> headers = new ArrayList<HeaderValue>(8);
    protected final HttpServerConfiguration configuration;
    protected Map<String, String[]> parameters;
    protected String uri;
    protected int headerSize = 0;
    protected String method;
    protected String protocol = HttpProtocolEnum.HTTP_11.getProtocol();
    protected String requestUri;
    protected String requestUrl;
    protected String contentType;
    protected String connection;
    protected String queryString;
    protected String scheme;
    protected long contentLength = -2L;
    protected String remoteAddr;
    protected String remoteHost;
    protected String hostHeader;
    protected HttpTypeEnum type = null;
    protected Cookie[] cookies;
    protected SSLEngine sslEngine;
    protected Attachment attachment;
    protected ServerHandler serverHandler;

    CommonRequest(AioSession aioSession, HttpServerConfiguration configuration) {
        this.aioSession = aioSession;
        this.configuration = configuration;
        this.sslEngine = HttpRequest.SSL_ENGINE_THREAD_LOCAL.get();
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public final String getHost() {
        if (this.hostHeader == null) {
            this.hostHeader = this.getHeader(HeaderNameEnum.HOST.getName());
        }
        return this.hostHeader;
    }

    public final String getHeader(String headName) {
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(headName)) continue;
            return headerValue.getValue();
        }
        return null;
    }

    public final Collection<String> getHeaders(String name) {
        ArrayList<String> value = new ArrayList<String>(4);
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(name)) continue;
            value.add(headerValue.getValue());
        }
        return value;
    }

    public final Collection<String> getHeaderNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            nameSet.add(this.headers.get(i).getName());
        }
        return nameSet;
    }

    public final int getHeaderSize() {
        return this.headerSize;
    }

    public BodyInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public final void setHeader(String headerName, String value) {
        if (value == null) {
            boolean suc = this.headers.removeIf(headerValue -> headerValue.getName().equalsIgnoreCase(headerName));
            if (suc) {
                --this.headerSize;
            }
            return;
        }
        if (this.headerSize < this.headers.size()) {
            HeaderValue headerValue2 = this.headers.get(this.headerSize);
            headerValue2.setName(headerName);
            headerValue2.setValue(value);
        } else {
            this.headers.add(new HeaderValue(headerName, value));
        }
        ++this.headerSize;
    }

    public final void addHeader(String headerName, String value) {
        for (HeaderValue headerValue : this.headers) {
            if (!headerValue.getName().equalsIgnoreCase(headerName)) continue;
            HeaderValue nextValue = headerValue;
            while (nextValue.getNextValue() != null) {
                nextValue = nextValue.getNextValue();
            }
            nextValue.setNextValue(new HeaderValue(null, value));
            return;
        }
        this.setHeader(headerName, value);
    }

    public HttpTypeEnum getRequestType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = this.serverHandler instanceof WebSocketHandler ? HttpTypeEnum.WEBSOCKET : (this.serverHandler instanceof Http2ServerHandler ? HttpTypeEnum.HTTP_2 : HttpTypeEnum.HTTP);
        return this.type;
    }

    public void setType(HttpTypeEnum type) {
        this.type = type;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public void setServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    public final String getRequestURI() {
        return this.requestUri;
    }

    public final void setRequestURI(String uri) {
        this.requestUri = uri;
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public final String getMethod() {
        return this.method;
    }

    public final boolean isSecure() {
        return this.configuration.isSecure();
    }

    public final void setMethod(String method) {
        this.method = method;
    }

    public final String getUri() {
        return this.uri;
    }

    public final void setUri(String uri) {
        this.uri = uri;
    }

    public final String getRequestURL() {
        if (this.requestUrl != null) {
            return this.requestUrl;
        }
        this.requestUrl = this.requestUri.startsWith("/") ? this.getScheme() + "://" + this.getHeader(HeaderNameEnum.HOST.getName()) + this.getRequestURI() : this.requestUri;
        return this.requestUrl;
    }

    public final String getScheme() {
        if (this.scheme == null) {
            return this.configuration.isSecure() ? "https" : "http";
        }
        return this.scheme;
    }

    public final void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public final String getQueryString() {
        return this.queryString;
    }

    public final void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public final String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader(HeaderNameEnum.CONTENT_TYPE.getName());
        return this.contentType;
    }

    public final String getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = this.getHeader(HeaderNameEnum.CONNECTION.getName());
        return this.connection;
    }

    public long getContentLength() {
        if (this.contentLength > -2L) {
            return this.contentLength;
        }
        this.contentLength = NumberUtils.toLong((String)this.getHeader(HeaderNameEnum.CONTENT_LENGTH.getName()), (long)-1L);
        return this.contentLength;
    }

    public final String getParameter(String name) {
        String[] arr = name != null ? this.getParameterValues(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public final String[] getParameterValues(String name) {
        String contentTypeTmp;
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        this.parameters = new HashMap<String, String[]>();
        String urlParamStr = this.queryString;
        if (StringUtils.isNotBlank((CharSequence)urlParamStr)) {
            urlParamStr = StringUtils.substringBefore((String)urlParamStr, (String)"#");
            HttpUtils.decodeParamString((String)urlParamStr, this.parameters);
        }
        if ((contentTypeTmp = this.getContentType()) != null && contentTypeTmp.startsWith(HeaderValueEnum.X_WWW_FORM_URLENCODED.getName())) {
            try {
                BodyInputStream inputStream = this.getInputStream();
                if (inputStream != BodyInputStream.EMPTY_INPUT_STREAM) {
                    int len;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    while ((len = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, len);
                    }
                    HttpUtils.decodeParamString((String)outputStream.toString(), this.parameters);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getParameterValues(name);
    }

    public final Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            this.getParameter("");
        }
        return this.parameters;
    }

    public abstract String getRemoteAddr();

    public abstract InetSocketAddress getRemoteAddress();

    public abstract InetSocketAddress getLocalAddress();

    public abstract String getRemoteHost();

    public final Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public final Enumeration<Locale> getLocales() {
        Collection<String> acceptLanguage = this.getHeaders(HeaderNameEnum.ACCEPT_LANGUAGE.getName());
        if (acceptLanguage.isEmpty()) {
            return Collections.enumeration(Collections.singletonList(defaultLocale));
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String language : acceptLanguage) {
            for (String lan : language.split(",")) {
                locales.add(Locale.forLanguageTag(lan));
            }
        }
        return Collections.enumeration(locales);
    }

    public final String getCharacterEncoding() {
        return "utf8";
    }

    public final Cookie[] getCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        ArrayList parsedCookies = new ArrayList();
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(HeaderNameEnum.COOKIE.getName())) continue;
            parsedCookies.addAll(HttpUtils.decodeCookies((String)headerValue.getValue()));
        }
        this.cookies = new Cookie[parsedCookies.size()];
        parsedCookies.toArray(this.cookies);
        return this.cookies;
    }

    public final Attachment getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public AioSession getAioSession() {
        return this.aioSession;
    }

    public final HttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void reset() {
        this.headerSize = 0;
        this.uri = null;
        this.requestUrl = null;
        this.parameters = null;
        this.contentType = null;
        this.contentLength = -2L;
        this.cookies = null;
        this.type = null;
        this.scheme = null;
        this.queryString = null;
        this.requestUri = null;
    }
}

