/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.smartboot.http.common.codec.h2.codec.ContinuationFrame;
import org.smartboot.http.common.codec.h2.codec.DataFrame;
import org.smartboot.http.common.codec.h2.codec.HeadersFrame;
import org.smartboot.http.common.codec.h2.hpack.Encoder;
import org.smartboot.http.common.io.BufferOutputStream;
import org.smartboot.http.common.utils.HttpUtils;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.Http2RequestImpl;
import org.smartboot.http.server.impl.Http2ResponseImpl;
import org.smartboot.http.server.impl.Http2Session;

final class Http2OutputStream
extends AbstractOutputStream {
    private final int streamId;
    private final Http2Session http2Session;

    public Http2OutputStream(int streamId, Http2RequestImpl httpRequest, Http2ResponseImpl response, boolean push) {
        super(httpRequest, response);
        this.disableChunked();
        this.http2Session = httpRequest.getSession();
        this.streamId = streamId;
    }

    @Override
    protected void writeHeader(BufferOutputStream.HeaderWriteSource source) throws IOException {
        if (this.committed) {
            if (source == BufferOutputStream.HeaderWriteSource.CLOSE && !this.closed) {
                DataFrame dataFrame1 = new DataFrame(this.streamId, 1, 0);
                dataFrame1.writeTo(this.writeBuffer, new byte[0], 0, 0);
            }
            return;
        }
        this.convertCookieToHeader();
        this.response.setHeader(":status", String.valueOf(this.response.getHttpStatus()));
        List buffers = HttpUtils.HPackEncoder((Encoder)this.http2Session.getHpackEncoder(), this.response.getHeaders());
        boolean multipleHeaders = buffers.size() > 1;
        HeadersFrame headersFrame = new HeadersFrame(this.streamId, multipleHeaders ? 0 : 4, 0);
        headersFrame.setFragment(buffers.isEmpty() ? null : (ByteBuffer)buffers.get(0));
        headersFrame.writeTo(this.writeBuffer);
        for (int i = 1; i < buffers.size() - 1; ++i) {
            ContinuationFrame continuationFrame = new ContinuationFrame(this.streamId, 0, 0);
            continuationFrame.setFragment((ByteBuffer)buffers.get(i));
            continuationFrame.writeTo(this.writeBuffer);
        }
        if (multipleHeaders) {
            ContinuationFrame continuationFrame = new ContinuationFrame(this.streamId, 4, 0);
            continuationFrame.setFragment((ByteBuffer)buffers.get(buffers.size() - 1));
            continuationFrame.writeTo(this.writeBuffer);
        }
        System.err.println("StreamID: " + this.streamId + " Header\u5df2\u53d1\u9001...");
        this.committed = true;
    }

    @Override
    protected byte[] getHeadPart(boolean hasHeader) {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeHeader(BufferOutputStream.HeaderWriteSource.WRITE);
        if (len == 0) {
            return;
        }
        DataFrame dataFrame = new DataFrame(this.streamId, 0, len);
        dataFrame.writeTo(this.writeBuffer, b, off, len);
    }
}

