/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;
import org.smartboot.http.common.codec.h2.codec.SettingsFrame;
import org.smartboot.http.common.codec.h2.hpack.Decoder;
import org.smartboot.http.common.codec.h2.hpack.Encoder;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.server.impl.Http2RequestImpl;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.transport.WriteBuffer;

public class Http2Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2Session.class);
    public static final int STATE_FIRST_REQUEST = 0;
    public static final int STATE_PREFACE = 1;
    public static final int STATE_PREFACE_SM = 2;
    public static final int STATE_FRAME_HEAD = 4;
    public static final int STATE_FRAME_PAYLOAD = 8;
    private final ConcurrentHashMap<Integer, Http2RequestImpl> streams = new ConcurrentHashMap();
    private final Decoder hpackDecoder = new Decoder(65536);
    private final Encoder hpackEncoder = new Encoder(65536);
    private final AtomicInteger pushStreamId = new AtomicInteger(0);
    private boolean settingEnabled = true;
    private final SettingsFrame settings = new SettingsFrame(0, true){

        public boolean decode(ByteBuffer buffer) {
            throw new IllegalStateException();
        }

        public void writeTo(WriteBuffer writeBuffer) throws IOException {
            throw new IllegalStateException();
        }
    };
    private int streamId;
    private boolean prefaced;
    private Http2Frame currentFrame;
    private int state;
    private final Request request;

    public Http2Session(Request request) {
        this.request = request;
    }

    public Http2RequestImpl getStream(int streamId) {
        return this.streams.computeIfAbsent(streamId, k -> new Http2RequestImpl(streamId, this, false));
    }

    public boolean isPrefaced() {
        return this.prefaced;
    }

    public void setPrefaced(boolean prefaced) {
        this.prefaced = prefaced;
    }

    public Http2Frame getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(Http2Frame currentFrame) {
        this.currentFrame = currentFrame;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Decoder getHpackDecoder() {
        return this.hpackDecoder;
    }

    public Encoder getHpackEncoder() {
        return this.hpackEncoder;
    }

    public Request getRequest() {
        return this.request;
    }

    public void updateSettings(SettingsFrame settingsFrame) {
        this.settings.setEnablePush(settingsFrame.getEnablePush());
        this.settings.setHeaderTableSize(settingsFrame.getHeaderTableSize());
        this.settings.setInitialWindowSize(settingsFrame.getInitialWindowSize());
        this.settings.setMaxConcurrentStreams(settingsFrame.getMaxConcurrentStreams());
        this.settings.setMaxFrameSize(settingsFrame.getMaxFrameSize());
        this.settings.setMaxHeaderListSize(settingsFrame.getMaxHeaderListSize());
        LOGGER.info("updateSettings:" + this.settings);
    }

    public SettingsFrame getSettings() {
        return this.settings;
    }

    public AtomicInteger getPushStreamId() {
        return this.pushStreamId;
    }

    public boolean isSettingEnabled() {
        return this.settingEnabled;
    }

    public void settingDisable() {
        this.settingEnabled = false;
    }
}

