/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.extension.plugins.AbstractPlugin;
import org.smartboot.socket.timer.HashedWheelTimer;
import org.smartboot.socket.timer.TimerTask;
import org.smartboot.socket.transport.AioQuickServer;

public class BufferPageMonitorPlugin<T>
extends AbstractPlugin<T> {
    private int seconds = 0;
    private AioQuickServer server;
    private TimerTask future;

    public BufferPageMonitorPlugin(AioQuickServer server, int seconds) {
        this.seconds = seconds;
        this.server = server;
        this.init();
    }

    private void init() {
        this.future = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
            if (this.server == null) {
                System.err.println("unKnow server or client need to monitor!");
                this.shutdown();
                return;
            }
            try {
                Field bufferPoolField = AioQuickServer.class.getDeclaredField("writeBufferPool");
                bufferPoolField.setAccessible(true);
                BufferPagePool writeBufferPool = (BufferPagePool)bufferPoolField.get(this.server);
                if (writeBufferPool == null) {
                    System.err.println("server maybe has not started!");
                    this.shutdown();
                    return;
                }
                Field readBufferPoolField = AioQuickServer.class.getDeclaredField("readBufferPool");
                readBufferPoolField.setAccessible(true);
                BufferPagePool readBufferPool = (BufferPagePool)readBufferPoolField.get(this.server);
                if (readBufferPool != null && readBufferPool != writeBufferPool) {
                    BufferPageMonitorPlugin.dumpBufferPool(writeBufferPool);
                    BufferPageMonitorPlugin.dumpBufferPool(readBufferPool);
                } else {
                    BufferPageMonitorPlugin.dumpBufferPool(writeBufferPool);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, this.seconds, TimeUnit.SECONDS);
    }

    private static void dumpBufferPool(BufferPagePool writeBufferPool) throws NoSuchFieldException, IllegalAccessException {
        Field field = BufferPagePool.class.getDeclaredField("bufferPages");
        field.setAccessible(true);
        BufferPage[] pages = (BufferPage[])field.get(writeBufferPool);
        String logger = "";
        for (BufferPage page : pages) {
            logger = logger + "\r\n" + page.toString();
        }
        System.out.println(logger);
    }

    private void shutdown() {
        if (this.future != null) {
            this.future.cancel();
            this.future = null;
        }
    }
}

