/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.channels.AsynchronousSocketChannelProxy;
import org.smartboot.socket.extension.plugins.AbstractPlugin;

public class ProxyProtocolPlugin<T>
extends AbstractPlugin<T> {
    private static final byte AF_UNSPEC_BYTE = 0;
    private static final int AF_IPV4_BYTE = 16;
    private static final byte AF_IPV6_BYTE = 32;
    private static final byte AF_UNIX_BYTE = 48;
    private static final byte TP_UNSPEC_BYTE = 0;
    private static final byte TP_STREAM_BYTE = 1;
    private static final byte TP_DGRAM_BYTE = 2;
    private final boolean strict;

    public ProxyProtocolPlugin() {
        this(false);
    }

    public ProxyProtocolPlugin(boolean strict) {
        this.strict = strict;
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new ProxyProtocolChannel(channel);
    }

    class ProxyProtocolChannel
    extends AsynchronousSocketChannelProxy {
        private static final byte STATE_READY = 0;
        private static final byte STATE_PROXY_SIGN = 1;
        private static final byte STATE_V2_HEADER = 2;
        private static final byte STATE_V2_IPv4 = 3;
        private static final byte STATE_V2_IPv6 = 4;
        private static final byte STATE_V2_UNIX = 5;
        private static final byte STATE_V1_TYPE = 6;
        private static final byte STATE_V1_SOURCE_IP = 7;
        private static final byte STATE_V1_DEST_IP = 8;
        private static final byte STATE_V1_SOURCE_PORT = 9;
        private static final byte STATE_V1_DEST_PORT = 10;
        private static final byte STATE_V1_SKIP_TO_END = 11;
        private static final byte STATE_END = 12;
        private byte state;
        private String sourceIp;
        private String destIp;
        private SocketAddress remoteAddress;
        private SocketAddress localAddress;

        public ProxyProtocolChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
            super(asynchronousSocketChannel);
            this.state = 1;
        }

        @Override
        public <A> void read(final ByteBuffer buffer, final long timeout, final TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
            if (this.state == 0) {
                super.read(buffer, timeout, unit, attachment, handler);
            } else {
                if (buffer.capacity() < 16) {
                    handler.failed(new IOException("buffer capacity is not enough"), attachment);
                    return;
                }
                super.read(buffer, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

                    @Override
                    public void completed(Integer result, A attachment) {
                        if (result < 0) {
                            handler.completed(result, attachment);
                            return;
                        }
                        buffer.flip();
                        Exception e = null;
                        e = ProxyProtocolChannel.this.decodeProxyProtocol(buffer);
                        if (e != null) {
                            handler.failed(e, attachment);
                            return;
                        }
                        buffer.compact();
                        if (ProxyProtocolChannel.this.state == 0) {
                            if (buffer.position() > 0) {
                                handler.completed(buffer.position(), attachment);
                            } else {
                                ProxyProtocolChannel.super.read(buffer, timeout, unit, attachment, handler);
                            }
                        } else {
                            ProxyProtocolChannel.super.read(buffer, timeout, unit, attachment, this);
                        }
                    }

                    @Override
                    public void failed(Throwable exc, A attachment) {
                        handler.failed(exc, attachment);
                    }
                });
            }
        }

        private Exception decodeProxyProtocol(ByteBuffer buffer) {
            switch (this.state) {
                case 1: {
                    if (buffer.remaining() < 12) break;
                    buffer.mark();
                    byte b = buffer.get();
                    if (b == 80) {
                        if (buffer.get() != 82 || buffer.get() != 79 || buffer.get() != 88 || buffer.get() != 89 || buffer.get() != 32) {
                            if (ProxyProtocolPlugin.this.strict) {
                                return new IOException("not proxy protocol");
                            }
                            buffer.reset();
                            this.state = 0;
                        } else {
                            this.state = (byte)6;
                        }
                    } else if (b == 13) {
                        if (buffer.get() != 10 || buffer.get() != 13 || buffer.get() != 10 || buffer.get() != 0 || buffer.get() != 13 || buffer.get() != 10 || buffer.get() != 81 || buffer.get() != 85 || buffer.get() != 73 || buffer.get() != 84 || buffer.get() != 10) {
                            if (ProxyProtocolPlugin.this.strict) {
                                return new IOException("not proxy protocol");
                            }
                            buffer.reset();
                            this.state = 0;
                        } else {
                            this.state = (byte)2;
                        }
                    } else {
                        if (ProxyProtocolPlugin.this.strict) {
                            return new IOException("invalid proxy protocol");
                        }
                        buffer.reset();
                        this.state = 0;
                    }
                    return this.decodeProxyProtocol(buffer);
                }
                case 6: {
                    if (buffer.remaining() < 8) break;
                    byte b = buffer.get();
                    if (b == 84) {
                        if (buffer.get() != 67 || buffer.get() != 80) {
                            return new IOException("invalid proxy protocol");
                        }
                        b = buffer.get();
                        if (b != 52 && b != 54) {
                            return new IOException("invalid proxy protocol");
                        }
                        if (buffer.get() != 32) {
                            return new IOException("invalid proxy protocol");
                        }
                        this.state = (byte)7;
                    } else if (b == 85) {
                        if (buffer.get() != 78 || buffer.get() != 75 || buffer.get() != 78 || buffer.get() != 79 || buffer.get() != 87 || buffer.get() != 78 || buffer.get() != 32) {
                            return new IOException("invalid proxy protocol");
                        }
                        this.state = (byte)11;
                    } else {
                        return new IOException("not proxy protocol");
                    }
                    return this.decodeProxyProtocol(buffer);
                }
                case 7: {
                    this.sourceIp = this.getIp(buffer);
                    if (this.sourceIp == null) {
                        return null;
                    }
                    this.state = (byte)8;
                }
                case 8: {
                    this.destIp = this.getIp(buffer);
                    if (this.destIp == null) {
                        return null;
                    }
                }
                case 9: {
                    int port = this.getPort(buffer);
                    if (port == -1) {
                        return null;
                    }
                    this.remoteAddress = new InetSocketAddress(this.sourceIp, port);
                    this.state = (byte)10;
                }
                case 10: {
                    int port = this.getPort(buffer);
                    if (port == -1) {
                        return null;
                    }
                    this.localAddress = new InetSocketAddress(this.destIp, port);
                    buffer.position(buffer.position() - 1);
                    this.state = (byte)12;
                }
                case 12: {
                    if (buffer.remaining() < 2) {
                        return null;
                    }
                    if (buffer.get() != 13 || buffer.get() != 10) {
                        return new IOException("invalid proxy protocol");
                    }
                    this.state = 0;
                    break;
                }
                case 11: {
                    while (buffer.remaining() >= 2) {
                        if (buffer.get() != 13) continue;
                        if (buffer.get() != 10) {
                            return new IOException("invalid proxy protocol");
                        }
                        this.state = 0;
                    }
                    break;
                }
                case 2: {
                    if (buffer.remaining() < 4) {
                        return null;
                    }
                    byte b = buffer.get();
                    if (b >> 4 != 2) {
                        return new IOException("invalid proxy protocol version");
                    }
                    int cmd = b & 0xF;
                    b = buffer.get();
                    byte addressFamily = (byte)(b & 0xF0);
                    if (addressFamily > 48) {
                        return new IOException("invalid proxy protocol address family");
                    }
                    byte transportProtocol = (byte)(b & 0xF);
                    if (transportProtocol > 2) {
                        return new IOException("invalid proxy protocol transport protocol");
                    }
                    short addressLength = buffer.getShort();
                    switch (b) {
                        case 0: {
                            this.state = 0;
                            break;
                        }
                        case 17: 
                        case 18: {
                            this.state = (byte)3;
                            if (addressLength == 12) break;
                            return new IOException("invalid proxy protocol address length");
                        }
                        case 33: 
                        case 34: {
                            if (addressLength != 36) {
                                return new IOException("invalid proxy protocol address length");
                            }
                            this.state = (byte)4;
                            break;
                        }
                        case 49: 
                        case 50: {
                            if (addressLength != 216) {
                                return new IOException("invalid proxy protocol address length");
                            }
                            this.state = (byte)5;
                            break;
                        }
                        default: {
                            return new IOException("invalid proxy protocol address family");
                        }
                    }
                    return this.decodeProxyProtocol(buffer);
                }
                case 3: {
                    if (buffer.remaining() < 12) {
                        return null;
                    }
                    this.sourceIp = (buffer.get() & 0xFF) + "." + (buffer.get() & 0xFF) + "." + (buffer.get() & 0xFF) + "." + (buffer.get() & 0xFF);
                    this.destIp = (buffer.get() & 0xFF) + "." + (buffer.get() & 0xFF) + "." + (buffer.get() & 0xFF) + "." + (buffer.get() & 0xFF);
                    this.remoteAddress = new InetSocketAddress(this.sourceIp, buffer.getShort() & 0xFFFF);
                    this.localAddress = new InetSocketAddress(this.destIp, buffer.getShort() & 0xFFFF);
                    this.state = 0;
                    break;
                }
                case 4: {
                    if (buffer.remaining() < 36) {
                        return null;
                    }
                    StringBuilder sourceIp = new StringBuilder(Integer.toHexString(buffer.getShort() & 0xFFFF));
                    for (int i = 0; i < 3; ++i) {
                        sourceIp.append(":").append(Integer.toHexString(buffer.getShort() & 0xFFFF));
                    }
                    StringBuilder destIp = new StringBuilder(Integer.toHexString(buffer.getShort() & 0xFFFF));
                    for (int i = 0; i < 3; ++i) {
                        destIp.append(":").append(Integer.toHexString(buffer.getShort() & 0xFFFF));
                    }
                    this.remoteAddress = new InetSocketAddress(sourceIp.toString(), buffer.getShort() & 0xFFFF);
                    this.localAddress = new InetSocketAddress(destIp.toString(), buffer.getShort() & 0xFFFF);
                    this.state = 0;
                    break;
                }
                case 5: {
                    if (buffer.remaining() >= 216) break;
                    return null;
                }
            }
            return null;
        }

        private String getIp(ByteBuffer buffer) {
            int p = buffer.position();
            buffer.mark();
            boolean ok = false;
            while (buffer.hasRemaining()) {
                if (buffer.get() != 32) continue;
                ok = true;
                break;
            }
            if (!ok) {
                buffer.reset();
                return null;
            }
            byte[] bytes = new byte[buffer.position() - p];
            buffer.reset();
            buffer.get(bytes);
            return new String(bytes, 0, bytes.length - 1);
        }

        private int getPort(ByteBuffer buffer) {
            buffer.mark();
            int port = 0;
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (b < 48 || b > 57) {
                    return port;
                }
                port = port * 10 + b - 48;
            }
            buffer.reset();
            return -1;
        }

        @Override
        public SocketAddress getRemoteAddress() throws IOException {
            this.checkState();
            return this.remoteAddress == null ? super.getRemoteAddress() : this.remoteAddress;
        }

        @Override
        public SocketAddress getLocalAddress() throws IOException {
            this.checkState();
            return this.localAddress == null ? super.getLocalAddress() : this.localAddress;
        }

        private void checkState() throws IOException {
            if (this.state != 0) {
                throw new IOException("proxy protocol not ready");
            }
        }
    }
}

