/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl.factory;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.smartboot.socket.extension.ssl.factory.SSLContextFactory;

public class ServerSSLContextFactory
implements SSLContextFactory {
    private final InputStream keyStoreInputStream;
    private final String keyStorePassword;
    private final String keyPassword;
    private final InputStream trustInputStream;
    private final String trustPassword;

    public ServerSSLContextFactory(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword) {
        this(keyStoreInputStream, keyStorePassword, keyPassword, null, null);
    }

    public ServerSSLContextFactory(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword, InputStream trustInputStream, String trustPassword) {
        this.keyStoreInputStream = keyStoreInputStream;
        this.keyStorePassword = keyStorePassword;
        this.keyPassword = keyPassword;
        this.trustInputStream = trustInputStream;
        this.trustPassword = trustPassword;
    }

    @Override
    public SSLContext create() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        KeyStore ks = KeyStore.getInstance("JKS");
        if (this.keyStoreInputStream == null) {
            throw new IllegalArgumentException("keyStoreInputStream is null");
        }
        ks.load(this.keyStoreInputStream, this.keyStorePassword.toCharArray());
        if (ks.size() == 0) {
            throw new IllegalStateException("Empty server certificate chain");
        }
        kmf.init(ks, this.keyPassword.toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        TrustManager[] trustManagers = null;
        if (this.trustInputStream != null) {
            KeyStore ts = KeyStore.getInstance("JKS");
            ts.load(this.trustInputStream, this.trustPassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ts);
            trustManagers = tmf.getTrustManagers();
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }
}

