/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.extension.plugins.AbstractPlugin;
import org.smartboot.socket.extension.ssl.ClientAuth;
import org.smartboot.socket.extension.ssl.SslAsynchronousSocketChannel;
import org.smartboot.socket.extension.ssl.SslService;
import org.smartboot.socket.extension.ssl.factory.ClientSSLContextFactory;
import org.smartboot.socket.extension.ssl.factory.SSLContextFactory;
import org.smartboot.socket.extension.ssl.factory.ServerSSLContextFactory;

public final class SslPlugin<T>
extends AbstractPlugin<T> {
    private final SslService sslService;
    private final BufferPagePool pool;

    public SslPlugin(SSLContextFactory factory, Consumer<SSLEngine> consumer) throws Exception {
        this(factory, consumer, BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(SSLContextFactory factory) throws Exception {
        this(factory, (SSLEngine sslEngine) -> sslEngine.setUseClientMode(false), BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(SSLContextFactory factory, Consumer<SSLEngine> consumer, BufferPagePool pool) throws Exception {
        this.pool = pool;
        this.sslService = new SslService(factory.create(), consumer);
    }

    public SslPlugin(ClientSSLContextFactory factory) throws Exception {
        this(factory, BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(ClientSSLContextFactory factory, BufferPagePool pool) throws Exception {
        this(factory, (SSLEngine sslEngine) -> sslEngine.setUseClientMode(true), pool);
    }

    public SslPlugin(ServerSSLContextFactory factory, ClientAuth clientAuth) throws Exception {
        this(factory, clientAuth, BufferPagePool.DEFAULT_BUFFER_PAGE_POOL);
    }

    public SslPlugin(ServerSSLContextFactory factory, ClientAuth clientAuth, BufferPagePool pool) throws Exception {
        this((SSLContextFactory)factory, (SSLEngine sslEngine) -> {
            sslEngine.setUseClientMode(false);
            switch (clientAuth) {
                case OPTIONAL: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)clientAuth));
                }
            }
        }, pool);
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new SslAsynchronousSocketChannel(channel, this.sslService, this.pool);
    }

    public void debug(boolean debug) {
        this.sslService.debug(debug);
    }
}

