/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl.factory;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.smartboot.socket.extension.ssl.factory.SSLContextFactory;

public class ClientSSLContextFactory
implements SSLContextFactory {
    private InputStream trustInputStream;
    private String trustPassword;
    private InputStream keyInputStream;
    private String keyPassword;

    public ClientSSLContextFactory() {
    }

    public ClientSSLContextFactory(InputStream trustInputStream, String trustPassword, InputStream keyInputStream, String keyPassword) {
        this.trustInputStream = trustInputStream;
        this.trustPassword = trustPassword;
        this.keyInputStream = keyInputStream;
        this.keyPassword = keyPassword;
        if (keyInputStream != null && trustInputStream == null) {
            throw new IllegalArgumentException("When keyInputStream is provided, trustInputStream must also be provided for mutual authentication");
        }
    }

    @Override
    public SSLContext create() throws Exception {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers = null;
        if (this.trustInputStream != null) {
            KeyStore ts = KeyStore.getInstance("JKS");
            ts.load(this.trustInputStream, this.trustPassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ts);
            trustManagers = tmf.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        if (this.keyInputStream != null) {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(this.keyInputStream, this.keyPassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, this.keyPassword.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }
}

