/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.io.IOException;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.plugins.AbstractPlugin;
import org.smartboot.socket.timer.HashedWheelTimer;
import org.smartboot.socket.transport.AioSession;

public abstract class HeartPlugin<T>
extends AbstractPlugin<T> {
    private static final TimeoutCallback DEFAULT_TIMEOUT_CALLBACK = (session, lastTime) -> session.close(true);
    private final Map<AioSession, Long> sessionMap = new ConcurrentHashMap<AioSession, Long>();
    private final long heartRate;
    private final long timeout;
    private final TimeoutCallback timeoutCallback;

    public HeartPlugin(int heartRate, TimeUnit timeUnit) {
        this(heartRate, 0, timeUnit);
    }

    public HeartPlugin(int heartRate, int timeout, TimeUnit unit) {
        this(heartRate, timeout, unit, DEFAULT_TIMEOUT_CALLBACK);
    }

    public HeartPlugin(int heartRate, int timeout, TimeUnit timeUnit, TimeoutCallback timeoutCallback) {
        if (timeout > 0 && heartRate >= timeout) {
            throw new IllegalArgumentException("heartRate must little than timeout");
        }
        this.heartRate = timeUnit.toMillis(heartRate);
        this.timeout = timeUnit.toMillis(timeout);
        this.timeoutCallback = timeoutCallback;
    }

    @Override
    public final boolean preProcess(AioSession session, T t) {
        this.sessionMap.computeIfPresent(session, (k, v) -> System.currentTimeMillis());
        return !this.isHeartMessage(session, t);
    }

    @Override
    public final void stateEvent(StateMachineEnum stateMachineEnum, AioSession session, Throwable throwable) {
        switch (stateMachineEnum) {
            case NEW_SESSION: {
                this.sessionMap.put(session, System.currentTimeMillis());
                this.registerHeart(session, this.heartRate);
                break;
            }
            case SESSION_CLOSED: {
                this.sessionMap.remove(session);
                break;
            }
        }
    }

    public abstract void sendHeartRequest(AioSession var1) throws IOException;

    public abstract boolean isHeartMessage(AioSession var1, T var2);

    private void registerHeart(final AioSession session, final long heartRate) {
        if (heartRate <= 0L) {
            return;
        }
        HashedWheelTimer.DEFAULT_TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                if (session.isInvalid()) {
                    HeartPlugin.this.sessionMap.remove(session);
                    return;
                }
                long lastTime = HeartPlugin.this.sessionMap.computeIfAbsent(session, k -> System.currentTimeMillis());
                long current = System.currentTimeMillis();
                if (HeartPlugin.this.timeout > 0L && current - lastTime > HeartPlugin.this.timeout) {
                    HeartPlugin.this.timeoutCallback.callback(session, lastTime);
                } else if (current - lastTime > heartRate) {
                    try {
                        HeartPlugin.this.sendHeartRequest(session);
                        session.writeBuffer().flush();
                    }
                    catch (IOException e) {
                        session.close(true);
                    }
                }
                HeartPlugin.this.registerHeart(session, heartRate);
            }
        }, heartRate, TimeUnit.MILLISECONDS);
    }

    public static interface TimeoutCallback {
        public void callback(AioSession var1, long var2);
    }
}

