/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.ktorswaggerui.builder.example;

import io.github.smiley4.ktorswaggerui.builder.example.ExampleContext;
import io.github.smiley4.ktorswaggerui.builder.route.RouteMeta;
import io.github.smiley4.ktorswaggerui.data.ExampleConfigData;
import io.github.smiley4.ktorswaggerui.data.ExampleDescriptor;
import io.github.smiley4.ktorswaggerui.data.OpenApiBaseBodyData;
import io.github.smiley4.ktorswaggerui.data.OpenApiRequestData;
import io.github.smiley4.ktorswaggerui.data.OpenApiRequestParameterData;
import io.github.smiley4.ktorswaggerui.data.OpenApiResponseData;
import io.github.smiley4.ktorswaggerui.data.OpenApiSimpleBodyData;
import io.github.smiley4.ktorswaggerui.data.RefExampleDescriptor;
import io.github.smiley4.ktorswaggerui.data.SwaggerExampleDescriptor;
import io.github.smiley4.ktorswaggerui.data.ValueExampleDescriptor;
import io.swagger.v3.oas.models.examples.Example;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/smiley4/ktorswaggerui/builder/example/ExampleContextImpl;", "Lio/github/smiley4/ktorswaggerui/builder/example/ExampleContext;", "()V", "componentExamples", "", "", "Lio/swagger/v3/oas/models/examples/Example;", "rootExamples", "Lio/github/smiley4/ktorswaggerui/data/ExampleDescriptor;", "add", "", "routes", "", "Lio/github/smiley4/ktorswaggerui/builder/route/RouteMeta;", "addShared", "config", "Lio/github/smiley4/ktorswaggerui/data/ExampleConfigData;", "collectExampleDescriptors", "", "generateExample", "exampleDescriptor", "getComponentSection", "", "getExample", "descriptor", "ktor-swagger-ui"})
@SourceDebugExtension(value={"SMAP\nExampleContextImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExampleContextImpl.kt\nio/github/smiley4/ktorswaggerui/builder/example/ExampleContextImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n215#2,2:99\n1855#3,2:101\n766#3:103\n857#3,2:104\n1855#3:106\n1855#3:107\n1856#3:109\n1855#3,2:110\n1856#3:112\n1#4:108\n*S KotlinDebug\n*F\n+ 1 ExampleContextImpl.kt\nio/github/smiley4/ktorswaggerui/builder/example/ExampleContextImpl\n*L\n25#1:99,2\n36#1:101,2\n48#1:103\n48#1:104,2\n49#1:106\n51#1:107\n51#1:109\n60#1:110,2\n49#1:112\n*E\n"})
public final class ExampleContextImpl
implements ExampleContext {
    @NotNull
    private final Map<ExampleDescriptor, Example> rootExamples = new LinkedHashMap();
    @NotNull
    private final Map<String, Example> componentExamples = new LinkedHashMap();

    public final void addShared(@NotNull ExampleConfigData config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Map<String, ExampleDescriptor> $this$forEach$iv = config.getSharedExamples();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ExampleDescriptor>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ExampleDescriptor> element$iv;
            Map.Entry<String, ExampleDescriptor> entry = element$iv = iterator.next();
            boolean bl = false;
            ExampleDescriptor exampleDescriptor = entry.getValue();
            Example example = this.generateExample(exampleDescriptor);
            this.componentExamples.put(exampleDescriptor.getName(), example);
        }
    }

    public final void add(@NotNull Collection<RouteMeta> routes2) {
        Intrinsics.checkNotNullParameter(routes2, (String)"routes");
        Iterable $this$forEach$iv = this.collectExampleDescriptors(routes2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExampleDescriptor exampleDescriptor = (ExampleDescriptor)element$iv;
            boolean bl = false;
            this.rootExamples.put(exampleDescriptor, this.generateExample(exampleDescriptor));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExampleDescriptor> collectExampleDescriptors(Collection<RouteMeta> routes2) {
        void $this$filterTo$iv$iv;
        List descriptors = new ArrayList();
        Iterable $this$filter$iv = routes2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RouteMeta it = (RouteMeta)element$iv$iv;
            boolean bl = false;
            if (!(!it.getDocumentation().getHidden())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv$iv;
            RouteMeta route2 = (RouteMeta)element$iv;
            boolean bl = false;
            Object request = element$iv$iv = route2.getDocumentation().getRequest();
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = ((OpenApiRequestData)request).getParameters();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ExampleDescriptor exampleDescriptor;
                OpenApiRequestParameterData parameter2 = (OpenApiRequestParameterData)element$iv2;
                boolean bl3 = false;
                if (parameter2.getExample() == null) continue;
                ExampleDescriptor it = exampleDescriptor;
                boolean bl4 = false;
                descriptors.add(it);
            }
            if (((OpenApiRequestData)request).getBody() != null) {
                OpenApiBaseBodyData body2 = $i$f$forEach2;
                boolean bl5 = false;
                if (body2 instanceof OpenApiSimpleBodyData) {
                    descriptors.addAll((Collection)((OpenApiSimpleBodyData)body2).getExamples());
                }
            }
            Iterable $this$forEach$iv3 = route2.getDocumentation().getResponses();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                OpenApiBaseBodyData openApiBaseBodyData;
                OpenApiResponseData response = (OpenApiResponseData)element$iv3;
                boolean bl6 = false;
                if (response.getBody() == null) continue;
                OpenApiBaseBodyData body3 = openApiBaseBodyData;
                boolean bl7 = false;
                if (!(body3 instanceof OpenApiSimpleBodyData)) continue;
                descriptors.addAll((Collection)((OpenApiSimpleBodyData)body3).getExamples());
            }
        }
        return descriptors;
    }

    private final Example generateExample(ExampleDescriptor exampleDescriptor) {
        Example example;
        ExampleDescriptor exampleDescriptor2 = exampleDescriptor;
        if (exampleDescriptor2 instanceof ValueExampleDescriptor) {
            Example example2;
            Example it = example2 = new Example();
            boolean bl = false;
            it.setValue(((ValueExampleDescriptor)exampleDescriptor).getValue());
            it.setSummary(((ValueExampleDescriptor)exampleDescriptor).getSummary());
            it.setDescription(((ValueExampleDescriptor)exampleDescriptor).getDescription());
            example = example2;
        } else if (exampleDescriptor2 instanceof RefExampleDescriptor) {
            Example example3;
            Example it = example3 = new Example();
            boolean bl = false;
            it.set$ref("#/components/examples/" + ((RefExampleDescriptor)exampleDescriptor).getRefName());
            example = example3;
        } else if (exampleDescriptor2 instanceof SwaggerExampleDescriptor) {
            example = ((SwaggerExampleDescriptor)exampleDescriptor).getExample();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return example;
    }

    @Override
    @NotNull
    public Example getExample(@NotNull ExampleDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Example example = this.rootExamples.get(descriptor);
        if (example == null) {
            throw new NoSuchElementException("no root-example for given example-descriptor");
        }
        return example;
    }

    @Override
    @NotNull
    public Map<String, Example> getComponentSection() {
        return this.componentExamples;
    }
}

