/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.ktorswaggerui.routing;

import io.github.smiley4.ktorswaggerui.data.SwaggerUIData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u001a\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/github/smiley4/ktorswaggerui/routing/ApiSpec;", "", "()V", "apiSpecs", "", "", "swaggerUiConfig", "Lio/github/smiley4/ktorswaggerui/data/SwaggerUIData;", "getSwaggerUiConfig", "()Lio/github/smiley4/ktorswaggerui/data/SwaggerUIData;", "setSwaggerUiConfig", "(Lio/github/smiley4/ktorswaggerui/data/SwaggerUIData;)V", "get", "name", "getAll", "", "set", "", "spec", "setAll", "specs", "ktor-swagger-ui"})
public final class ApiSpec {
    @NotNull
    public static final ApiSpec INSTANCE = new ApiSpec();
    @NotNull
    private static SwaggerUIData swaggerUiConfig = SwaggerUIData.Companion.getDEFAULT();
    @NotNull
    private static final Map<String, String> apiSpecs = new LinkedHashMap();

    private ApiSpec() {
    }

    @NotNull
    public final SwaggerUIData getSwaggerUiConfig() {
        return swaggerUiConfig;
    }

    public final void setSwaggerUiConfig(@NotNull SwaggerUIData swaggerUIData) {
        Intrinsics.checkNotNullParameter((Object)swaggerUIData, (String)"<set-?>");
        swaggerUiConfig = swaggerUIData;
    }

    public final void setAll(@NotNull Map<String, String> specs) {
        Intrinsics.checkNotNullParameter(specs, (String)"specs");
        apiSpecs.clear();
        apiSpecs.putAll(specs);
    }

    public final void set(@NotNull String name, @NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        apiSpecs.put(name, spec);
    }

    @NotNull
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = apiSpecs.get(name);
        if (string == null) {
            throw new NoSuchElementException("No api-spec with name '" + name + "' registered.");
        }
        return string;
    }

    @NotNull
    public final Map<String, String> getAll() {
        return apiSpecs;
    }
}

