/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.ktorswaggerui;

import io.ktor.http.ContentType;
import io.ktor.http.content.OutgoingContent;
import java.net.URL;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/github/smiley4/ktorswaggerui/ResourceContent;", "Lio/ktor/http/content/OutgoingContent$ByteArrayContent;", "resource", "Ljava/net/URL;", "<init>", "(Ljava/net/URL;)V", "contentTypes", "", "", "Lio/ktor/http/ContentType;", "bytes", "", "getBytes", "()[B", "bytes$delegate", "Lkotlin/Lazy;", "contentType", "getContentType", "()Lio/ktor/http/ContentType;", "contentType$delegate", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "contentLength$delegate", "toString", "ktor-swagger-ui"})
public final class ResourceContent
extends OutgoingContent.ByteArrayContent {
    @NotNull
    private final URL resource;
    @NotNull
    private final Map<String, ContentType> contentTypes;
    @NotNull
    private final Lazy bytes$delegate;
    @NotNull
    private final Lazy contentType$delegate;
    @NotNull
    private final Lazy contentLength$delegate;

    public ResourceContent(@NotNull URL resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.resource = resource;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"html", (Object)ContentType.Text.INSTANCE.getHtml()), TuplesKt.to((Object)"css", (Object)ContentType.Text.INSTANCE.getCSS()), TuplesKt.to((Object)"js", (Object)ContentType.Application.INSTANCE.getJavaScript()), TuplesKt.to((Object)"json", (Object)ContentType.Application.INSTANCE.getJson()), TuplesKt.to((Object)"png", (Object)ContentType.Image.INSTANCE.getPNG())};
        this.contentTypes = MapsKt.mapOf((Pair[])pairArray);
        this.bytes$delegate = LazyKt.lazy(() -> ResourceContent.bytes_delegate$lambda$0(this));
        this.contentType$delegate = LazyKt.lazy(() -> ResourceContent.contentType_delegate$lambda$0(this));
        this.contentLength$delegate = LazyKt.lazy(() -> ResourceContent.contentLength_delegate$lambda$0(this));
    }

    private final byte[] getBytes() {
        Lazy lazy = this.bytes$delegate;
        return (byte[])lazy.getValue();
    }

    @Nullable
    public ContentType getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (ContentType)lazy.getValue();
    }

    @Nullable
    public Long getContentLength() {
        Lazy lazy = this.contentLength$delegate;
        return (Long)lazy.getValue();
    }

    @NotNull
    public byte[] bytes() {
        return this.getBytes();
    }

    @NotNull
    public String toString() {
        return "ResourceContent \"" + this.resource + "\"";
    }

    private static final byte[] bytes_delegate$lambda$0(ResourceContent this$0) {
        return TextStreamsKt.readBytes((URL)this$0.resource);
    }

    private static final ContentType contentType_delegate$lambda$0(ResourceContent this$0) {
        String string = this$0.resource.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFile(...)");
        String string2 = string;
        String string3 = this$0.resource.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFile(...)");
        int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        String string4 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String extension = string4;
        ContentType contentType = this$0.contentTypes.get(extension);
        if (contentType == null) {
            contentType = ContentType.Text.INSTANCE.getHtml();
        }
        return contentType;
    }

    private static final long contentLength_delegate$lambda$0(ResourceContent this$0) {
        return this$0.getBytes().length;
    }
}

