/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.schemakenerator.swagger.steps;

import io.github.smiley4.schemakenerator.core.data.BaseTypeData;
import io.github.smiley4.schemakenerator.core.data.Bundle;
import io.github.smiley4.schemakenerator.core.data.BundleKt;
import io.github.smiley4.schemakenerator.core.data.TypeId;
import io.github.smiley4.schemakenerator.swagger.data.CompiledSwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.data.RefType;
import io.github.smiley4.schemakenerator.swagger.data.SwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaCompileUtils;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaUtils;
import io.github.smiley4.schemakenerator.swagger.steps.UtilsKt;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0002JR\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0017H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000b*\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileReferenceStep;", "", "pathType", "Lio/github/smiley4/schemakenerator/swagger/data/RefType;", "(Lio/github/smiley4/schemakenerator/swagger/data/RefType;)V", "schemaUtils", "Lio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaUtils;", "compile", "Lio/github/smiley4/schemakenerator/swagger/data/CompiledSwaggerSchema;", "bundle", "Lio/github/smiley4/schemakenerator/core/data/Bundle;", "Lio/github/smiley4/schemakenerator/swagger/data/SwaggerSchema;", "placeholder", "Lio/swagger/v3/oas/models/media/Schema;", "resolve", "refObj", "schemaList", "", "typeDataMap", "", "Lio/github/smiley4/schemakenerator/core/data/TypeId;", "Lio/github/smiley4/schemakenerator/core/data/BaseTypeData;", "components", "", "", "find", "", "id", "schema-kenerator-swagger"})
@SourceDebugExtension(value={"SMAP\nSwaggerSchemaCompileReferenceStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerSchemaCompileReferenceStep.kt\nio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileReferenceStep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SwaggerSchemaCompileReferenceStep {
    @NotNull
    private final RefType pathType;
    @NotNull
    private final SwaggerSchemaUtils schemaUtils;

    public SwaggerSchemaCompileReferenceStep(@NotNull RefType pathType) {
        Intrinsics.checkNotNullParameter((Object)((Object)pathType), (String)"pathType");
        this.pathType = pathType;
        this.schemaUtils = new SwaggerSchemaUtils();
    }

    public /* synthetic */ SwaggerSchemaCompileReferenceStep(RefType refType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            refType = RefType.FULL;
        }
        this(refType);
    }

    @NotNull
    public final CompiledSwaggerSchema compile(@NotNull Bundle<SwaggerSchema> bundle) {
        Intrinsics.checkNotNullParameter(bundle, (String)"bundle");
        List schemaList = BundleKt.flatten(bundle);
        Map<TypeId, BaseTypeData> typeDataMap = UtilsKt.buildTypeDataMap(bundle);
        Map components = new LinkedHashMap();
        Schema root2 = SwaggerSchemaCompileUtils.resolveReferences$default(SwaggerSchemaCompileUtils.INSTANCE, ((SwaggerSchema)bundle.getData()).getSwagger(), 0, new Function1<Schema<?>, Schema<?>>(this, schemaList, typeDataMap, components){
            final /* synthetic */ SwaggerSchemaCompileReferenceStep this$0;
            final /* synthetic */ List<SwaggerSchema> $schemaList;
            final /* synthetic */ Map<TypeId, BaseTypeData> $typeDataMap;
            final /* synthetic */ Map<String, Schema<?>> $components;
            {
                this.this$0 = $receiver;
                this.$schemaList = $schemaList;
                this.$typeDataMap = $typeDataMap;
                this.$components = $components;
                super(1);
            }

            @NotNull
            public final Schema<?> invoke(@NotNull Schema<?> refObj) {
                Intrinsics.checkNotNullParameter(refObj, (String)"refObj");
                return SwaggerSchemaCompileReferenceStep.access$resolve(this.this$0, refObj, this.$schemaList, this.$typeDataMap, this.$components);
            }
        }, 2, null);
        return new CompiledSwaggerSchema(((SwaggerSchema)bundle.getData()).getTypeData(), root2, components);
    }

    private final Schema<?> resolve(Schema<?> refObj, List<SwaggerSchema> schemaList, Map<TypeId, ? extends BaseTypeData> typeDataMap, Map<String, Schema<?>> components) {
        Schema<?> schema;
        String string = refObj.get$ref();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get$ref(...)");
        TypeId referencedId = TypeId.Companion.parse(string);
        SwaggerSchema referencedSchema = this.find((Collection<SwaggerSchema>)schemaList, referencedId);
        if (referencedSchema != null) {
            if (SwaggerSchemaCompileUtils.INSTANCE.shouldReference(referencedSchema.getSwagger())) {
                String refPath = SwaggerSchemaCompileUtils.INSTANCE.getRefPath(this.pathType, referencedSchema.getTypeData(), typeDataMap);
                if (!components.containsKey(refPath)) {
                    components.put(refPath, this.placeholder());
                    components.put(refPath, SwaggerSchemaCompileUtils.resolveReferences$default(SwaggerSchemaCompileUtils.INSTANCE, referencedSchema.getSwagger(), 0, new Function1<Schema<?>, Schema<?>>(this, schemaList, typeDataMap, components){
                        final /* synthetic */ SwaggerSchemaCompileReferenceStep this$0;
                        final /* synthetic */ List<SwaggerSchema> $schemaList;
                        final /* synthetic */ Map<TypeId, BaseTypeData> $typeDataMap;
                        final /* synthetic */ Map<String, Schema<?>> $components;
                        {
                            this.this$0 = $receiver;
                            this.$schemaList = $schemaList;
                            this.$typeDataMap = $typeDataMap;
                            this.$components = $components;
                            super(1);
                        }

                        @NotNull
                        public final Schema<?> invoke(@NotNull Schema<?> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            return SwaggerSchemaCompileReferenceStep.access$resolve(this.this$0, it, this.$schemaList, this.$typeDataMap, this.$components);
                        }
                    }, 2, null));
                }
                schema = this.schemaUtils.referenceSchema(refPath, true);
            } else {
                schema = SwaggerSchemaCompileUtils.INSTANCE.merge(refObj, referencedSchema.getSwagger());
            }
        } else {
            schema = refObj;
        }
        return schema;
    }

    private final Schema<Object> placeholder() {
        return new Schema();
    }

    private final SwaggerSchema find(Collection<SwaggerSchema> $this$find, TypeId id) {
        Object v0;
        block1: {
            Iterable iterable = $this$find;
            for (Object t : iterable) {
                SwaggerSchema it = (SwaggerSchema)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTypeData().getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public SwaggerSchemaCompileReferenceStep() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Schema access$resolve(SwaggerSchemaCompileReferenceStep $this, Schema refObj, List schemaList, Map typeDataMap, Map components) {
        return $this.resolve(refObj, schemaList, typeDataMap, components);
    }
}

