/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.api.conditions;

import io.github.snowdrop.jester.api.DisabledOnQuarkusVersion;
import io.github.snowdrop.jester.utils.QuarkusUtils;
import java.util.Optional;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledOnQuarkusVersionCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisabledOnQuarkusVersion is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        return AnnotationUtils.findRepeatableAnnotations((Optional)element, DisabledOnQuarkusVersion.class).stream().filter(this::isDisabledOnCurrentQuarkusVersion).findAny().map(this::testIsDisabled).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult testIsDisabled(DisabledOnQuarkusVersion disabledOnQuarkus) {
        return ConditionEvaluationResult.disabled((String)("Disabled on Quarkus version (reason: " + disabledOnQuarkus.reason() + ")"));
    }

    private boolean isDisabledOnCurrentQuarkusVersion(DisabledOnQuarkusVersion disabledOnQuarkus) {
        Pattern pattern = Pattern.compile(disabledOnQuarkus.version());
        String quarkusVersion = QuarkusUtils.getVersion();
        return pattern.matcher(quarkusVersion).matches();
    }
}

