/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.resources.quarkus.common;

import io.github.snowdrop.jester.api.Dependency;
import io.github.snowdrop.jester.core.ServiceContext;
import io.github.snowdrop.jester.resources.quarkus.common.JesterBuildChainCustomizerConsumer;
import io.github.snowdrop.jester.resources.quarkus.common.JesterBuildChainCustomizerProducer;
import io.github.snowdrop.jester.resources.quarkus.common.KubernetesCustomProjectBuildStep;
import io.github.snowdrop.jester.resources.quarkus.common.QuarkusResource;
import io.github.snowdrop.jester.utils.ClassPathUtils;
import io.github.snowdrop.jester.utils.FileUtils;
import io.github.snowdrop.jester.utils.MapUtils;
import io.github.snowdrop.jester.utils.PathTestHelper;
import io.github.snowdrop.jester.utils.PropertiesUtils;
import io.github.snowdrop.jester.utils.QuarkusUtils;
import io.github.snowdrop.jester.utils.ReflectionUtils;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.condition.OS;

public class BootstrapQuarkusResource
extends QuarkusResource {
    private static final String NATIVE_RUNNER = "-runner";
    private static final String EXE = ".exe";
    private static final String JVM_RUNNER = "-runner.jar";
    private static final String QUARKUS_APP = "quarkus-app";
    private static final String QUARKUS_RUN = "quarkus-run.jar";
    private static final String DEPENDENCY_SCOPE_DEFAULT = "compile";
    private static final String QUARKUS_GROUP_ID_DEFAULT = "io.quarkus";
    private static final int DEPENDENCY_DIRECT_FLAG = 2;
    private final Path location;
    private final Path runner;
    private final String quarkusVersion;
    private Class<?>[] appClasses;
    private List<AppDependency> forcedDependencies = Collections.emptyList();
    private boolean requiresCustomBuild;
    private Map<String, String> propertiesSnapshot;

    public BootstrapQuarkusResource(ServiceContext context, String location, Class<?>[] classes, Dependency[] forcedDependencies, boolean forceBuild, String quarkusVersion) {
        super(context);
        this.location = Path.of(location, new String[0]);
        this.quarkusVersion = quarkusVersion;
        if (!Files.exists(this.location, new LinkOption[0])) {
            throw new RuntimeException("Quarkus location does not exist.");
        }
        this.requiresCustomBuild = true;
        this.appClasses = classes;
        if (this.appClasses == null || this.appClasses.length == 0) {
            this.appClasses = ClassPathUtils.findAllClassesFromSource(this.location);
            this.requiresCustomBuild = false;
        }
        if (forcedDependencies != null && forcedDependencies.length > 0) {
            this.requiresCustomBuild = true;
            this.forcedDependencies = Stream.of(forcedDependencies).map(d -> {
                String groupId = (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtils.resolveProperty((String)d.groupId()), (CharSequence)QUARKUS_GROUP_ID_DEFAULT);
                String version = (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtils.resolveProperty((String)d.version()), (CharSequence)((String)StringUtils.defaultIfEmpty((CharSequence)quarkusVersion, (CharSequence)QuarkusUtils.getVersion())));
                AppArtifact artifact = new AppArtifact(groupId, d.artifactId(), version);
                if (QuarkusUtils.isQuarkusVersion2Dot3OrAbove()) {
                    return (AppDependency)ReflectionUtils.createInstance(AppDependency.class, (Object[])new Object[]{artifact, DEPENDENCY_SCOPE_DEFAULT, new int[]{2}});
                }
                return new AppDependency(artifact, DEPENDENCY_SCOPE_DEFAULT, new int[0]);
            }).collect(Collectors.toList());
        }
        this.requiresCustomBuild = this.requiresCustomBuild || forceBuild || StringUtils.isNotEmpty((CharSequence)quarkusVersion);
        this.runner = this.tryToReuseOrBuildRunner();
    }

    public Path getRunner() {
        return this.runner;
    }

    private Path tryToReuseOrBuildRunner() {
        Optional runnerLocation = Optional.empty();
        if (!this.containsBuildProperties() && !this.requiresCustomBuild) {
            Path targetLocation = this.location.resolve(PropertiesUtils.TARGET);
            if (QuarkusUtils.isNativePackageType(this.context.getOwner())) {
                Object nativeRunnerExpectedLocation = NATIVE_RUNNER;
                if (OS.WINDOWS.isCurrentOs()) {
                    nativeRunnerExpectedLocation = (String)nativeRunnerExpectedLocation + EXE;
                }
                runnerLocation = FileUtils.findFile((Path)targetLocation, (String)nativeRunnerExpectedLocation);
            } else {
                runnerLocation = FileUtils.findFile((Path)targetLocation, (String)JVM_RUNNER).or(() -> FileUtils.findFile((Path)targetLocation.resolve(QUARKUS_APP), (String)QUARKUS_RUN));
            }
        }
        if (runnerLocation.isEmpty()) {
            return this.buildRunner();
        }
        return Path.of((String)runnerLocation.get(), new String[0]);
    }

    private boolean containsBuildProperties() {
        Map<String, String> differenceProperties = MapUtils.difference(this.context.getOwner().getProperties(), this.propertiesSnapshot);
        Set<String> properties = differenceProperties.keySet();
        if (properties.isEmpty()) {
            return false;
        }
        return properties.stream().anyMatch(QuarkusUtils::isBuildProperty);
    }

    private Path buildRunner() {
        if (this.appClasses.length == 0) {
            throw new RuntimeException("No classes were found at " + this.location + ". You need to build the application before running the tests.");
        }
        if (!QuarkusUtils.isBootstrapDependencyAdded()) {
            throw new RuntimeException("To use custom classes or dependencies, you need to add the dependency `io.quarkus:quarkus-test-common`. Otherwise, you need to build the current module before executing the integration tests");
        }
        try {
            AugmentResult result;
            QuarkusUtils.copyResourcesToServiceFolder(this.location, this.context);
            this.createSnapshotOfBuildProperties();
            Path appFolder = this.context.getServiceFolder();
            JavaArchive javaArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses((Class[])this.appClasses);
            ((ExplodedExporter)javaArchive.as(ExplodedExporter.class)).exportExplodedInto(appFolder.toFile());
            Path testLocation = PathTestHelper.getTestClassesLocation(this.context.getTestContext().getRequiredTestClass());
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setApplicationRoot(appFolder).setMode(QuarkusBootstrap.Mode.PROD).addExcludedPath(testLocation).setIsolateDeployment(true).setProjectRoot(testLocation).setBaseName(this.context.getName()).setTargetDirectory(appFolder);
            if (StringUtils.isNotEmpty((CharSequence)this.quarkusVersion)) {
                Properties properties = new Properties();
                properties.put("quarkus.application.version", this.quarkusVersion);
                builder.setBuildSystemProperties(properties);
            }
            if (!this.forcedDependencies.isEmpty()) {
                ReflectionUtils.invokeMethod((Object)builder, (String)"setForcedDependencies", (Object[])new Object[]{this.forcedDependencies});
            }
            ReflectionUtils.invokeMethod((Object)builder, (String)"setLocalProjectDiscovery", (Object[])new Object[]{true});
            this.configureAdditionalBuildSteps(builder);
            try (CuratedApplication curatedApplication = builder.build().bootstrap();){
                HashMap buildContext = new HashMap();
                AugmentAction action = curatedApplication.createAugmentor(JesterBuildChainCustomizerProducer.class.getName(), buildContext);
                result = action.createProductionApplication();
            }
            return Optional.ofNullable(result.getNativeResult()).orElseGet(() -> result.getJar().getPath());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to build Quarkus artifacts.", ex);
        }
    }

    private void configureAdditionalBuildSteps(QuarkusBootstrap.Builder builder) throws IOException {
        Path additionalDeploymentDir = Files.createDirectories(this.context.getServiceFolder().resolve("additional-deployment"), new FileAttribute[0]);
        JavaArchive additionalDeploymentArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{JesterBuildChainCustomizerProducer.class, JesterBuildChainCustomizerConsumer.class, KubernetesCustomProjectBuildStep.class});
        ((ExplodedExporter)additionalDeploymentArchive.as(ExplodedExporter.class)).exportExplodedInto(additionalDeploymentDir.toFile());
        builder.addAdditionalDeploymentArchive(additionalDeploymentDir);
    }

    private void createSnapshotOfBuildProperties() {
        this.propertiesSnapshot = new HashMap<String, String>(this.context.getOwner().getProperties());
    }
}

