/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.resources.quarkus.kubernetes;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.github.snowdrop.jester.api.Dependency;
import io.github.snowdrop.jester.core.ServiceContext;
import io.github.snowdrop.jester.resources.kubernetes.KubernetesManagedResource;
import io.github.snowdrop.jester.resources.quarkus.common.BootstrapQuarkusResource;
import io.github.snowdrop.jester.utils.DeploymentResourceUtils;
import io.github.snowdrop.jester.utils.DockerUtils;
import io.github.snowdrop.jester.utils.FileUtils;
import io.github.snowdrop.jester.utils.QuarkusUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;

public class ContainerRegistryProdModeBootstrapQuarkusKubernetesManagedResource
extends KubernetesManagedResource {
    private static final String TARGET = "target";
    private static final String DEPLOYMENT = "kubernetes.yml";
    private final String location;
    private final Class<?>[] classes;
    private final Dependency[] forcedDependencies;
    private final boolean forceBuild;
    private final String version;
    private BootstrapQuarkusResource resource;
    private String image;

    public ContainerRegistryProdModeBootstrapQuarkusKubernetesManagedResource(String location, Class<?>[] classes, Dependency[] forcedDependencies, boolean forceBuild, String version) {
        this.location = location;
        this.classes = classes;
        this.forcedDependencies = forcedDependencies;
        this.forceBuild = forceBuild;
        this.version = version;
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public String getImage() {
        return this.image;
    }

    protected String getExpectedLog() {
        return this.resource.getExpectedLog();
    }

    protected int[] getPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(Optional.ofNullable(this.getProperty("quarkus.http.port")).map(Integer::parseInt).orElse(8080));
        Optional.ofNullable(this.getProperty("quarkus.grpc.server.port")).map(Integer::parseInt).ifPresent(grpcPort -> ports.add((Integer)grpcPort));
        return ports.stream().mapToInt(Integer::intValue).toArray();
    }

    protected void init(ServiceContext context) {
        super.init(context);
        this.resource = new BootstrapQuarkusResource(context, this.location, this.classes, this.forcedDependencies, this.forceBuild, this.version);
        this.image = this.createImageAndPush();
    }

    protected Optional<Deployment> loadDeploymentFromFolder() {
        File file = Path.of(TARGET, QuarkusUtils.getKubernetesFolder(this.context.getOwner()), DEPLOYMENT).toFile();
        if (file.exists()) {
            return Optional.ofNullable(DeploymentResourceUtils.loadDeploymentFromString((String)FileUtils.loadFile((File)file)));
        }
        return Optional.empty();
    }

    private String createImageAndPush() {
        String dockerFile = QuarkusUtils.getDockerfile(this.resource.getLaunchMode());
        return DockerUtils.createImageAndPush((ServiceContext)this.context, (String)dockerFile, (Path)this.resource.getRunner());
    }
}

