/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.resources.quarkus.local;

import io.github.snowdrop.jester.api.Dependency;
import io.github.snowdrop.jester.api.Service;
import io.github.snowdrop.jester.core.ServiceContext;
import io.github.snowdrop.jester.resources.local.JavaProcessManagedResource;
import io.github.snowdrop.jester.resources.quarkus.common.BootstrapQuarkusResource;
import io.github.snowdrop.jester.utils.Ports;
import io.github.snowdrop.jester.utils.SocketUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ProdModeBootstrapQuarkusJavaProcessManagedResource
extends JavaProcessManagedResource {
    private final String location;
    private final Class<?>[] classes;
    private final Dependency[] forcedDependencies;
    private final boolean forceBuild;
    private final String version;
    private BootstrapQuarkusResource resource;

    public ProdModeBootstrapQuarkusJavaProcessManagedResource(String location, Class<?>[] classes, Dependency[] forcedDependencies, boolean forceBuild, String version) {
        this.location = location;
        this.classes = classes;
        this.forcedDependencies = forcedDependencies;
        this.forceBuild = forceBuild;
        this.version = version;
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    protected String getHttpPortProperty() {
        return "quarkus.http.port";
    }

    protected Path getRunner() {
        return this.resource.getRunner();
    }

    public boolean isRunning() {
        return super.isRunning() && this.resource.isRunning(this.getLoggingHandler());
    }

    public boolean isFailed() {
        return super.isFailed() || this.resource.isFailed(this.getLoggingHandler());
    }

    protected void init(ServiceContext context) {
        super.init(context);
        this.resource = new BootstrapQuarkusResource(context, this.location, this.classes, this.forcedDependencies, this.forceBuild, this.version);
    }

    protected Map<Integer, Integer> assignCustomPorts() {
        String grpcPort;
        HashMap<Integer, Integer> customPorts = new HashMap<Integer, Integer>();
        if (this.isSslEnabled()) {
            int assignedSslPort = this.getOrAssignPortByProperty("quarkus.http.ssl-port");
            Ports.SSL_PORTS.forEach(sslPort -> customPorts.put(8443, assignedSslPort));
            this.propertiesToOverwrite.put("quarkus.http.ssl-port", "" + assignedSslPort);
        }
        if ((grpcPort = this.getProperty("quarkus.grpc.server.port")) != null) {
            int assignedGrpcPort = SocketUtils.findAvailablePort((Service)this.context.getOwner());
            customPorts.put(Integer.parseInt(grpcPort), assignedGrpcPort);
            this.propertiesToOverwrite.put("quarkus.grpc.server.port", "" + assignedGrpcPort);
        }
        return customPorts;
    }

    private boolean isSslEnabled() {
        return this.getAllComputedProperties().keySet().stream().anyMatch(p -> p.contains("quarkus.http.ssl"));
    }
}

