/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.resources.quarkus.openshift;

import io.github.snowdrop.jester.configuration.BaseConfigurationBuilder;
import io.github.snowdrop.jester.configuration.QuarkusServiceConfiguration;
import io.github.snowdrop.jester.configuration.QuarkusServiceConfigurationBuilder;
import io.github.snowdrop.jester.core.ServiceContext;
import io.github.snowdrop.jester.resources.openshift.OpenShiftManagedResource;
import io.github.snowdrop.jester.utils.Command;
import io.github.snowdrop.jester.utils.FileUtils;
import io.github.snowdrop.jester.utils.MavenUtils;
import io.github.snowdrop.jester.utils.PropertiesUtils;
import io.github.snowdrop.jester.utils.QuarkusUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public class UsingExtensionQuarkusOpenShiftManagedResource
extends OpenShiftManagedResource {
    private static final String USING_EXTENSION_PROFILE = "-Pdeploy-to-openshift-using-extension";
    private static final String QUARKUS_PLUGIN_DEPLOY = "-Dquarkus.kubernetes.deploy=true";
    private static final String QUARKUS_CONTAINER_NAME = "quarkus.application.name";
    private static final String QUARKUS_KUBERNETES_CLIENT_NAMESPACE = "quarkus.kubernetes-client.namespace";
    private static final String QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS = "quarkus.kubernetes-client.trust-certs";
    private static final String QUARKUS_OPENSHIFT_ENV_VARS = "quarkus.openshift.env.vars.";
    private static final String QUARKUS_OPENSHIFT_LABELS = "quarkus.openshift.labels.";
    private static final Path RESOURCES_FOLDER = Paths.get("src", "main", "resources", "application.properties");
    private static final Path TEST_RESOURCES_FOLDER = Paths.get("src", "test", "resources", "application.properties");
    private final Path location;

    public UsingExtensionQuarkusOpenShiftManagedResource(String location) {
        this.location = Path.of(location, new String[0]);
    }

    public String getDisplayName() {
        return this.context.getName();
    }

    protected String getImage() {
        return null;
    }

    protected String getExpectedLog() {
        return ((QuarkusServiceConfiguration)this.context.getConfigurationAs(QuarkusServiceConfiguration.class)).getExpectedLog();
    }

    protected int[] getPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(Optional.ofNullable(this.getProperty("quarkus.http.port")).map(Integer::parseInt).orElse(8080));
        Optional.ofNullable(this.getProperty("quarkus.grpc.server.port")).map(Integer::parseInt).ifPresent(grpcPort -> ports.add((Integer)grpcPort));
        return ports.stream().mapToInt(Integer::intValue).toArray();
    }

    protected void init(ServiceContext context) {
        super.init(context);
        context.loadCustomConfiguration(QuarkusServiceConfiguration.class, (BaseConfigurationBuilder)new QuarkusServiceConfigurationBuilder());
    }

    protected void doInit() {
        this.cloneProjectToServiceAppFolder();
        QuarkusUtils.copyResourcesToServiceFolder(this.location, this.context);
        this.mergePropertiesIntoAppFolder();
        this.deployProjectUsingMavenCommand();
    }

    protected void withAdditionalArguments(List<String> args) {
    }

    private void mergePropertiesIntoAppFolder() {
        Path testPropertiesPath;
        Map<String, String> properties = this.context.getOwner().getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Path applicationPropertiesPath = this.context.getServiceFolder().resolve(RESOURCES_FOLDER);
        if (Files.exists(applicationPropertiesPath, new LinkOption[0])) {
            properties.putAll(PropertiesUtils.toMap((Path)applicationPropertiesPath));
        }
        if (Files.exists(testPropertiesPath = this.context.getServiceFolder().resolve(TEST_RESOURCES_FOLDER), new LinkOption[0])) {
            properties.putAll(PropertiesUtils.toMap((Path)testPropertiesPath));
        }
        PropertiesUtils.fromMap(properties, (Path)this.context.getServiceFolder().resolve(RESOURCES_FOLDER));
    }

    private void deployProjectUsingMavenCommand() {
        MavenUtils.installParentPomsIfNeeded();
        String namespace = this.client.namespace();
        List args = MavenUtils.mvnCommand((ServiceContext)this.context);
        args.addAll(Arrays.asList(USING_EXTENSION_PROFILE, "-B", "-V", "package", QUARKUS_PLUGIN_DEPLOY, "-DskipTests=true", "-DskipITs=true", "-Dcheckstyle.skip"));
        args.add(this.withContainerName());
        args.add(this.withKubernetesClientNamespace(namespace));
        args.add(this.withKubernetesClientTrustCerts());
        args.add(this.withLabelsForWatching());
        args.add(this.withLabelsForScenarioId());
        this.withEnvVars(args, this.context.getOwner().getProperties());
        this.withAdditionalArguments(args);
        try {
            new Command(args).onDirectory(this.context.getServiceFolder()).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to run maven command. Caused by " + e.getMessage()));
        }
    }

    private String withLabelsForWatching() {
        return this.withLabels("tsLogWatch", this.context.getOwner().getName());
    }

    private String withLabelsForScenarioId() {
        return this.withLabels("jesterId", this.context.getJesterContext().getId());
    }

    private String withLabels(String label, String value) {
        return MavenUtils.withProperty((String)(QUARKUS_OPENSHIFT_LABELS + label), (String)value);
    }

    private String withContainerName() {
        return MavenUtils.withProperty((String)QUARKUS_CONTAINER_NAME, (String)this.context.getName());
    }

    private String withKubernetesClientNamespace(String namespace) {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_NAMESPACE, (String)namespace);
    }

    private String withKubernetesClientTrustCerts() {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS, (String)Boolean.TRUE.toString());
    }

    private void withEnvVars(List<String> args, Map<String, String> envVars) {
        for (Map.Entry<String, String> envVar : envVars.entrySet()) {
            String envVarKey = envVar.getKey().replaceAll(Pattern.quote("."), "-");
            args.add(MavenUtils.withProperty((String)(QUARKUS_OPENSHIFT_ENV_VARS + envVarKey), (String)envVar.getValue()));
        }
    }

    private void cloneProjectToServiceAppFolder() {
        FileUtils.copyDirectoryTo((Path)this.location, (Path)this.context.getServiceFolder());
    }
}

