/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.utils;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.junit.jupiter.api.condition.OS;

public final class ClassPathUtils {
    private static final Path SOURCE_CLASSES_LOCATION = Paths.get("target", "classes");
    private static final String CLASS_SUFFIX = ".class";

    private ClassPathUtils() {
    }

    public static Class<?>[] findAllClassesFromSource(Path location) {
        Path sourceClassLocation = location.resolve(SOURCE_CLASSES_LOCATION);
        LinkedList classes = new LinkedList();
        try {
            if (!Files.exists(sourceClassLocation, new LinkOption[0])) {
                return new Class[0];
            }
            try (Stream<Path> stream = Files.walk(sourceClassLocation, new FileVisitOption[0]);){
                stream.map(Path::toString).filter(s -> s.endsWith(CLASS_SUFFIX)).map(s -> ClassPathUtils.normalizeClassName(sourceClassLocation, s)).forEach(className -> {
                    try {
                        classes.add(Thread.currentThread().getContextClassLoader().loadClass((String)className));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't load source classes location.", ex);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static String normalizeClassName(Path sourceClassLocation, String path) {
        String source = sourceClassLocation.relativize(Paths.get(path, new String[0])).toString().replace(CLASS_SUFFIX, "");
        source = OS.WINDOWS.isCurrentOs() ? source.replace("\\", ".") : source.replace("/", ".");
        return source;
    }
}

