/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class PathTestHelper {
    private static final Map<String, String> TEST_TO_MAIN_DIR_FRAGMENTS = new HashMap<String, String>();

    private PathTestHelper() {
    }

    public static Path getTestClassesLocation(Class<?> testClass) {
        String classFileName = testClass.getName().replace('.', File.separatorChar) + ".class";
        URL resource = testClass.getClassLoader().getResource(testClass.getName().replace('.', '/') + ".class");
        if (resource.getProtocol().equals("jar")) {
            try {
                resource = URI.create(resource.getFile().substring(0, resource.getFile().indexOf(33))).toURL();
                return PathTestHelper.toPath(resource);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve the location of the JAR containing " + testClass, e);
            }
        }
        if (!PathTestHelper.isInTestDir(resource)) {
            throw new RuntimeException("The test class " + testClass + " is not located in any of the directories " + TEST_TO_MAIN_DIR_FRAGMENTS.keySet());
        }
        Path path = PathTestHelper.toPath(resource);
        return path.getRoot().resolve(path.subpath(0, path.getNameCount() - Paths.get(classFileName, new String[0]).getNameCount()));
    }

    private static boolean isInTestDir(URL resource) {
        String path = PathTestHelper.toPath(resource).toString();
        return TEST_TO_MAIN_DIR_FRAGMENTS.keySet().stream().anyMatch(path::contains);
    }

    private static Path toPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to translate " + url + " to local path", e);
        }
    }

    static {
        TEST_TO_MAIN_DIR_FRAGMENTS.put("bin" + File.separator + "test", "bin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("out" + File.separator + "test", "out" + File.separator + "production");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "integration-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "integrationTest", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-integrationTest", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-integration-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("quarkus-app-classes-test", "quarkus-app-classes");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "integration-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "integrationTest", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-integrationTest", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-integration-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "integration-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "integrationTest", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-integrationTest", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-integration-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put(File.separator + "test-classes", File.separator + "classes");
        String mappings = System.getenv("TEST_TO_MAIN_MAPPINGS");
        if (mappings != null) {
            Stream.of(mappings.split(",")).filter(s -> !s.isEmpty()).forEach(s -> {
                String[] entry = s.split(":");
                if (entry.length != 2) {
                    throw new IllegalStateException("Unable to parse additional test-to-main mapping: " + s);
                }
                TEST_TO_MAIN_DIR_FRAGMENTS.put(entry[0], entry[1]);
            });
        }
    }
}

