/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.doclet;

import ch.so.agi.gretl.doclet.Property;
import com.sun.source.util.DocTrees;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class GretlDoclet
implements Doclet {
    private String outputDirectory;
    private DocTrees dcTreeUtils;
    private Elements elementsUtils;
    private static final List<String> GRADLE_ANNOTATIONS = new ArrayList<String>(){
        {
            this.add("Internal");
            this.add("Input");
            this.add("InputFile");
            this.add("InputFiles");
            this.add("InputDirectory");
            this.add(GretlDoclet.OPTIONAL_ANNOTATION);
            this.add("OutputFile");
            this.add("OutputDirectory");
        }
    };
    private static final String TASK_ACTION_ANNOTATION = "TaskAction";
    private static final String OPTIONAL_ANNOTATION = "Optional";
    private final Set<Option> options = Set.of(new Option("-d", true, "Output directory path", "<string>"){

        @Override
        public boolean process(String option, List<String> arguments) {
            GretlDoclet.this.outputDirectory = arguments.get(0);
            return true;
        }
    });

    @Override
    public void init(Locale locale, Reporter reporter) {
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment env) {
        File outputDir = new File(this.outputDirectory);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        List clazzes = this.getSpecifiedClasses(env).collect(Collectors.toList());
        Iterator classesIterator = clazzes.iterator();
        this.dcTreeUtils = env.getDocTrees();
        this.elementsUtils = env.getElementUtils();
        while (classesIterator.hasNext()) {
            Element cls = (Element)classesIterator.next();
            if (!this.findTaskAction(cls)) continue;
            File outFile = Paths.get(outputDir.getAbsolutePath(), "_" + cls.toString() + ".md").toFile();
            try (FileWriter fw = new FileWriter(outFile);
                 PrintWriter pw = new PrintWriter((Writer)fw, true);){
                pw.println("Parameter | Datentyp | Beschreibung | Optional");
                pw.println("----------|----------|-------------|-------------");
                TypeElement classElement = (TypeElement)cls;
                ArrayList<Property> properties = new ArrayList<Property>();
                this.getProperties(classElement, properties);
                properties.sort(Comparator.comparing(Property::getName));
                for (Property property : properties) {
                    pw.println(property.getName() + " | `" + property.getType() + "` | " + property.getDescription() + " |\u00a0" + (property.isMandatory() ? "nein" : "ja"));
                }
                pw.println(": {tbl-colwidths=\"[20,20,50,10]\"}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void getProperties(Element cls, List<Property> properties) {
        TypeElement typeElement;
        for (Element element : cls.getEnclosedElements()) {
            boolean isGradlePropertyOrMethod;
            if (!element.getEnclosingElement().toString().startsWith("ch.so.agi.gretl") || !(isGradlePropertyOrMethod = this.elementsUtils.getAllAnnotationMirrors(element).stream().map(annot -> {
                String annotSimpleName = annot.toString().substring(annot.toString().lastIndexOf(".") + 1);
                return annotSimpleName;
            }).anyMatch(GRADLE_ANNOTATIONS::contains))) continue;
            String propertyName = "";
            if (element.getKind() == ElementKind.FIELD) {
                propertyName = element.getSimpleName().toString();
            } else {
                if (element.getKind() != ElementKind.METHOD) continue;
                propertyName = GretlDoclet.extractPropertyName(element.getSimpleName().toString());
            }
            boolean isOptional = this.elementsUtils.getAllAnnotationMirrors(element).stream().map(annot -> {
                String annotSimpleName = annot.toString().substring(annot.toString().lastIndexOf(".") + 1);
                return annotSimpleName;
            }).filter(annot -> annot.contains(OPTIONAL_ANNOTATION)).count() > 0L;
            Property property = new Property();
            property.setName(propertyName);
            if (this.dcTreeUtils.getDocCommentTree(element) != null) {
                property.setDescription(this.dcTreeUtils.getDocCommentTree(element).toString());
            }
            String qualifiedFieldType = element.asType().toString();
            property.setQualifiedType(qualifiedFieldType);
            String unqualifiedFieldType = this.getUnqualifiedFieldType(qualifiedFieldType);
            property.setType(unqualifiedFieldType);
            property.setMandatory(!isOptional);
            properties.add(property);
        }
        TypeElement classElement = (TypeElement)cls;
        if (classElement.getSuperclass() != null) {
            typeElement = this.elementsUtils.getTypeElement(classElement.getSuperclass().toString());
            if (typeElement.getSimpleName().toString().equalsIgnoreCase("Object")) {
                return;
            }
        } else {
            return;
        }
        this.getProperties(typeElement, properties);
    }

    private String getUnqualifiedFieldType(String fieldType) {
        if (!(fieldType = fieldType.replace("()", "")).contains(".")) {
            return fieldType;
        }
        if (!fieldType.contains("<")) {
            return fieldType.substring(fieldType.lastIndexOf(".") + 1);
        }
        StringBuilder unqualifiedFieldType = new StringBuilder();
        String[] partsBracket = fieldType.split("[<]");
        for (int i = 0; i < partsBracket.length; ++i) {
            if (i > 0) {
                unqualifiedFieldType.append("<");
            }
            String[] partsComma = partsBracket[i].split(",");
            for (int ii = 0; ii < partsComma.length; ++ii) {
                unqualifiedFieldType.append(this.getUnqualifiedFieldType(partsComma[ii]));
                if (ii >= partsComma.length - 1) continue;
                unqualifiedFieldType.append(",");
            }
        }
        return unqualifiedFieldType.toString();
    }

    private boolean findTaskAction(Element classElement) {
        for (Element element : classElement.getEnclosedElements()) {
            for (AnnotationMirror annotationMirror : this.elementsUtils.getAllAnnotationMirrors(element)) {
                if (!annotationMirror.toString().endsWith(TASK_ACTION_ANNOTATION)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<? extends Option> getSupportedOptions() {
        return this.options;
    }

    private Stream<TypeElement> getSpecifiedClasses(DocletEnvironment root) {
        return root.getSpecifiedElements().stream().filter(element -> ElementKind.CLASS == element.getKind()).filter(element -> element.getModifiers().contains((Object)Modifier.PUBLIC)).sorted(Comparator.comparing(o -> o.getSimpleName().toString())).map(element -> (TypeElement)element);
    }

    private Stream<PackageElement> getSpecifiedPackages(DocletEnvironment root) {
        return root.getSpecifiedElements().stream().filter(element -> ElementKind.PACKAGE == element.getKind()).map(element -> (PackageElement)element);
    }

    private static String extractPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            String coreName = methodName.substring(3);
            return coreName.substring(0, 1).toLowerCase() + coreName.substring(1);
        }
        return methodName;
    }

    abstract class Option
    implements Doclet.Option {
        private final String name;
        private final boolean hasArg;
        private final String description;
        private final String parameters;

        Option(String name, boolean hasArg, String description, String parameters) {
            this.name = name;
            this.hasArg = hasArg;
            this.description = description;
            this.parameters = parameters;
        }

        @Override
        public int getArgumentCount() {
            return this.hasArg ? 1 : 0;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return List.of(this.name);
        }

        @Override
        public String getParameters() {
            return this.hasArg ? this.parameters : "";
        }
    }
}

