/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.ilivalidator.ext;

import ch.ehi.ili2db.mapping.MultiSurfaceMapping;
import ch.ehi.ili2db.mapping.MultiSurfaceMappings;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iox_j.jts.Iox2jts;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.wkb.Iox2wkb;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import ch.so.agi.ilivalidator.ext.AreaIoxPlugin;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeometryUtils {
    public static final String POLYLINE_TYPE = "PolylineType";
    public static final String SURFACE_OR_AREA_TYPE = "SurfaceOrAreaType";
    public static final String MULTI_SURFACE_TYPE = "MultiSurfaceType";
    public static final String COORD_TYPE = "CoordType";
    public static final String METAATTR_MAPPING = "ili2db.mapping";
    public static final String METAATTR_MAPPING_MULTISURFACE = "MultiSurface";
    public static final String METAATTR_MAPPING_MULTILINE = "MultiLine";
    public static final String METAATTR_MAPPING_MULTIPOINT = "MultiPoint";
    public static final String METAATTR_MAPPING_ARRAY = "ARRAY";
    public static final String METAATTR_DISPNAME = "ili2db.dispName";

    public static Coordinate[] removeDuplicatePoints(Coordinate[] coord) {
        ArrayList<Coordinate> uniqueCoords = new ArrayList<Coordinate>();
        Coordinate lastPt = null;
        for (int i = 0; i < coord.length; ++i) {
            if (lastPt != null && lastPt.equals((Object)coord[i])) continue;
            lastPt = coord[i];
            uniqueCoords.add(new Coordinate(lastPt));
        }
        return uniqueCoords.toArray(new Coordinate[0]);
    }

    public static String getGeometryType(IomObject xtfGeom, IomObject mainObj, HashMap<String, Viewable> tag2class, TransferDescription td) {
        boolean isLine;
        String geomType = null;
        boolean isPolygon = xtfGeom.getattrvaluecount("surface") > 0;
        boolean bl = isLine = xtfGeom.getattrvaluecount("sequence") > 0;
        if (isPolygon) {
            geomType = SURFACE_OR_AREA_TYPE;
        } else if (isLine) {
            geomType = POLYLINE_TYPE;
        } else {
            String c1 = xtfGeom.getattrvalue("C1");
            String c2 = xtfGeom.getattrvalue("C2");
            if (c1 != null && c2 != null) {
                geomType = COORD_TYPE;
            } else {
                Viewable modelele;
                String currentObjectTag = mainObj.getobjecttag();
                Viewable aclass = modelele = tag2class.get(currentObjectTag);
                Iterator iter = aclass.getAttributes();
                while (iter.hasNext()) {
                    LocalAttribute attr = (LocalAttribute)iter.next();
                    String attrName = attr.getName();
                    IomObject attVal = mainObj.getattrobj(attrName, 0);
                    if (attVal == null || !attVal.equals(xtfGeom)) continue;
                    Type type = attr.getDomain();
                    if (!GeometryUtils.isMultiSurfaceAttr(td, (AttributeDef)attr)) continue;
                    geomType = MULTI_SURFACE_TYPE;
                    break;
                }
                if (geomType == null) {
                    return null;
                }
            }
        }
        return geomType;
    }

    public static Geometry geometry2JTS(IomObject object, LocalAttribute attr, String geometryType, double strokeP, TransferDescription td) throws Iox2jtsException {
        Polygon geometry = null;
        try {
            switch (geometryType) {
                case "PolylineType": {
                    geometry = new GeometryFactory().createLineString(Iox2jts.polyline2JTS((IomObject)object, (boolean)false, (double)0.0).toCoordinateArray());
                    break;
                }
                case "SurfaceOrAreaType": {
                    geometry = Iox2jts.surface2JTS((IomObject)object, (double)strokeP);
                    break;
                }
                case "CoordType": {
                    geometry = new GeometryFactory().createPoint(Iox2jts.coord2JTS((IomObject)object));
                    break;
                }
                case "MultiSurfaceType": {
                    Type type = attr.getDomain();
                    if (!GeometryUtils.isMultiSurfaceAttr(td, (AttributeDef)attr)) break;
                    MultiSurfaceMappings multiSurfaceAttrs = new MultiSurfaceMappings();
                    multiSurfaceAttrs.addMultiSurfaceAttr((AttributeDef)attr);
                    MultiSurfaceMapping attrMapping = multiSurfaceAttrs.getMapping((AttributeDef)attr);
                    Iom_jObject iomMultisurface = null;
                    if (object != null) {
                        int surfacec = object.getattrvaluecount(attrMapping.getBagOfSurfacesAttrName());
                        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                            IomObject iomSurfaceStructure = object.getattrobj(attrMapping.getBagOfSurfacesAttrName(), surfacei);
                            IomObject iomPoly = iomSurfaceStructure.getattrobj(attrMapping.getSurfaceAttrName(), 0);
                            IomObject iomSurface = iomPoly.getattrobj("surface", 0);
                            if (iomMultisurface == null) {
                                iomMultisurface = new Iom_jObject("MULTISURFACE", null);
                            }
                            iomMultisurface.addattrobj("surface", iomSurface);
                            try {
                                Polygon polygon = Iox2jts.surface2JTS((IomObject)iomSurface, (double)0.0);
                                continue;
                            }
                            catch (Iox2jtsException e) {
                                Logger.getLogger(AreaIoxPlugin.class.getName()).log(Level.SEVERE, null, e);
                            }
                        }
                    }
                    if (iomMultisurface != null) {
                        try {
                            byte[] geomObj;
                            AttributeDef surfaceAttr = GeometryUtils.getMultiSurfaceAttrDef(type, attrMapping);
                            SurfaceType surface = (SurfaceType)surfaceAttr.getDomainResolvingAliases();
                            CoordType coord = (CoordType)surface.getControlPointDomain().getType();
                            boolean is3D = coord.getDimensions().length == 3;
                            Iox2wkb conv = new Iox2wkb(is3D ? 3 : 2);
                            byte[] bv = geomObj = conv.multisurface2wkb((IomObject)iomMultisurface, surface.getLineAttributeStructure() != null, strokeP);
                            geometry = new WKBReader().read(bv);
                        }
                        catch (Iox2wkbException | ParseException ex) {
                            Logger.getLogger(AreaIoxPlugin.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break;
                    }
                    throw new IllegalArgumentException("Given attribute is not a valid multisurface type");
                }
            }
        }
        catch (Iox2jtsException e) {
            throw new Iox2jtsException(e.getMessage());
        }
        return geometry;
    }

    private static boolean isMultiSurfaceAttr(TransferDescription td, AttributeDef attr) {
        Table struct;
        CompositionType type;
        Type typeo = attr.getDomain();
        return typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L && METAATTR_MAPPING_MULTISURFACE.equals((struct = type.getComponentType()).getMetaValue(METAATTR_MAPPING));
    }

    private static AttributeDef getMultiSurfaceAttrDef(Type type, MultiSurfaceMapping attrMapping) {
        Table multiSurfaceType = ((CompositionType)type).getComponentType();
        Table surfaceStructureType = ((CompositionType)((AttributeDef)multiSurfaceType.getElement(AttributeDef.class, attrMapping.getBagOfSurfacesAttrName())).getDomain()).getComponentType();
        AttributeDef surfaceAttr = (AttributeDef)surfaceStructureType.getElement(AttributeDef.class, attrMapping.getSurfaceAttrName());
        return surfaceAttr;
    }
}

