/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.ilivalidator.ext;

import ch.interlis.iom.IomObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

public class LinkGraphCache {
    private Graph<String, DefaultEdge> graph = new SimpleDirectedGraph(DefaultEdge.class);
    private List<String> duplicateEdges = new ArrayList<String>();
    private Set<String> cycleVertices;

    public LinkGraphCache(Collection<IomObject> collection) {
        for (IomObject iomObj : collection) {
            String startOid = iomObj.getattrobj("Ursprung", 0).getobjectrefoid();
            String endOid = iomObj.getattrobj("Hinweis", 0).getobjectrefoid();
            try {
                DefaultEdge e = null;
                e = (DefaultEdge)Graphs.addEdgeWithVertices(this.graph, (Object)startOid, (Object)endOid);
                if (e != null) continue;
                this.duplicateEdges.add(iomObj.getobjectoid());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        CycleDetector cycleDetector = new CycleDetector(this.graph);
        this.cycleVertices = cycleDetector.findCycles();
    }

    public Graph<String, DefaultEdge> getGraph() {
        return this.graph;
    }

    public List<String> getDuplicateEdges() {
        return this.duplicateEdges;
    }

    public Set<String> getCycleVertices() {
        return this.cycleVertices;
    }
}

