/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.ilivalidator.ext;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Value;
import ch.so.agi.ilivalidator.ext.GeometryUtils;
import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Iterator;

public class TooFewPointsPolylineIoxPlugin
implements InterlisFunction {
    public static final double strokeP = 0.002;
    private LogEventFactory logger = null;
    private HashMap<String, Viewable> tag2class = null;
    private TransferDescription td = null;

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Viewable modelele;
        if (actualArguments[0].skipEvaluation()) {
            return actualArguments[0];
        }
        if (actualArguments[0].isUndefined()) {
            return Value.createSkipEvaluation();
        }
        IomObject xtfGeom = (IomObject)actualArguments[0].getComplexObjects().toArray()[0];
        String currentObjectTag = mainObj.getobjecttag();
        String geomType = GeometryUtils.getGeometryType(xtfGeom, mainObj, this.tag2class, this.td);
        LocalAttribute localAttr = null;
        if (geomType == null) {
            this.logger.addEvent(this.logger.logErrorMsg("Given attribute is not a valid geometry type", new String[0]));
            return Value.createSkipEvaluation();
        }
        Viewable aclass = modelele = this.tag2class.get(currentObjectTag);
        Iterator iter = aclass.getAttributes();
        while (iter.hasNext()) {
            LocalAttribute attr = (LocalAttribute)iter.next();
            String attrName = attr.getName();
            IomObject attVal = mainObj.getattrobj(attrName, 0);
            if (attVal == null || !attVal.equals(xtfGeom)) continue;
            localAttr = attr;
            break;
        }
        try {
            Geometry geometryObject = GeometryUtils.geometry2JTS(xtfGeom, localAttr, geomType, 0.002, this.td);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().toLowerCase().contains("Invalid number of points in LineString".toLowerCase())) {
                return new Value(true);
            }
            this.logger.addEvent(this.logger.logErrorMsg("Given attribute is not a valid polyline.", new String[0]));
        }
        catch (Iox2jtsException e) {
            this.logger.addEvent(this.logger.logErrorMsg(e.getMessage(), new String[0]));
            return Value.createSkipEvaluation();
        }
        return new Value(false);
    }

    public String getQualifiedIliName() {
        return "SO_FunctionsExt.tooFewPointsPolyline";
    }

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        this.logger = logEventFactory;
        this.logger.setValidationConfig(validationConfig);
        this.tag2class = ModelUtilities.getTagMap((TransferDescription)td);
        this.td = td;
    }
}

