/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.ilivalidator.ext;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Value;
import ch.so.agi.ilivalidator.ext.LinkGraphCache;
import java.util.List;
import java.util.Set;

public class IsValidDocumentsCycleIoxPlugin
implements InterlisFunction {
    private LogEventFactory logger = null;
    private ObjectPool objectPool = null;

    public Value evaluate(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].skipEvaluation()) {
            return actualArguments[0];
        }
        if (actualArguments[0].isUndefined()) {
            return Value.createSkipEvaluation();
        }
        try {
            String endOid;
            LinkGraphCache lc = new LinkGraphCache(actualArguments[0].getComplexObjects());
            List<String> duplicateEdges = lc.getDuplicateEdges();
            if (duplicateEdges.contains(mainObj.getobjectoid())) {
                this.logger.addEvent(this.logger.logErrorMsg("duplicate edge found: " + mainObj.getobjectoid(), new String[]{mainObj.getobjectoid()}));
                return new Value(false);
            }
            String startOid = mainObj.getattrobj("Ursprung", 0).getobjectrefoid();
            if (startOid.equals(endOid = mainObj.getattrobj("Hinweis", 0).getobjectrefoid())) {
                this.logger.addEvent(this.logger.logErrorMsg("self loop found: " + startOid, new String[]{startOid}));
                return new Value(false);
            }
            Set<String> vertices = lc.getCycleVertices();
            if (vertices.size() == 0) {
                return new Value(true);
            }
            if (vertices.contains(startOid) && vertices.contains(endOid)) {
                String cycles = String.join((CharSequence)",", vertices);
                this.logger.addEvent(this.logger.logErrorMsg("(" + startOid + " <-> " + endOid + ") is part of a cycle: " + cycles + ".", new String[]{mainObj.getobjectoid()}));
                return new Value(false);
            }
        }
        catch (Exception e) {
            this.logger.addEvent(this.logger.logErrorMsg(e.getMessage(), new String[0]));
            return new Value(false);
        }
        return new Value(true);
    }

    public String getQualifiedIliName() {
        return "SO_FunctionsExt.isValidDocumentsCycle";
    }

    public void init(TransferDescription td, Settings settings, IoxValidationConfig validationConfig, ObjectPool objectPool, LogEventFactory logEventFactory) {
        this.logger = logEventFactory;
        this.logger.setValidationConfig(validationConfig);
        this.objectPool = objectPool;
    }
}

