/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ioxwkf.parquet;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.jts.Iox2jts;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.ioxwkf.parquet.ParquetAttributeDescriptor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class ParquetWriter
implements IoxWriter {
    private File outputFile;
    private org.apache.parquet.hadoop.ParquetWriter<GenericData.Record> writer = null;
    private Schema schema = null;
    private List<ParquetAttributeDescriptor> attrDescs = null;
    private TransferDescription td = null;
    private String iliGeomAttrName = null;
    final long NANOS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final String COORD = "COORD";
    private static final String MULTICOORD = "MULTICOORD";
    private static final String POLYLINE = "POLYLINE";
    private static final String MULTIPOLYLINE = "MULTIPOLYLINE";
    private static final String MULTISURFACE = "MULTISURFACE";
    private Integer srsId = null;
    private Integer defaultSrsId = 2056;

    public ParquetWriter(File file) throws IoxException {
        this(file, null);
    }

    public ParquetWriter(File file, Settings settings) throws IoxException {
        this.init(file, settings);
    }

    private void init(File file, Settings settings) throws IoxException {
        this.outputFile = file;
    }

    public void setModel(TransferDescription td) {
        this.td = td;
    }

    public void setAttributeDescriptors(List<ParquetAttributeDescriptor> attrDescs) {
        this.attrDescs = attrDescs;
    }

    public void write(IoxEvent event) throws IoxException {
        if (!(event instanceof StartTransferEvent) && !(event instanceof StartBasketEvent) && event instanceof ObjectEvent) {
            ObjectEvent obj = (ObjectEvent)event;
            IomObject iomObj = obj.getIomObject();
            String tag = iomObj.getobjecttag();
            if (this.attrDescs == null) {
                this.attrDescs = new ArrayList<ParquetAttributeDescriptor>();
                if (this.td != null) {
                    Viewable aclass = (Viewable)XSDGenerator.getTagMap((TransferDescription)this.td).get(tag);
                    if (aclass == null) {
                        throw new IoxException("class " + iomObj.getobjecttag() + " not found in model");
                    }
                    Iterator viewableIter = aclass.getAttributes();
                    while (viewableIter.hasNext()) {
                        ParquetAttributeDescriptor attrDesc = new ParquetAttributeDescriptor();
                        Object attrObj = viewableIter.next();
                        if (!(attrObj instanceof LocalAttribute)) continue;
                        LocalAttribute localAttr = (LocalAttribute)attrObj;
                        String attrName = localAttr.getName();
                        attrDesc.setAttributeName(attrName);
                        Type iliType = localAttr.getDomainResolvingAliases();
                        if (iliType instanceof NumericalType) {
                            NumericalType numericalType = (NumericalType)iliType;
                            NumericType numericType = (NumericType)numericalType;
                            int precision = numericType.getMinimum().getAccuracy();
                            if (precision > 0) {
                                attrDesc.setBinding(Double.class);
                            } else {
                                attrDesc.setBinding(Integer.class);
                            }
                            this.attrDescs.add(attrDesc);
                            continue;
                        }
                        if (localAttr.isDomainBoolean()) {
                            attrDesc.setBinding(Boolean.class);
                            this.attrDescs.add(attrDesc);
                            continue;
                        }
                        if (localAttr.isDomainIli2Date()) {
                            attrDesc.setBinding(LocalDate.class);
                            this.attrDescs.add(attrDesc);
                            continue;
                        }
                        if (localAttr.isDomainIli2DateTime()) {
                            attrDesc.setBinding(LocalDateTime.class);
                            this.attrDescs.add(attrDesc);
                            continue;
                        }
                        if (localAttr.isDomainIli2Time()) {
                            attrDesc.setBinding(LocalTime.class);
                            this.attrDescs.add(attrDesc);
                            continue;
                        }
                        attrDesc.setBinding(String.class);
                        this.attrDescs.add(attrDesc);
                    }
                } else {
                    for (int u = 0; u < iomObj.getattrcount(); ++u) {
                        String attrName = iomObj.getattrname(u);
                        ParquetAttributeDescriptor attrDesc = new ParquetAttributeDescriptor();
                        if (iomObj.getattrvaluecount(attrName) > 0 && iomObj.getattrobj(attrName, 0) != null) {
                            IomObject iomGeom = iomObj.getattrobj(attrName, 0);
                            if (iomGeom != null) {
                                if (iomGeom.getobjecttag().equals(COORD)) {
                                    attrDesc.setBinding(Point.class);
                                } else if (iomGeom.getobjecttag().equals(MULTICOORD)) {
                                    attrDesc.setBinding(MultiPoint.class);
                                } else if (iomGeom.getobjecttag().equals(POLYLINE)) {
                                    attrDesc.setBinding(LineString.class);
                                } else if (iomGeom.getobjecttag().equals(MULTIPOLYLINE)) {
                                    attrDesc.setBinding(MultiLineString.class);
                                } else if (iomGeom.getobjecttag().equals(MULTISURFACE)) {
                                    int surfaceCount = iomGeom.getattrvaluecount("surface");
                                    if (surfaceCount == 1) {
                                        attrDesc.setBinding(MultiPolygon.class);
                                    } else if (surfaceCount > 1) {
                                        attrDesc.setBinding(MultiPolygon.class);
                                    }
                                } else {
                                    attrDesc.setBinding(Point.class);
                                }
                                if (this.defaultSrsId != null) {
                                    attrDesc.setSrId(this.defaultSrsId);
                                }
                                attrDesc.setGeometry(true);
                            }
                        } else {
                            attrDesc.setBinding(String.class);
                        }
                        attrDesc.setAttributeName(attrName);
                        this.attrDescs.add(attrDesc);
                    }
                }
            }
            if (this.schema == null) {
                this.schema = this.createSchema(this.attrDescs);
                Path path = new Path(this.outputFile.getAbsolutePath());
                try {
                    Configuration conf = new Configuration();
                    this.writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)path).withSchema(this.schema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withCompressionCodec(CompressionCodecName.SNAPPY)).withRowGroupSize(0x8000000)).withPageSize(0x100000)).withConf(conf)).withValidation(false)).withDictionaryEncoding(false)).build();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IoxException(e.getMessage());
                }
            }
            GenericData.Record record = null;
            try {
                record = this.generateRecord(iomObj, this.schema);
            }
            catch (Iox2jtsException e) {
                e.printStackTrace();
                throw new IoxException(e.getMessage());
            }
            try {
                this.writer.write((Object)record);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IoxException(e.getMessage());
            }
        }
    }

    private GenericData.Record generateRecord(IomObject iomObj, Schema schema) throws Iox2jtsException {
        GenericData.Record record = new GenericData.Record(schema);
        for (ParquetAttributeDescriptor attrDesc : this.attrDescs) {
            Coordinate geom;
            String attrName = attrDesc.getAttributeName();
            Object attrValue = null;
            if (attrDesc.getBinding() == Point.class) {
                if (iomObj.getattrobj(attrName, 0) != null) {
                    geom = Iox2jts.coord2JTS((IomObject)iomObj.getattrobj(attrName, 0));
                    attrValue = WKTWriter.toPoint((Coordinate)geom);
                }
            } else if (attrDesc.getBinding() == MultiPoint.class) {
                if (iomObj.getattrobj(attrName, 0) != null) {
                    geom = Iox2jts.multicoord2JTS((IomObject)iomObj.getattrobj(attrName, 0));
                    attrValue = geom.toText();
                }
            } else if (attrDesc.getBinding() == LineString.class) {
                if (iomObj.getattrobj(attrName, 0) != null) {
                    geom = Iox2jts.polyline2JTSlineString((IomObject)iomObj.getattrobj(attrName, 0), (boolean)false, (double)0.0);
                    attrValue = geom.toText();
                }
            } else if (attrDesc.getBinding() == MultiLineString.class) {
                if (iomObj.getattrobj(attrName, 0) != null) {
                    geom = Iox2jts.multipolyline2JTS((IomObject)iomObj.getattrobj(attrName, 0), (double)0.0);
                    attrValue = geom.toText();
                }
            } else if (attrDesc.getBinding() == Polygon.class) {
                if (iomObj.getattrobj(attrName, 0) != null) {
                    geom = Iox2jts.surface2JTS((IomObject)iomObj.getattrobj(attrName, 0), (double)0.0);
                    attrValue = geom.toText();
                }
            } else if (attrDesc.getBinding() == MultiPolygon.class) {
                if (iomObj.getattrobj(attrName, 0) != null) {
                    geom = Iox2jts.multisurface2JTS((IomObject)iomObj.getattrobj(attrName, 0), (double)0.0, (int)2056);
                    attrValue = geom.toText();
                }
            } else if (attrDesc.getBinding() == String.class) {
                attrValue = iomObj.getattrvalue(attrName);
            } else if (attrDesc.getBinding() == Integer.class) {
                if (iomObj.getattrvalue(attrName) != null) {
                    attrValue = (int)Integer.valueOf(iomObj.getattrvalue(attrName));
                }
            } else if (attrDesc.getBinding() == Double.class) {
                if (iomObj.getattrvalue(attrName) != null) {
                    attrValue = (double)Double.valueOf(iomObj.getattrvalue(attrName));
                }
            } else if (attrDesc.getBinding() == LocalDate.class) {
                if (iomObj.getattrvalue(attrName) != null) {
                    LocalDate localDate = LocalDate.parse(iomObj.getattrvalue(attrName), DateTimeFormatter.ISO_LOCAL_DATE);
                    attrValue = (int)localDate.toEpochDay();
                }
            } else if (attrDesc.getBinding() == LocalDateTime.class) {
                if (iomObj.getattrvalue(attrName) != null) {
                    LocalDateTime localDateTime = LocalDateTime.parse(iomObj.getattrvalue(attrName));
                    long offset = ChronoUnit.MILLIS.between(localDateTime.atZone(ZoneId.systemDefault()), localDateTime.atZone(ZoneOffset.UTC));
                    attrValue = Long.valueOf(localDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli()) - offset;
                }
            } else if (attrDesc.getBinding() == LocalTime.class) {
                if (iomObj.getattrvalue(attrName) != null) {
                    LocalTime localTime = LocalTime.parse(iomObj.getattrvalue(attrName));
                    LocalDateTime localDateTime = LocalDateTime.parse("1970-01-01T12:00:00");
                    long offset = ChronoUnit.MILLIS.between(localDateTime.atZone(ZoneId.systemDefault()), localDateTime.atZone(ZoneOffset.UTC));
                    int milliOfDay = (int)(localTime.toNanoOfDay() / 1000000L);
                    attrValue = (long)milliOfDay - offset;
                }
            } else if (attrDesc.getBinding() == Boolean.class) {
                if (iomObj.getattrvalue(attrName) != null) {
                    attrValue = Boolean.parseBoolean(iomObj.getattrvalue(attrName));
                }
            } else {
                attrValue = iomObj.getattrvalue(attrName);
            }
            record.put(attrName, attrValue);
        }
        return record;
    }

    private Schema createSchema(List<ParquetAttributeDescriptor> attrDescs) {
        Schema schema = Schema.createRecord((String)"myrecordname", null, (String)"ch.so.agi.ioxwkf.parquet", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (ParquetAttributeDescriptor attrDesc : attrDescs) {
            String doc;
            Schema.Field field = null;
            if (attrDesc.isGeometry().booleanValue()) {
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null);
            } else if (attrDesc.getBinding() == String.class) {
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null);
            } else if (attrDesc.getBinding() == Integer.class) {
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null);
            } else if (attrDesc.getBinding() == Double.class) {
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null);
            } else if (attrDesc.getBinding() == LocalDate.class) {
                LogicalTypes.Date dateType = LogicalTypes.date();
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{dateType.addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null);
            } else if (attrDesc.getBinding() == LocalDateTime.class) {
                LogicalTypes.TimestampMillis datetimeType = LogicalTypes.timestampMillis();
                doc = "UTC based timestamp.";
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{datetimeType.addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.create((Schema.Type)Schema.Type.NULL)}), doc, null);
            } else if (attrDesc.getBinding() == LocalTime.class) {
                LogicalTypes.TimeMillis timeType = LogicalTypes.timeMillis();
                doc = "UTC based time.";
                field = new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{timeType.addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), Schema.create((Schema.Type)Schema.Type.NULL)}), doc, null);
            } else {
                field = attrDesc.getBinding() == Boolean.class ? new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null) : new Schema.Field(attrDesc.getAttributeName(), Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)}), null, null);
            }
            fields.add(field);
        }
        schema.setFields(fields);
        return schema;
    }

    public void close() throws IoxException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IoxException(e.getMessage());
        }
    }

    public IomObject createIomObject(String arg0, String arg1) throws IoxException {
        return null;
    }

    public void flush() throws IoxException {
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return null;
    }

    public void setFactory(IoxFactoryCollection arg0) throws IoxException {
    }
}

