/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.meta2file.in.db;

import ch.so.agi.meta2file.except.Meta2FileException;
import ch.so.agi.meta2file.in.Read;
import ch.so.agi.meta2file.in.db.TpQuery;
import ch.so.agi.meta2file.model.ThemePublication;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TpIterator
implements Iterator<ThemePublication> {
    private static final Logger log = LoggerFactory.getLogger(TpIterator.class);
    private static final int FETCH_SIZE = 10;
    private Connection con;
    private UUID themePubUid;
    private ResultSet rs;

    public TpIterator(Connection con) {
        this(con, null);
    }

    public TpIterator(Connection con, UUID themePubUid) {
        this.con = con;
        this.themePubUid = themePubUid;
    }

    @Override
    public boolean hasNext() {
        if (this.rs == null) {
            this.initResultSet();
        }
        boolean res = false;
        try {
            res = !this.rs.isLast();
        }
        catch (SQLException se) {
            throw new RuntimeException(se);
        }
        return res;
    }

    private void initResultSet() {
        try {
            String sql = null;
            sql = this.themePubUid == null ? TpQuery.singleton().queryForAllThemePubs() : TpQuery.singleton().queryForOneThemePub(this.themePubUid);
            PreparedStatement s = this.con.prepareStatement(sql);
            s.setFetchSize(10);
            this.rs = s.executeQuery();
        }
        catch (SQLException se) {
            throw new Meta2FileException(se);
        }
    }

    @Override
    public ThemePublication next() {
        ThemePublication res = null;
        if (this.rs == null) {
            this.initResultSet();
        }
        try {
            boolean couldIterate = this.rs.next();
            if (!couldIterate) {
                throw new Meta2FileException("Resultset is exhausted. Use hasNext() to break your iteration.");
            }
            String jsonString = this.rs.getString("tp_json");
            res = Read.fromJson(jsonString);
            log.info("Processing {}", (Object)res.getIdentifier());
        }
        catch (SQLException throwables) {
            throw new Meta2FileException(throwables);
        }
        return res;
    }
}

