/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.meta2file.model;

import ch.so.agi.meta2file.libmain.BaseUrl;
import ch.so.agi.meta2file.model.BoundingBox;
import ch.so.agi.meta2file.model.FileFormat;
import ch.so.agi.meta2file.model.Item;
import ch.so.agi.meta2file.model.Layer;
import ch.so.agi.meta2file.model.Office;
import ch.so.agi.meta2file.model.Service;
import ch.so.agi.meta2file.model.ServiceType;
import ch.so.agi.meta2file.model.TableInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.net.URI;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.NotNull;

@JacksonXmlRootElement(localName="themePublication")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ThemePublication {
    @NotNull
    private String identifier;
    private String model;
    @NotNull
    private LocalDate lastPublishingDate;
    @NotNull
    private LocalDate secondToLastPublishingDate = LocalDate.of(1848, 9, 12);
    @NotNull
    private String title;
    @JacksonXmlCData
    @NotNull
    private String shortDescription;
    @JacksonXmlElementWrapper(localName="keywords")
    @JacksonXmlProperty(localName="keyword")
    private List<String> keywordsList;
    @JacksonXmlElementWrapper(localName="synonyms")
    @JacksonXmlProperty(localName="synonym")
    private List<String> synonymsList;
    @NotNull
    private Office owner;
    @NotNull
    private Office servicer;
    private URI furtherInformation;
    @NotNull
    private URI licence;
    @JacksonXmlElementWrapper(localName="fileFormats")
    @JacksonXmlProperty(localName="fileFormat")
    @NotNull
    private List<FileFormat> fileFormats;
    @NotNull
    @JacksonXmlElementWrapper(localName="items")
    @JacksonXmlProperty(localName="item")
    private List<Item> items;
    @JacksonXmlElementWrapper(localName="tablesInfo")
    @JacksonXmlProperty(localName="tableInfo")
    private List<TableInfo> tablesInfo;
    @JacksonXmlElementWrapper(localName="services")
    @JacksonXmlProperty(localName="service")
    private List<Service> services;
    private BoundingBox bbox;
    private Layer wgcPreviewLayer;

    @Deprecated
    public String getPreviewUrl() {
        if (this.services == null || this.services.size() == 0) {
            return null;
        }
        String res = null;
        Service wgc = null;
        for (Service s : this.services) {
            if (s.getType() != ServiceType.WGC) continue;
            wgc = s;
            break;
        }
        if (wgc == null) {
            return null;
        }
        for (Layer l : wgc.getLayers()) {
            if (!this.identifier.equals(l.getIdentifier())) continue;
            URI full = BaseUrl.WGC.getBaseUrlAsUri().resolve("map?l=" + l.getIdentifier());
            res = full.toString();
            break;
        }
        return res;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public LocalDate getLastPublishingDate() {
        return this.lastPublishingDate;
    }

    public void setLastPublishingDate(LocalDate lastPublishingDate) {
        this.lastPublishingDate = lastPublishingDate;
    }

    public LocalDate getSecondToLastPublishingDate() {
        return this.secondToLastPublishingDate;
    }

    public void setSecondToLastPublishingDate(LocalDate secondToLastPublishingDate) {
        this.secondToLastPublishingDate = secondToLastPublishingDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public List<String> getSynonymsList() {
        return this.synonymsList;
    }

    public void setSynonymsList(List<String> synonymsList) {
        this.synonymsList = synonymsList;
    }

    public List<String> getKeywordsList() {
        return this.keywordsList;
    }

    public void setKeywordsList(List<String> keywordsList) {
        this.keywordsList = keywordsList;
    }

    public Office getOwner() {
        return this.owner;
    }

    public void setOwner(Office owner) {
        this.owner = owner;
    }

    public Office getServicer() {
        return this.servicer;
    }

    public void setServicer(Office servicer) {
        this.servicer = servicer;
    }

    public URI getFurtherInformation() {
        return this.furtherInformation;
    }

    public void setFurtherInformation(URI furtherInformation) {
        this.furtherInformation = furtherInformation;
    }

    public URI getLicence() {
        return this.licence;
    }

    public void setLicence(URI licence) {
        this.licence = licence;
    }

    public List<FileFormat> getFileFormats() {
        return this.fileFormats;
    }

    public void setFileFormats(List<FileFormat> fileFormats) {
        this.fileFormats = fileFormats;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public List<TableInfo> getTablesInfo() {
        return this.tablesInfo;
    }

    public void setTablesInfo(List<TableInfo> tablesInfo) {
        this.tablesInfo = tablesInfo;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public BoundingBox getBbox() {
        return this.bbox;
    }

    public void setBbox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    public Layer getWgcPreviewLayer() {
        return this.wgcPreviewLayer;
    }

    public void setWgcPreviewLayer(Layer wgcPreviewLayer) {
        this.wgcPreviewLayer = wgcPreviewLayer;
    }
}

