/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.meta2file.out;

import ch.so.agi.meta2file.Util;
import ch.so.agi.meta2file.except.Meta2FileException;
import ch.so.agi.meta2file.model.ThemePublication;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaBean2FileConverter {
    static Logger log = LoggerFactory.getLogger(MetaBean2FileConverter.class);
    private static final String XSL2HTML_FILE = "xml2html.xsl";
    private static XmlMapper xmlMapper = null;

    public static void runBeans2Xml(Path xmlFilePath, Iterator<ThemePublication> themePublicationsIterator) {
        if (xmlMapper == null) {
            MetaBean2FileConverter.initMapper();
        }
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, false);
        xmlMapper.disable(SerializationFeature.INDENT_OUTPUT);
        XMLOutputFactory xof = XMLOutputFactory.newFactory();
        try {
            XMLStreamWriter xsw = xof.createXMLStreamWriter(new FileWriter(xmlFilePath.toFile().getAbsolutePath()));
            xsw.writeStartDocument("utf-8", "1.0");
            xsw.writeStartElement("themePublications");
            while (themePublicationsIterator.hasNext()) {
                ThemePublication themePub = themePublicationsIterator.next();
                xmlMapper.writeValue(xsw, (Object)themePub);
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw new Meta2FileException(e.getMessage());
        }
    }

    public static void runBean2Html(Path htmlFilePath, ThemePublication themePublications) {
        if (xmlMapper == null) {
            MetaBean2FileConverter.initMapper();
        }
        try {
            String xmlResult = xmlMapper.writeValueAsString((Object)themePublications);
            File tmpFolder = Files.createTempDirectory("metabean2file-", new FileAttribute[0]).toFile();
            File xmlFile = Paths.get(tmpFolder.getAbsolutePath(), themePublications.getIdentifier() + ".xml").toFile();
            xmlMapper.writeValue(xmlFile, (Object)themePublications);
            File xslFile = Paths.get(tmpFolder.getAbsolutePath(), XSL2HTML_FILE).toFile();
            Util.loadFile(XSL2HTML_FILE, xslFile);
            File htmlFile = htmlFilePath.toFile();
            Processor processor = new Processor(false);
            XsltCompiler compiler = processor.newXsltCompiler();
            XsltExecutable stylesheet = compiler.compile((Source)new StreamSource(xslFile));
            Serializer out = processor.newSerializer(htmlFile);
            Xslt30Transformer transformer = stylesheet.load30();
            transformer.transform((Source)new StreamSource(xmlFile), (Destination)out);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new Meta2FileException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Meta2FileException(e.getMessage());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
            throw new Meta2FileException(e.getMessage());
        }
    }

    public static String runBean2Html(ThemePublication themePub) {
        String res = null;
        try {
            Path out = Files.createTempFile("", ".html", new FileAttribute[0]);
            MetaBean2FileConverter.runBean2Html(out, themePub);
            byte[] content = Files.readAllBytes(out);
            res = new String(content, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new Meta2FileException(e);
        }
        return res;
    }

    private static void initMapper() {
        xmlMapper = new XmlMapper();
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        xmlMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        xmlMapper.registerModule((Module)new JavaTimeModule());
    }
}

