<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0">
    <xsl:output encoding="UTF-8" indent="yes" method="html"/>
    <xsl:template match="/themePublication">
        <html>
        <head>
            <title>Datenbeschreibung • Amt für Geoinformation Kanton Solothurn</title>
            <meta name="description" content="Metadaten der Geodaten des Kantons Solothurn."/>
            <meta name="keywords" content="Metadaten, Geodaten, Datenmodell, Solothurn, AGI, SOGIS"/>
            <meta name="author" content="Stefan Ziegler" />
            <meta name="viewport" content="width=device-width, initial-scale=1" />
            <meta http-equiv="cache-control" content="no-cache"/>

            <style>
                @font-face {
                    font-family:Frutiger;
                    font-weight:400;
                    src:url(data:application/font-woff;base64,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) format("woff");
                }

                @font-face {
                    font-family:Frutiger;
                    font-weight:700;
                    src:url(data:application/font-woff;base64,d09GRgABAAAAAISYAA8AAAABIFAAAQAAAACAmAAABAAAAAmbAAAAAAAAAABPUy8yAAABWAAAAFgAAABgZyTZ02NtYXAAAAGwAAAAqAAAANx3NJY9Y3Z0IAAAAlgAAABDAAAARgW5Dr5mcGdtAAACnAAAAP4AAAFiMo1zZmdhc3AAAAOcAAAAEAAAABAALwAKZ2x5ZgAAA6wAAGn3AADr7FEU1fNoZWFkAABtpAAAADYAAAA28j+EwmhoZWEAAG3cAAAAHwAAACQHiAO4aG10eAAAbfwAAAHLAAADnAkZIEdrZXJuAABvyAAAA9QAAAmchcuMG2xvY2EAAHOcAAACgQAAA6AAdGRsbWF4cAAAdiAAAAAgAAAAIAL/BDNuYW1lAAB2QAAACUkAAB048TprsHBvc3QAAH+MAAAAEwAAACD/uAAycHJlcAAAf6AAAAD2AAABwc/1fCB4nGNgZvJgnMDAysDB1MUUwcDA4A2hGeMYjBh+MTAwcXMxs7CyMDOxNDAw6AswMHAxQIGPp58/kOJ9zMH07j8bwwnmXSD1DIwgOSZOpl0MCkDIAABQ1Q0teJxjYGBgZGAGYgYGHgYWhgtA2oBBAcgSYOBlqGP4z2jIGMyYyFjBWMc4iek40y2mOwoiClIKcgpKCmoKBgpWCmsUlR6zPub4/x+okxeocwFQRxBjAlBHLVDHMbAOYQUJBRkFBbAOS7AOBpCO/1//P/5/6P/E/4X/U//7//f+b/GP9e/nv58e7Hmw88GOB9sfbHmw+sHiB0b398o+kL0HdiNJAABFeT1ReJxjkGGoY5jA0MSQwqACxAsYjIDkLoYuoOgqhlogez5DNkMkUAQiw8DA/1+PgZeJnYGfaRcDD9M7ID7FIAcADLoOfgB4nF2PPU7EMBCFbRwWcgMkC2ksKxQrr+ipUjiRUJpAKDwNP9KuRPYOSCmgccFZhs50uRiCSTbagsYz783o85skhGuSyNvwJeUnJvn7kcT75bfIhXp63CQhHUDVe5LPLE4cG2vDnXJQkyrq+2ARIsTbbYQaXl+2lBVz5cEu4jWQ6ELP70MwVKI+tjvEG+ZkEyebORGZsF8I+5nAgB9eOnUNkLpqw12gwWsqPWpjoKKxDTR6bRB5a3VMyvWtv1gyn3Hm1Zqb8wOlYwYjMMaDsobGGHXkOxadpPhvlIvBh08AVVRJDu08GqzRk2GNNRwLPX+Vu6YLFQczuPkDbbdnTwAAAAAAAwAIAAIAKAAD//8AAnicnL0JYFvVlTD83pMlWZZtSdYuWZYsWZJt2ZZsxZbtOI6VxbGzh4RsYBK2sJQtlLXQQEvK1pmSaVlC6TfQBQi0UzJfKQ1mBtL2K+1Mp62nM/Qb2kyhdEo7nRbo99GNSeT/nHPveXpPdoDvJzzrvPveu+++e8892z3nXEVTPqIo6lJtVrEoduXSo45WRzix5vol9y87ptjyZYtSUGyKOvMsXGw4OasocGb3tIzMKqqElGOKNX9MUVbvxAeiz0JxbHyXLLBggUUJju96Fh61n4T64ooV6iv0l4r+VCllKd595MgDt0dmP/e536rfg3s05RPqF9WXZHt2mdqjiPZAe2eOKeoJKHAfU+pOQOFypY4KrScU+WYF36yIplj41jmA4dc+V+j3Fj0pPD5x8OA3Dx7UZiu/U12V3+H7R+FPN70/rtkN759VwkpMseSOKTGoowHqbD6BHdKshKEboBFR2bIGuOzEVu1RnFSA97eKglYowL5zKq3UixqUOAmyQPXNBFnhNQ0E2ZQGJcaV26guG7Ufjvys4pCXZ5VGvcIm2R5oHdzpEm910aNhKAiJghA1ww0XQvSUV0LHFC/c1AL1t0D9PrjPRdeDEjqmBOF6AK4H4HpEb3JU/4w22fhjShvcGYc743keEyeOidOAHq1Y0IroUf2EY0ojDrMLCsQw04lKDdb0ezRAOStUrsJLbPDbCL8O+HXCb7M8d8vrXvjV4Ncnf6MwdEGAWwEOw28UftsAJdSyVdkO79gHhzZDJz448cGJmrIX24ul1GCxVLTT4U/RASiMh3r5DteOyonzXdvOj1wa2RG+JLx6m2v1tsglkR1wvk2974orLnsW/rvsisueg/8AUSxKZv6vteWWqFIPn7dU/bAJ0yyKHzANvvxKANQZAI5CGQEFBPZD6+YAeBUODUsP8eWrCBB43g342Q8VdFOX9UOXFXAmwCf74WojwP3wuxTOXXBE4CjAeWxuVknoTyXyojQNpSW9tKSPaQyHMGYY0wEsGMAxFVUrc4hoMWWAHnRDVfVzYkp0zEF7H1M6qL0OuM2l34aXsT0uejNUCr95+Vuaw/cfU4blkLmhNxNIOfDz3UA01BkqrYfSejGQbviXgEOeLIWTpXCiwAOdcK7OpMfVwSV9WtbSrPp9gaC9zzK4ZFwrDRb9A3impvxtFr+vWbP7U4NJuK/UphbVyc68Oxx35ZO9+URT9xkTnZkVOwbG8helGpN7c4Uzy5ncml19Y6HR4X5XU35v3w112VxLxNNgUQtaOtaerPuMLbFkujC0oRjRzjyz2XOHJ/iAs7W4aay0eSiibt9eZ2uwfcLrgS+zKoX5X1uOaXMwT7NKDqjdVnXaRBl90B8TeaKuPkYTH/Wrz41ksPEkQoDmgli2cR+1QU+0QU88C5QE75mAu3skdExZK+5ey3evhbvX0t1DcA9dOxOuASp0wvu7mQuEEQPCBpTYhAWbBEogEUqdEJM3TBQKrsNv/5z4XX0C0UaM7ONKu/I1OGjYjihpeFFanDymbFCegUNe2QJXttCA4lk7nC320BPwwLP80BPwwLP0kNfXphUHxjVEgFQSxhhGvjjQpuF4p2CwYaRT6fe458uaw9fS4nNo/HugpWtlf//Krhb+1dZdXrntCvUn73mj+kdvVyoQSHV5vV3JYDDZ5c2tH04khtfneteX4vHSetV2KvLye9yD9KVn/m2tor1Is2pK/YAJX/pgrJZAjy8RHHUJoQoShj5AADdweoQQXY4pUzAxQ1A2ReS9XelT2gRH2gcnhGpfJWBWWQ33tYtrMI5UZAXcW00zeglUNw7VNcwht1gi+U5GPoJ0istWymeYwowg9owY0KkLC7oEOlFBCgtSgo1Y4dYueuMIvLEJPqkLfv1z2DxxBZo3Sc0D4BkGHpUNzlRvmoYTLArBpYzkcuIidgOX9cMbowRNyauAu4AtwXEgIZlU0mYh1Bkq9anZZjXdrNqDKQIRbQaXYPmgAZnsgeC4WlLVJl/Q2RSLePoSie6cN9HpTxQimQ2dsaQWtJT6b/620+fs/eDIwJ61vVPl7u7uFVu7+nas6op0D7UuWxryaVrAFQ356u3eYKsnHu+ofCaYCje1+LrXpd3dd6y8uXB3c7QxG4ks2Tw0vaOtfW1f30S2xdO5or+92J10D41EViQVFGaUC9UvKv9JslCuRhJDzry4rCVkqwuFUAV1rJ6/Rr1eexskk+U1PK6BpCkUl5qQL50QrLyJJBwYgHmSW+AlTXmUd6BfBXVOYZcNldTrV2xcv+wTa7fuXq29fdFPb7rx1YsueOXDN/3sAnhnM7xzYpF3whv1d9rxfZIf2glXjO+0ITWDdwaRM2SyxTZ4tc3eXN60qfypddt2r/6LfT+78cbXLjz35zfjG7Gv9qo9mgX6qln5iOmd9XDNkuO+qsO+qhN9hV/tJFpnUV4EoYPILBBYZTdKIMjjbwR2dhccxNs+LXibBagaykbIvXbiU/sBOGy+5s2WgtmivRS0B+1Ze/aNT2Q+5v+Q76PpQ/suXDl1nvqT6DUrPnlo4trwRdMfuXUNtC8P7LNLfQfEq8tM4+wQ9MEhRDHoKAfQh3piEChM17tFFzpI4uVPdOAnOsT8bDjxLMpucL92Qkhj+FyDLoQDhwUxCrhqKv/8gefhf3UM/z4PD2nzn1J+q3wORixhaNNzcKUJ+ruOejQvEK5UtKRWHznvrs+hBI9jEVe+q/apm2qeRQESx195Dn+oEmhDu789jrK/uukgPbsa/or35k19Yck/C8/7Tiqn0W2ESrP6yJHPfQ7rmf+v+bfVHNBfizJsaoMq2rDI3KECDQs0rBb7x5L6mwPfOKC9eKqPdKMU0PQy1IlywL+aWhcW3D8skGg5AJvgIFa3F4CrxAnKkWGpKcHJBOlicMtxBeVJq7jlKixFpFIYOCTuQ/FKApvpErLwZ2HGIL+wupEGNwixoEtMIvqgNvygNsMX+rDAxx2HuNHmRgFEhS5MG5isH8koUckqfVQH4ukWq7UlHU904G9HYseloz7f6KU75O/V3au2dndvXdXNvwfGL/zoqlUfvXCcf3GMy/DnhxoqWNsXarwTpGpRXwnV10qqrwXOrAa+JMe/+l1S+6WRU+3ZElBBNXRw62+/MKsp5xz49KlJgZvdMJApGMO48h+md1vx3Q9xB1/LQ4NjtJmGBkkVFOyBWq5keTcudU4iXhfAzKCxhe4M0KCg1tuKD30M1Kz74KCHtpMaCsDnGVhJAGh1JP/zF3rwgzyGL5RDSYzWAlfaiNF6iCaoJ1Eh5DIc0RiNaEkyQuBt2XGVx9GlwrTrHrx85/BId3BgoMdtX3dhfPT8NZ2FVVPhAdVXsX+sb89Z21L5rvqmFsdfRZvDxQ1LihfsWOPPHcQ+hHmQhT4cVXeY+jCRJ1KqMJImBP7ejQCWzDLgZuA4AaBZoHaRxw/Bfkugqiw6OwSdHUJqbFF+QHozlM4AcDmWzpTt8JkhpReOZXBYQF7ohN8EdUIn6MhOOK8XmpQ+VUJQ++gctXRUtOJ+Bs5gYC8C+0+La9U5NAsKgUXx0StyeWjcK1DwJhyaIAQ5IAQ5EtrTMB5Q8xACM9iynJKmx1BHiNJEtABUomHz8ljZ7H7kfSjnZkjv0WeozT4YKA4Yz5cXzh3tP29j/+To8vUjuy4rLv1AxpHcNeDv745FO3vcwYwnBEKvuzMZCiRz/vyZbdoTzS5Pbu3I2Aa31rR5RXnrgLeh+VO+pnpvKhpNuK2qerNW39LmD8dbbM3NCtHAevizhWSSZuUl0+g352nQm4kyoShB0/k5MZ2t0A82GE+b6JgfAPCKOLEol/GMf4iBpdLcos2hIeVZmFg4cI45HAWEmomD8fDYcTTshuFpxoJmMTx1cKWZ+rkuj/Yiu1IHZ1gR9rhN2qTQeFGHWjnKAylL0d4+qBY9xBvV9drzxxsr31FD3z///C9r3ZWXD9yrfrYyfeBjRE9WwVwYgP5Iq2tNvRHLEwmLMT7FxFw4j0t+zECRgaPiHhTaY6SzE9bfypfdBDwLAgb2gCa1+PQJMlOkxZMuAOJC4ZKlCLwiALvyMABPwfECHJYZYhVpMThcqplqwfffSbeg4AAnu6WhL01CPfe/it2tGvpfUi4SQVQ38lMkTyAiKR4aCXtekK0QjYEdoCRPjiRZJ1Eq8FfJ1SK4v1n9duVlX8QxeO50z5LtV44uOTtn6TyzN1zsDLf2lFoz6zPa7IFrNC205IzR6fPGws3OB3wtDeGe9lg21GBvELjcBWO3lHS0omo3jV5O8POc6MDlBGB7iapD1+dI9CJ8t4muR7a1mTH6KCNyQlxGrm7jYZTAHAMK3fMsaDXI54rwLqnGnQ0n8v2DBo5ewN4tGLo7gwUZwdEtoiOHyQ41C3ylQJoSGvvQ+If9XYD+9hKVQcl3DZkjFB0q+YCqDLEQAGIcyQJF42CwTBAIvtzX29Pb4E+GgsmgU+0LThfz42mPFp4eLGwoxbKr946u27e8NT513Y6hHZ3/Ozcx2hXojLd4Yml1wBWIDa3vS3Ukl27OF7aX00NnX79i8yc+MO52Cz49AAPUSTLC1Qut0G7mMReTaRKAEAnwKNuTDPRt6lzFLNQtJiugTVLIyKI7/o5qVtsH2/2WlHopTPs/vPMdbejgA6f+XSG7YTvgzErAmSaYjms0j6ltK/JE51YAnVshEGEvANgshTBnBWONjgQ6WmxmRDnE9NKAUHZCqONwINJYZohG2KgWbT+yEjijQcYXpOZQJacqU4RXzfRum245JhkrgG+zQ/sC0IYAUJmAYkE0fgSAo3BgvV54NEDEspdQsw0q7CVle0BCWO2zgGwNuljeiT3baejqZViwrIqcgicvk3ZvAcFjkgfiS7zSlj0gITEw97GwdCfMS+qgO2CmPCA4LZpDBsTli8icAsADDNwPZIWAncTdFdLXHKLoEgYO11SPqJVe5D0X8Xv2VauXwHaqvjp/ss2ql0wRKhMtYdfUjQ3SqskTqvTSYLpz2NeWbknmba5w3J3udoXaXMlCIdTT7s1N7VmyZOdEhzfeHWxdkgn2rju/NHz+2lwgM9D6D5n+fA6moNvqzqsNvla/2+7vSXlbWxx9x+pj2XxkeEPe7+9Z1ZdYkm11aI5I10h2ePNAMFBYN5QZ6Y7Wm2mh8t8mrG5HjLmBzU17CaClDMTREKBZiI3gISZoIYFdRwE4DsccyWaE7iGmgiHG+xDJC0hU2904KYWI9ix0OM3kENFepIvtSs4g/0uiV0U0SRZpTmfcOiUs6ZQwoxTelRLuoDapZDbyS4ujKrlOii1GRsNjJqt+3EgAKz8EAti3/LQEUP25TgFbM5XvL0oB77mUKKAm9GDNQetw2xbVhKvSS1UUkvaN6CJLgMLEU+dGUYnVZY9QmVFp1hyfI55Ier987+rTvNc6hy8hXbwub9ako2Ke208KecpO9igQo8hEcOTIeXfBe77FdoL8/J+0Lk2DQS+adHTQ9MhOhDRLm2NzkPlzYMyaVH96MK11Vb6onlmxqe+od3784x+au3SOviOvrNO61KfoO8ZNtVuh7Vg7tg/RzupG4wp/ywkWDUVPkQ4F0ogHjrz6Dr6mYvuHA+oFB96l/XXSzmWhNyjY7EWU1FKvOmj1W/PQ+C9irVfL1muoH2t1ZLtIKPfUjAHNGQsxFY3mioXW0XS5UK64WeSKG/4mUHTbQ5qWIhYrFhebF10uFusYKKO1ic6A0bTo0kCdPbWEhTL7/zpy5LbiJUNd2yd7gsmujojlk539nf5EtmXbNODXE+4mT+dEPjnY19W3pL2wZmyk3RttqQcxU0kD7flv+N51yi6t1fS99XlcC4WGbEIdV9CfeiYhLYJjPoLADMr29UoLzfB6aO1KJYAfYAcAP6AFl9pOgJgO50vpprRY55SiMcrIb8IxT6LxLKAP35fPE0nL87JfXnkVDrQH9MF8ykO9hTmi/gXRrtUMTNHSzTFlE3L88+ELqPRGBt5moA4B/BAPA1vokhCzd+iGvSYcnqZFx4u+pElUd4s0QzRBJ4wrDqlWTgGE6vc4rSSIhcXw3KzSrZd043e+AAXE9F4B4E04pJmjm4h0n1w1GsIvmpSfh8r6euiJbvg944QgpdMs1kyjYWmG7u4RQAmYhgTKkhtP8d2TC+4e5ruH6e70AjJch2TYRJ0DwVLRTqZqotxDGTZm4TJAFlmzLAlo3x381FlnfOLipSMX/sXW1QfOGW7LLx3ub/a1qVrLYFt8uDscHZjMpZcFHOck62zW+ua2kEe9+fale1ems1MXjC3fm/j3nv7eTCAVauq+a3r90N6DmzYcPLfUtf6ylaUzx7vCzlDYF4sV13Rnp0vJaFv+n33R+nqnJzWcvez6zjXnjU6ctzLZFjxvWaFrSUtbxtdVkvq1RSP92qnesQjdKrO7BQ11HaOaBN5iYIItWbcy8BYDCQJwvtSRRU1QQici8ePkMoHWQJT3NBRbhSpSIvFa0ErbHCkLcsz+yEBJqjF2aa5TyD/FoIvUyyL0nNArTiC27tfRtoxmniYxJacA2AnHxXCQzPsIAEfhIAvCqwC8RSeL2fapoAELGoQZwIGaAX2sIy8+3YENsCrXwcntZM8TemrVPK6SNIjfjRYBS1FNZdvtKfU2bfdT3/oPtemfllTeKf291l15U/3sqcn77oOvHINqrtbQmSKs9Ki3mEbPCyhNo+dC3Bb2rB7q0x7dwKHMwWe74dYEHAU4LILiedlA4GXS56X56HWzoeVZeAS7PYWr8dKTBMWjqmAexc6IGnonhwU50TvAt0m4kurVJlavjkn7ZtQtRCYouotQhORe4V6Tc6OKQdceRACv3U4AGkBxKZquPSmM4/hcmNABmxrWxfsnGHGPsMvF/WKdHAFpx3icgUeUPkk6HuXHnhCPWUFST9ON2oyX7QU51VMFLe1sVwuQFNf+hyXBnlTAn+wJDpXCA52hcLY/NDKrlvu3LktOLP3LgY3n5is/Vh+zu2OBUGtzXWWj1ZOItibdVvWTgdzK3hUbfFrsw8s39kq9NQu87A7gZe0m69gseUTA+DtATHbDB7hhNN0gHLuVOjGiboEUb5FDRBmXfdw8k9002G4SJmim1LNFrR7YunSyiAOQpxPB/8JCfL4HlcCZ98FCBMPwicG6X7J9i2T7NLZtZJpJm2mtXRoIJH3V7ujcu2byng9Oj33gU9uH9hVdvbsKA5tH4qll24t9uzPuhpbMtrvOP+uus3r9rgfCoeTY1v7iGSNtfhfJbCj3nNCQUviV79RIVNIj500aZ3ShEUo19VQdK9MSeJOBzQy4GcCZj71ZJ83BhE1BFi2C3PdBg/VXkpHFV1BU7h1VEc5nQmikPrQrwtOOeE5OzbLmkFP/e+qSq66+aGq2ctbhy5eNX3F4V+XuSy+55NK7E5tuv/C827cCmhMtKUJfOFW3af2tHpriVOqwL57iqehi4C05J51uYSHU8iRWaPxZEniKZSgXA28RIJYU66SjFvqIoG+hJu2jtBp5nKjzaZfPpI+ZUDeqStj9kgXUwc1OaYwl8zjKPnVCyMjTyNR0H36KWN6gTq5XdOug/Dem/qbyfbW98oq6rOLQZg8eOvjXYh0R+8+lIeH/j5r1P4fApAKbjt5iYDMDT7FVwIXAfpKAHHyzWI11uAWnE92l6t112p6px4L6d+2Z+nftGSj9KQBvUOkCLOM+8aTG1H+p/FJtqvzfWeiOBw9WflmlSy8CXcrU9EdS0CXkLkmeK0nx0XNcchUDCgHHlGR19sUZhfYwsFziUsucoERRcWM9uZrRfOsUwKsMTCCw/30TqYC+WJIgk1EaBQQp0z+LbzlZQ6baNDOdKg2mBtu1F3d9rICkasW1n9vrKY4ujbh6ZtpHLliXQ2LVGblcbfcFHUiuzr97R6dmb2w4HPGGh7YvQ4LVePdBsY6p/RXOUeWfTX1qhxLq0zjOx/36DBXY3CAN+FD8MPsNbJbYjp4Qljmhb9lEv13FglGcgTkGHjFNxgVmeKP8AzNfyj/ou2n2BBA2UAcjlEMgVNGD/1L4rzx7Yhb+12Yrv1edpybVXOUlwqm18KeOZNWPmGiURp4eRKNu5YXUhxVcZZBr3PNc+gMFVQ0rqxlWg/C6n3DS+m7UxmgNQK+XtbPQRlroRR+Ut9WboG0typdr/EEUMTabmI0+DMBTgo3iQDAhxB6hAZhjp749CAhq4GPh2sdzxmfAYDnXqw11YYFL2pule92DCrrBWaXf3H0APUpnJaG3QN9LI1NzR8GfjDTPhkf3romPhT7rcXeM5tS/qpSGZ1amm2wSD7+Jcqd6t2kcnOhXKMbhFROvqKKkzkYE00AnEyc5iZZReZMz+i7uKlSx3dxVc7Kr6nCl9i4gSw8SaUJKWMalHDmGr/OoPkaAmAMStx9j5WFImL/tyosA/AiO18nQLRiSXdRn52ok8DoDdGk/fUkjf6QR2E/Uvpm1n2ZRspmBq+jSaWdRlaWJWST4l5hBaKrSSJPgbhPsskG4uBe9RQfoDjSDtB++Wqmogd++rOE8+rkaqzxX+TgwrW/K8YtqqOHdUSP1WJk2WxV2LdBE17WwRDPAwH4GHuGOeZWA004fKxZYhRyjMYvVePYDMynPqolKBqbU3N3MUy1fgna6tGSNvc6F7bSC4OUiHy5N4JVwfHe5eQ1CRUy5Hyp6DB2MEKEmAdjOJ68D8Adxgt4eqhieC5krDwrAoa994OIaxkfUiY82LacBKvFlXEix7BdLFUI5dUJ77EL9+084+TMc9E6HmBsO5UYAUNF5EI4nUNxCfXQEgGk4diF1x5ZN0cRBt7Zmqdiih7ygsjQpdsGIXMJcfEQMD3r7eGDueAya6wKcqy5go2JexbsyOo0ITZxJuJMmCOqc+i1PSud94ZUv9Ksh7s7tDFzP/Xo/i4U2dmcbYmA7AyW+ZwcD1zPwKBttnmCCEoePU/d7271FL8gjXpgAFvg7pqbv1R5SI89YtP/5xSe1umdgGhTUuVOTWujUr/AQcsoqmAsvktz7jZq54GQNwES3aHbUMlcVFemXoLZfwPF79PnC+6zi062EUtcy1j0DwIuMdatFp9gVZO/3wvEFfrjI3eVeoFwcXaCA6CrJnADspHfgkwk04kj9wyrkR0Hh7MqPATt/Dcc7cJC9owGACLof4ggsFZParnwcgIfg+CLfdikAH2IvxbXsgY+4/g9cuoetLEffr8QgkArxTlpx7uXxNiOgcLCUxpwvMcN4iCV1oIAWYMw4/qt++xvN8uQv39ZsX4SRz6g/BkHi3ysp1PtQNv259Kt7pcZj1MeRGJLT3sPAJgHYgcr4iCPn8V7d556I5GbGzeMECP2sTVy7hdzkyuwvB11WAGACDk1n5At86au+zjh8KIYKFzxeQ7qTVcjbcTmTTBR3cNEdVPRe/u6/bMmMdXePZVr493jvztu2b79tZ2/vrtvO3P7RXb3qTG7LeDo9viXXu2VZR8eyLb3bbp8ZGJi5fdvW288ZGDiHrFkKGhM3ki0qqPy4hloH2RIVZHkmyF0hSzZRCcYb6b5sc1Rs4xvlcnXCvJItqKxH9LALLT376e6wAeskcat2agALAoLD+uWaM2j4eelx9yB8zxNkoROOP41zRLQaJYbplh3QrwN+ny2n+lO/K4S64y0t8e5QYfannz38ydumZtUbHMF0NNoRcBy88rpLr39b4N3NhHd+GPR/MPURfhb10T3i+xDLbNBPNsAymyAIV/KX652yudarLaG789tkP5bZmYQQMGfolQXRWXJyEqoJ9zCkb2kd1W4XU5kQy8EYhkVWs4ncZg+m1BqkU+9pQExizNq989EfVn5ei3iNgEpbGbWuO9L5kPqzGsTDPkQ9+27Cs6y6oQbPsqwFZRnPsoo00GSpg7LSSCnRa6+Zh4tu8xLLDkKZV3ocYLwY+jdSd+Z5Gj9icntdoERWnWSEwpjRFUaFRR/py+nGtTSpCzUSgw/AJeGrl3FzsBrOdUnk72Sy9zF2AL4IgOvZ5/d6sfJGQ1ZXI1Dvg5uu4xvvYBPpdfSEEbV1o2WbJa6msn2WnOpJ/aE/0J+NBNP90f5ZdX3fGeOpFasCUZ+nadU3OpvDsXQkO6setrgTbaG423bQ37Oid3K3W7NFssXE8wd6R5NNld8InouxKkMwD/LqphpdySVG0G3S7YWoLUvOZeAoA7dWLQIuAeQZcEmRELWrrBxXl5IVoY15ekRSohcEYIVZEoRJGBQ99D8kWXK52eCd15+ndbqLlH5uaD/rkv1MqfoNKpq04VXxowcLesx+Kj6lx+ShiUZrUSYwYBcKOkIq6pJDvJ2LdlJR1WutbqHFtI7dCFZ2nDca6E54+6e3T/cP77hssHhOqrFjU2dLLhOhMvRw678q/yVfxOqK+tuT4XDv+onlWwu+5sZDHpelKRJsbQuE+tYvX7Vrid/lUoSXvhbX0BbxO5NOaCOxok7Qfzt7mkuF4S2DGcIQ+kmAjQ3UxjkqQ2IpClipSj8OpozSfHYll8S55AXTPUJZcRgeFxqawzBiC5y45Pq1yYkLlU9gCqnBdj9oXc9+SWv50qxWuPvuU3PYJyXA84c0jCT+oQnPQyxbbhIipZ2UYzTe5FnWz5ttrYIYN7KUEWKuGeJPCLG8FaK7Q1WLfJzEADLfRwHfowY9oBG/qHFRDU2Y0xrJMVog3y9pgQBx7nWCVHYlQsuBJPeeovZQz5b9q1bt39Iz64z2dXT0RZ2zqmPq4lXt7asunlL/tnJFalk+Gs0vS6mfJFrQAHjzHcQb9d4aam4XfZRnZNnEwCsMPGxAHyLoWawS++GPvKL0OAE4WNQZuxi/7qxaY6X/2x0APMAOlbqfHEUH7EfJ1C593mxudkihGrdXhXGJT1EG5hfgXNiMaiSwO95NQK7inEk4XsfCcZ7jiECjxKEVKgYGFF1KJyw2w60BeqUYy29z93ybu+FxrvHbDIgZgxI1xqU0vPiQ9pkX3ngdlPMTWoe0eeHa8aukn1+2+MrxI9J/t44HaNgwHCJewYXFTzDBHkFA6Lou1gQFCW+eI8yTVpVJBh4lADvHRW7XZRnHIjg0WzFQL4V+GYZPmoKDFJxf8aAckyb2BhGgLCX4IQT2y3Xq/+TZ+CQD0wwMS6XcrqviImgKmUWjXPEmnPUwo/CwkOphDcPD/EtemueSFxh4hID3pb+rtBZD0WQaMH4jFghjkU36ntfPCfnWKbV52X13SUkX8eSZBVjxDE8MfUH+AQa+Xb0k5+d3mDPv5L6+k7v3Tu6/IwyMVkukMW2QB/kwo8eV1A0CJwVe4r/653dr5/zmPO2sr37mzfO1s38HOPorqeRPSkW/Smec6k01dEYRtiRDoI2VAm3yHHXzFM+WnzDwaym7KdKEqc0JDwQjhRAdbmN74jFJq+rnhD+CuFVhT4gfSTLfIHynmpiCNDEiNDH6NDEPbWI5o+nduJbRKG9BY54Y5cfkOpBDFs2Ss7GwLGq6rZFLGghdBE48XjXNyCQE1zPwOANPVL2nWGnYR9e8lmKwVLR4U0419Zt/fPnaG/7pn1796R23/4t6pbru9dcrX638lapW5hVKmaFo36a12ZdN8oQdPqYe5Qn0Bq0n+7km7bbqnE7Y5RSYgNs3k1ECP76eyKdgF2J84P52mufEJxu4ixvYYaKBh6GBZYYGJvYNyrv4e1cX30Sn13MgssjWIDq40O9Qi1G1CJK12lSp/OiuO340r8yqdvUrlV+pocqGyp+xHyLQD2O4rqhuM+GtwrbaBPO8vQwcZWCCgbcYcecYeJiJ5JsMvCAAD8w1Ky2N5BVcF0S5ASeHFSYHSsdWpV6IJSIi0Mr9fr/gJFbdBKbJ+SHWhQVsw0H5NSDWOxyY8yAAT9CJqEskOyGq6GRu7+Q+dxr6fMGah3HVTrfi86quIl0TaRXsQXYuoiFo97cPov+9Nlp5Ut156qfq+srfa0EtU7ng7nvVz9yNY7Bz/hp1r/Y21DVRE8OHoih7dSIKtKD/C4aboG+nnQxDNunbaQEIg308RfTuVPdefXXlT2q99tFTF1xtuVWpiSEtGN7zvpajLEVvyl+NHVWVNLS5l9o8VhPziKyjRXroY1S0hX1R7fmF7Q0WPSDcetrTV1+t1lf+FNE+c/XJW7H+SXWD1kLxEiM1Mbe208S72uhdYunZRjoNkPBU1p56+6ovf+iyyz6kzVY+9fOfY93K/G3q2/NfrekH0UjKPiQ5mGw5BgnjWhHG91pxNN+uNK4bGBB9+kdtWvmD9jLU9dEFa4YqxhULvzNiAUjxlzPVX86T5yqeM68ysFyYqR248gBTRSMxDAvrBLXQmLFrOietF+QvWwze8JHnVmnThw7hoxTL5QcaWVKfrlklj4jZ/RQAUtKTwC0CwHkZgXkZoakTqdog9/Li+VHTKjraoTcDgJc102r7raaF+BkiKUma3EkpJeCvRxhMhDM+rscXScTphgYUq/6cU+S5SelDuqGabvad6wYSJJ07FXELMvMRw3zuQ0zpM3iS+7HAb8j7YBRy/G7WmuPwkJ8aEM9jWPosiAhxWdJHaj+ZVkakBQjzXOTmKODKDr2Xg1bkyDKGltzuOeLt3aIXzuKGrmXgZb70HQIK/SXp9Ikqti3Ypw7WeIbKOAwZCRtTfYHgt7sT4e5Wtyfr61v+omrR4huHs5NDiZGtMx2BXo+3PRfq2ZaxFPaNDuxe1VlnezTa5k/1BFUt/l1/l6+/19s13j02mXbWWaJJf32L/0M+T7B4xtg34stQZAGcWgI49WHtDUDNTvXZGo7h5tU9RWCQQmUS3+2M75sFYCVgL18uMPLPs6OYi33INjHwFF+6hwD0IRPGWYFGStU542uklGJU3jElO1dml19GBjcOtVuJ15psq9iRwIKEATtkIBAVBNxsLU+QryPiSQs8nhBs+Bl6OZrlRJGYoTey8HKTEDtxsTAE6p2MNvk269rb2Wo2yQ6DOxjYqaT4+7ul2KPXup2fX8NAbY1WUCraQEPFDD2qwBzp5oahoeaAuCwGin6zubUrMjDmaesMFkcr+7+qpXYPDW0dicXHdo3GRwpJh/aY2hDJp/wblsYKHb4NWqrybz2p/Lpz8qP7NvS6Y5nAjLDHAR1SfwZ0qN0UU4p5T8Jspwjzh4WZHIVZJA8z9ZBAQeYcCEs9iIpkNM8hBuYYeIuBowxsZsBtAvZjwA6m+SLJzOhlKOPUq8hRdZgToekiwMIncUEMt439BexsabKx3HcRS3k29l24RbyvjEu28jEHP2blx/bxY3X0mGr2VAyaKYM6F16SiBXT/lDXUCw+GqxLbugoX3FGX98ZV5S71sTVa1zNvvRgMl7s8DY13u5sTK++sFy+cDLd7JJ842Ixx7W/MY1YlnLWkTYTg6GJsQIT4+GLMQeTQJwAjO3VGchbwmqO5CELXZ9FdgGSDwCb4diLVnYhZWaZvbBxXUzzLHELYWzvZK/QbkabbtZ1u5mcSGCTiQJkcQizBgqQxIKkYZBDWBAyUABjFHBIH/WkdCVGCpCUOYfSEhKY8EHm1yt59fltLlnLo30TS8n/zcBaHv8bedj/zMBaxojfs9a2mpW167hkh/AfRq/zCNCNiHIxcvwZYqEy3vAIAMdQvMDSXRwmOMWLPhczsEu39/9hwWL5Gv6k33O7r2Ngilupt/sGbtw7DKzldu88bXO3c8PWMPA4f8AkNGw7HDKQkdYYJMMUMRFqChimxTgtgNC9PFoMdLa1jA1Eulqb1Xse0xzJwkh8dNdYPDaydWhod0r7qtqwfIOvoxAbW+9P5SsnZgKZmLt3w77Rwjnr+pK9aqci58gyoGk2oGpv1/DBgPCMZv6GAh5K4HUGIc+z4OohOB6BA7nncfRM2k+uIYqekQ45ZB3yTb7DzDf1GOIX0KFQ6GABnhUBJqYBngwBRWTo4BBFu2SgCTGjhjjZxZ2MBjcy8DgDLzHwNgGYLTIgvfWb8mVpSxANkcN8zwKXP90bUOdtdzCQQECfsNLfP7rodIzq4pod7uGgfBIT0W8GXQ5knMefpZXfI3PECBEBczw25ynCsxm6thna1yycEfYCgA5VGmVFERO6RHELIrDSHsQVkaGS3+yfGVPVh/qG+gsWrX7TivSWrp69RaS+3Wv3LZu6cLxVHeqdmOjdN9TXErjF405PXlie2Lc6Xdh86Wi7XOtQn9LeAT73tkmnCKKVSax17OHR5gSmbCpSpSpsEYYeowf4jMi32Tgnk2JulX41QRlbV03GSRclqmwV9n2U46MGpijTMsVrtcXqAElnAxHOVdATSXKWHgctJqsnq7F92OygWO4omlaXbDEVgztT1196ebS0ZSjW53E6I75U7NZbn1Y/fiAxurk/YLfcXFfXm0kcqFwr5NT4fFLbC/PTqwyrf2Ganx1Kr5A6fgAAEZ04AHk4luMVwT16xTc/xcAtBBxTeqt87KhwAEbW1QGzuQNwpUOwrjC7BisMvCUAK5W44ZC5MOTlvTJtZQf52uEvyheo/7TCe30yzJeCaVoBnzELQqto6WaZagefLM3RXB81jJJMn1kdlBIWlAwFRrnWOGxhLOjUBd0B6RZC8zLMc5cFMUwLhC3EdD9CMBOezB1Q8wCxxEFoRadQymvW7q3GhBhDy9QaFac4WHzZ05r2oQNEU2tPWzgTaVLvyG68blN5X8LRtWl44xlaYtfQ0PaxROvozmWju2Pa51VHWyHh8Xb0twUwFCaV/+Xmy1e0Bpyf8AXXbmjty2Ec8+j5011A0Ek+HQaEOR/knYDaaMKUJkHJUYoJsFE9IMbxTQDmMa/ADF+e4cvCelqlr/6qf7TC1G4vA3q82FFTiUCrJhjeJrrXot+yn1f0ZaxHiAlqSFngGlmdnDJOdzHtV5hUhELbNMcOL5S0p6oWeFIi/WBMTQ0/rcW2Lx1cXwg83ZcehrM3Kt/vKqRG1ndWnjs5PbrxzBM0/zZAx6raaxSv/FMTFUOBtk5QMT2GT08JphjWVGhFR48APGQKeZGLPmQaPGRajRVu2A7lFbQ9izlsinUoo93SuBC7IMa8uij2HKV4U4U5OA/AcvayY4uMhvYXoFd2TM+lPo3/aeccfPnUH6EP5n85n5R9EFR+acKs5qrPUjMbg6VWuAmAPchxBB41c5NFBFqzW5inqlmEVOHIFBQ6NfoZ/IDdC3SHKIX5wAQDcZMLk/QuWaDhhN9fFwjdRwSXY2dwloGqzzd2TeXXDV6HP9RoedrTPbkkVghBR518TlNbYh1ezXHq//RvHonXWXk+7oT52KieX5Orz8z/hFldYSFH4dUtWeLikjz7iO5hYL7qB6ByPcKur9KKifQY/zWvMzzIwLDuJC79wlcz5t6/QAJ+lAGfRGrdbPwor2Ddz8B1DKxmwMfAHkKRmrW56tRegL5mB+866eAtop4WOniLaV4q2r3k2A3z+f5vffV//fiQhhN74idvVl5XtUpF6PFiTr8B+PDQ6eIjFF4wPg7AHC8YozHyET45rlgo27S8gkTMwqY7C2On7Lmj5hCK09K32siJDTAN3zjVInDJchTkgLR6oWkGtmJgvJiBaUYOCbgJwHB1jL7R59hVnFIFmbBc/xDMt1UankRcGSYC94pcSl6efl5+wMusE4FnQWckMu5mj7I8K72HGLiKgQkClNMRdOlrUS2QiFIt6MCCjirJ7xBiBa0XNspE6F5yyngWqYT08kvoFo0XmRbNswLvQg2aFHhFv+4tiuRKmHlWsg4Psw4dGP6CFr1wfHi7P3Hu8PBUl+vpZKYwJP5ojr0jxf7iYD4+um2w8j011IssRf7ovNoPvNryLrx6AYtezizazMr3G1k0jXKC+fBRE7B/EaZdy6JNnNll5sw6rz7tAC4Yr/fHov2LsWjqXgOLxj41cWihv36Y5OOs8uca7wpplTvOUU3IlDFXpybSU0ibxXEGNjPwKs/WvWZ2TvJzmHXBMJO1MEvfYTL3oVetZeY0SUBfYLdI3T/yzcXSgi5mo1uYFhSx+R56/D0ThG6M98SammI9cf5lI9rElfh75dWhzsFYbLArFOrC387QAbakoVZXvnB1mmzmfdTXLiWjjdfYCjLCnmawhVt1M4Cm6/UGu7lhtfVWsxJYa3F3YcppYUDPMGXLEM5nyPOW7eZpaVBj+zn36QKjuDSbv4uVXHqlht/LSo6qQYIco2k6YWpsMSwfYhbwDgPXLsjM8Ac2KF3DS7e/Z+AmplH/zcCZPP0mGbiIga8xBqKlfTsc++CwCEN5UtmFC1lk9rKJPRIMxvY/VwG9cQ3MyJ3cSidfWszer7fif/OEuJgT6VfN9GU0o8lFs10E1BruzZnsMllg4bV2+8e06CXjbLcvnBXRnjZZ7dXxc0pFNtpn8pVfsP7cp10scfZiE856AElk3g5pGbiHgacY2MNAnIEfyBWZqFGB9ogP3gzAXowgEtjtYVz2ALLJ0r3sqaQQIMw2iLwe3ScdS9JCGO5kbtrJHKuT29VpIBoSfav4nMaCtKGg6spvtjpJBBfBrQl2sklQ206D5XfSqwWWX8P20xuZPt7E+HM9M5nrGYO3c4TIGgYuZtyZZmA3A1NseN/FwBMMTPEy0sUM7GJgO+EW4voNVROvlZvYxEAzV+Tj580NslKDdjGKb+c3r2HgcQEsmHHcglrzrWcRY4DZfPu0FjmrwMbb8UuiuCRlNN42qNF8hm23A8O6vq9+FXC7Rfm6CbNbOHZcdwuX0eCYT6keOE49YFK9IBGYagCvavvL1RDxej2KvkEsZ7ewoCRCeqhb/o16jXFQhtJWUU4a1qoFxkh7l1v4ODjx/WKFQRrI0O9DCl7ql1xt7uWrnv6CFpxa6o43qzda1e0bToAUMDBah16eifm31X+F7+9VX6rxVWsS36/n8tTTOG7hknO55Os1GUBxfbcaxygNFua0kKgzNpFZWBOiQJMoRX+0K6lUyDZpMn2h30Jahs6UMdjaD1KAX+SPfAUATJ0xj3k0Zsroh+/HZXl4gR9e4Aca4Idq/bTjjb26wiBEtDaqv1evv1fkkMwbNIwW7PQWwyh0Y0G3GIXeOXxGGiiGpAG2m42uQ7rrW4vc3waTdfnnRAhQAG+ZZWl0WNqJ8I4wXhmV2WTa5cOCXtwkeAmykBRMlZRkTB9iFnOmkmImh4Awpb2Hk35fYmd/a29mZMVIpnNiUzZ/dk9zbEPSFQu5OpdOLu3Mrd7Rs2xn56HmgCsaCLo97cP53okub5Pnw54WS32z0+dzeZJj/UtWZV2NTaiZA049qX1VCasuE06hgi3nlDEtxX6haaMpg1L0XCZ7EdPr1gnhb04mMT+fKdEZQs600y4ZZTi2oI/ajB5yiLe6RD99CoDPc+DuGezrOyF9fVVyOycZspZfLTcZuRfI5BItdEdYJP/s+6pWMwDP4YiKdUHalqBE2xJQJk1eqF2mphou/dsDB2K55mizLTKYHNvY67lIc1xb+tKB44W8VbvWYo8MTOX/FekVyOrnaw6o/ZSpb4OgbFDf6pleEmzxOWoqEebEIHR9kO5FXSXolgHMb0It83BIPamRKV8j60mNzMo5DJdNT0G3yCFMPDfCDucR5V0MS8ZMtTVhYWKvjuCc0HaCenIHm57Vsj2lO8AAtRMi0DK1qJ1f1XcaA/EW0HhI31nXpa4+mR6INwmbpPDR3QX9aFefWzwW4AG2udxSExRgVX4JwB85/rRgCgzQvf93M4qHGXiVKeCtTDZ1KTbOJQUuOcRAgS/N1UQHlOWK68yCMIEX2TpaYiDIobr7ALgODozWsghqoUf8SoPoAwx8m4F72JRqx7032Kf9lwtMqXpUQsJkU10wcRYLNOCpI2jc2azDYDD9M2xkfAzufkZYjnApCimBHjLw9cu0y7/y9e9pjspfqh9Ei6tC2XAUy+Mwxi7t0cViBqwU3Xycg9jdnIrmVQDe4tK91axzhviCE5RbQyF3bZn1Q2HZVmFsUXhwF41DGGFH86Ax6sDLgtXnFwYbfI3lMV0ZRyX7LU4x4ja4yTpOkPXYAcRMDtcED84jxhCEIRk7TCLrl5iFtMo4A5uMMyAslvh4v1w0XTTyQI8zeJiBTRxncJxF+VcBeGuxFAFVBDHmuNeq0QLP8/cfNoVpl1GBEkZVDjGwVRMG/GNVU7Tp41dfDbNFa5F4g0C9Hy3IBnA5Y8CmBQkIdXZ0YTXNozFloADqWYqWwJ1MRau77Vwr9tapCTZw/N02bfe/7dTO+PLD/7xTO/+fAbvvUq/H49Qf1Rsrd0gc13YDjjvVny4Wa2DAwycZOGRaJqYrkkSpVYd2i/IF7gAvAyKGtRp+UGY3fGMcAhRGqpnr6vSrxJTtemQC3VbPLauXUpJe7xGJpXrQgh4N86wxemHt4kELgo1LU92TZg+TGkf6KtadJnrh96zf38fAI7pQ16Bo4qa/oea+/8CGO7iuTVXkkqi0rhp7rfMd7B4RzmAnL+bZz7+0Ycu3Pv/ll3ds/67qUJXPfKZS+T1uDqQq9fNJ7SzAB5/6CRM+NJ4uxs1KsZJxzsUQMLAzG6ZuuBHacxccD3JweMiM4sL3vJ4DABvZkbkqIDjFtYCkKg64WaxDYMgfbS/zAA/RLgaCDOyTKV/t0jHAZ8jxbjDlJrjkOJc8QkCNC/8C6S1MHgkfkyRa+I049GS7lBZuA1POploSWu+u7rKV4V7JcP928TQnj6wZ6RxiEfMbXZGyIy1Jb3uh4V++cZX2gadf8GZKW8ZHStM2azql+StfUrdVov0zUz2NiozNUH8M4+pQszW8rHaeP8zAKyYOJCJTZcmVppUyBD7BwKTORnRZJsILY3/PhOJDDHByQHP0hZ4E6X4TXdxfNpjw/qfEHlMkhkLujDV70yym/oolRql2bZcEzeLmPKcYbrFcxVBZe9HfHnnjP9WvvfF/KhOHfn8Q/qf+bJu/Rr1Ie1spKp+s2Yk3Qfmtw1IjSZDE6TzJmWgSMlQfDT2ZE+K3B2MDivDlETiKZNSqO4kOkkUlQjdn83gzJRKQwfkRCpqtO8k5hfMKb1SBECloMVUm0o9hioOlql+oCmj0GxwYR2gcStWL8r5goyWc6nS7O1NhS2PQl78gWuwK+VpjDkes1RfqKkYv0D7d6A02fC3ZHXKommoP9nUebQh6G3e7k8WOr4djrrrddU2R4Hc6ikk39E1h3qZ8mdb2emvWXBtxFREjLrSarOVxWm3zpDxfPqC9cTJk+ZW5j820qIdwVmSHtUPfCuok4tFbpPMPbp/bA7/t8jeLuaKpf/Pcvxk9HiCTxxuwmoyMmDf372TNRiDBIndgabDPQn2aUwel3zyoEn7u/pza9n66d+C9ezcaEL2L/bJaeVDzqueCelm7AtAs4lm8edyEgE3mXt0/zeoWiz6YHDc6h5kAyaNR+P1bsP2UqNRbH2zLhttGBvtDbV2eDtPZ2+54yOUL+XKRy3UIbbwfmd+kLpW58TebImEwVMem7w5D4fNzeuTRc6SPSJcA1O/jLK1zvErVK8KbUgfEltzqRZ/7baVItuXp+Ws0p3aHkgR6afaLcFOm+TLnjRVZYqNzuHm0mzbGNBnT0EYkiy1k/SEiczYBmNvAcC2lE4sMCbBdxotd/GDXu3GP6nZlwtCX0leVgsRCfFASJKuvX4e6JATDxjtzIkNvU9Eik7VUDQLA4L1iP0q1aedluMAUiXQszTZ46puaY+4tfp/04Y6EOsc+P7w2HrKED16Ay0yWaz9isdcdrG+qq/zORq7cltu0mLZ+RarkQbwbhA5for2oxJTnTCOsiSA4jlQrY3C75F3PMHC7ZOiajPaX1qvb2bbwDFtNbl/MNbAaSCZ3ddbX4mYpWDxGkzaQF/MeGUlACpRV10CkCpE5TDo7SE6BQwZjFjkF+oHUD569bfv9B1Mr2+t9ncGuUnvT4cM/qzgOPr978MD1DfUH7VZPe76tfffzBxH3+pRd2pB2LvCc5ZaYqUc80JLcCWHT8ZC3hIKDfkwZliF4bSQeiWyHI9A108JogkGGjSD2ypMR4PzTnNX7QQCe4JMRQIxpYcG0Kp8G4Ek+GYEOmRZL1RhFHlameLfFwwAc4ZMRIH7TFJFFFUSgAnlSgrm0hhasypgyOgkyepKvpOBKiq+k4EqKr2TgSkacDMHwT+JS/gyltMuC4q2f5OEkz88U4JkC11aA2gp8pQhXinyyBE6W8G1L4LYl/Alj8Alj3Dtj0DtjfGUZXFnGV5bBlWUymeQw9O3Uop09DH07tWhn3wd9+yj37xAAk3xSgo5ew509BH07yf2Lqbwf45P7oG8f5f4dAmCST+6Hvn2s2r+Gnr8f+vaxav8aev70nf0AAI/zyaeho5/kzh6Bvp3m/n0QgCf4ZAQ6epo7+0EAnuCTw9DRR6qdvQRuW8JXxuDK2CLDcJqeT8u9BWxAlXgL82wpKHhOsBS0y03Mg/asYElZe1YdKJbLRTgeaPI4rVanp2l0+UhTKp3xuLPpVNPI8lFzedbtyVD5z1cPDq7Gw9uUTGdbWrLpZNPI+FCDG+92NwyNj5jKnS4sdzmHaP9NZCoXaJj35Kma3UU4MlekXUL6ddos2NV4D7GZcIjIE21QkpAKr3JilvJVi0u4l4f1xCxlJQ3p2h56V9dLl3KrXFhHB2evlHECUne4iPSJElK1LPyxYKS2BQiaXexg+2/33uv4+LmPzt5w3d89eu7dDffe+/Sd23Leber6yutqpPL0Nm9u253ESwvzW0Bu+zzx8IJJclPQOgxMWrzXKtthYz6u5YGsgvAmBLgDB56qfE49R30b/1IerPnraE9Mt7JW+7GpV9uwS+ZJpjqmdKC3cp60C/JldoIq0qE8BccLcPwAjlfgsM4I6jmKblEF2ouyjObHUfZ9lNtUFhh4iwE330PADCqWbqF0OqXy3SEVSxGI5RbuVGK8RuGVK+ZoHzOL8ifauoz0jRWsNq5QxEYOFmWFrEMMmAcf+BXbs6bYnvW4TCO/gni+DGYKKmK9htsxSsoBJmACRboV5F78N4a7JQi1rEcYHJcBsAEOUsAv4/1BzqLLwgFcBMAuk42DUVvD8rfcsjwmtjroUtYIwQhXoibZONnCul1Abo9RzzdikTTCpBnoZhPkdWyy+xEAr5PJjmRpDzVrTTWl/giv/T4hO6XeLXZgaZfvwa3ScQMruRGi3ETmMQIESg7OkWVhkM1pg9TOZfJ5zgonnSeugibcyu25g/couwM4gJRAVvJ9a+G+tXKF7Hb+roMLnriTniChC9R0uTF3n2oxrJ1Vt1PnQASxgGaz805nmez/bfR7ouu6mzx+Z2TVM5nzu9LFnpUbVvYUupO9hXUzPV1nZOs7NmfjhZ6VG1f25FPuSEtDccPZXWMXtqsHmjt8YXck6nF1+TwBuztWecwT9CUCbdFY99KewnjENZEeWpFpanbe3OxqafVFI609y/O5VeH6aKKjJV/ubPGhKXD+t9o56rnS17o2Ct1JNOA5suvahcieQLLBNvWjbOg7KsxTVqJ2BXLJVFD9s5D6927Ov8bkL7jRCJIx3FbJe+jQfxw6pL128CCq31AR5sX8s8yLuVpLmagKbuOEwpbIdkl7Hb3K7gmbJbERHlwBmBXDiiKz4QzDM52AdgW9pICT902JZ8PQppETYmu05fAoxjQcU1brmxC9R0ZMx8myIQTVZYg8ddEGRDlMVOERm+VikAOfDebJgWUQSNEgKSoj8Ct2JBmBBg9CG8ZOiG03VwALWa1fXZ0X8iUmqF3DHrO459sadpKdZlvTME/eac6+Z5KTTKJRCejBGjg0YYKWYvuRakhXWteVpf+u6Z16suo1bD9EC/ca3qvj9O8dhhk7xbN2SrhDIO1oYdoR4JYEGYgyocAmvVd20ZrdO1JykpJe9WB25e5icffKLP9ePXLebevW3XbeCP9qAW3nxt6pgWh0YKp3405tb31bMtPdnUm21aszw+dMZrOT5wyX9uDvnpLxQfhtWbM5UVrf27O+lNi8Jto6Viwua8UEWX71ZvUGwHGH0lOTfdCDvi4id3kb41ObYAZPAfCC8PjCHChtoJi10dQSTK1R5NlkxyfUYRuls3HGLWK22qpcB2lgD9DAHl6r7OEJLoE5AhZL0hbGJSSMr57gHI5xznn6FAMFBtz6xjeNtPENbdOJjqIpCt3TaJvQetF0RZ83NlGkp7xxyTxYYfKRIPbcrluRu8TNYmehQr+Xx3YwOyQMNzDk2ZTNlBKBovJ+0NYR9MXSz42tS4wX2rS662xa+2S4L+nvKA55IklnbyJWimiNbp/X29P2hUB9qC97KBHLlxpDmUhHLmC3qMmAs1nsu1fWOtWXFUyBdn+N5cZGFq1q5B1aIp0nj8n9MJwneUVAZBapbqrBiyPCzlJPd9ooQT9CyEgxCKwhLywvGI3gxI04UODEwnr5wga3MHqqpaI9mErTXzV2/b1XXHFv5SH6UZv+Sfwn1kbzymW0h6BVGa2xBbAnhtD1EeMUcYrKsEXad63CnaEdM7bk1XcOVA6qT1X+/lui7rjyXbVP3YR7/NXka0GLjlINIxF7e8RVV+V36qaDFM3DfAHkaBjpCcuMqXUD8PqxfNkBk2IApMsBQMUBmC0DGAyLk2lAzKE4AHk45AruACHRAMWIB0TekjHG2zFmK2O8kDDGDsxj9NgYOQkho3HB42IPepdYhHCJt80B8Crau/CxQ1SKuXrEbrDiAWeeXJucwD+ceJ8D5oGTUjJyIQUE38prWydwJgvnQZcQ6DbByR6k2vuF5xfqEN48TUYvJw7wCpeYVwB4E4553GVLbHrthS7xKtrVpOF5gUt4RajOCSrwQYF0SHtLSnDkpoQSuoNNaehFRZ9rMF0gBfAbDPYyorDKQXuxoFfGfV6JG8CLeV6il5TIcobb+PWSVclBmUlTkoI486jF8VkoP0srSCHdUqScINVJirZJSVcwkqVBXBFL22hIQqNyiBaQaPD9inC+RJ4UBVYUZd23FT6slblVguLf5ZV2uNLOGnsGhGBdfe+Gk24+ycGJ3E33MRZzH2ep9ggrMkeUcWKx+EQUnogyY24FPrrY+4fh3VP8/mHghlNKmluWgZZluIJuqKCbT3JwIhvzODfmCDfmcWqDlG+rGabtSET9qeB7+cKfOxpNNvnCzoG9j6zdsDx/zt7tnr33GBks/tawSfVub8jZbNfW968YHtCe/MIXJow8FXnsvlquTPRk/r+0K9XztG8C0bh1EXoCk8kNIEuyE5wb6ZAQXxykArIgO4EisLiKIi7QIgsliZJJY/WkS3rYmIVLLIQ0FtyJCNfgtW9uI517UH1EPQvoFeZUNdOqRklJcZUzIHYUDgCdCcgAdJ4z0ouY5kxUuG3I3Kn7jfZHDJYVuy8TU6uRfT7SHYt147E+2DnU1jbUGeRfrSgudMeMpfBL/EwBHoDe9S7lV6a2N+fRSwUJXZUbNNNSbuPJKkfiGPNmyc1EFJlx51zztquqYOByxXteAE59Q6g9cFwJB279aEUU1neK2i/cNsR+gGV2paqmlqyTEcmCQbrkKkmT2PVTugG8Sauwcsfb4mBR2FYGU7Tz7fMHnof/DxxQ777qqgNXXYVrV2pEvQpt5epZJpzzKQtzOBoWVu9hwM0b6rzKynFCklYfsc9GsQG0WGtV3IZQ/A5eyv6s8KOzKx8E4DY4PoWJMPbTLfLK5QB8GI6/5BQZqzh1l1fcYgXNNqJsRXOlcKiPsOEjwiJchJrgo8WVGk/kGI5bvVJ3UnRq6wliMzLizcXAwwzkGfhbAjCCpE5PC4zlN7BE30klgNPjFonQ2Wrsgkst+tvbEqtG0h3h1vGItWPLQHy0JxLKFiMt91eeUa8JLBks+gKBxsa9ziZ3vK8ttqSQD7p3k+zRqraoV8O4FdXDNb6nQc56H+S5HWRxNsitqmZG0L1R3ewxWmAgwZ5beyWvd0k0rM/TmNbLQpQb5DC3keteB9Qv5IGOPHK6DrktGq4g5aScZZg1go3K2UeJEU6UDbtF5BnDNjHwirhkpXtuQZYuhsdHb++EKkX6gE40R70ABT+A4xW8MEMD2ykwBuWcOBwoIbRLMaZdJgtHp0zMZ45Os8iUOYF4ndy1rCBG/EqDaac4h4u2UHgebjSCojsPNeZ8V/2mmH+JDYNseaG1zVxioidRLib6st0D6ZGpZO+aiC04Guss5BOusNPZ6m5PuQKRxuiQT3va4WiI9iY7+ho0e382W4w12uovdjr9vqBLVXdpasjnbHZYGusJV87XpoGvYL6+e2vWuRsWsASRLVyZJaJPiDRv4hb7q5PfQU9xWle8Widu00T/Vu0lZXSUkTaXVw0Z/Kwig1/Rnnr8uY8c0F4+JOTq4fk+8v0NKG+YcNuPMbci25qfxVk/46qfAxZ5c0np9GXOQaoD+8VGIk49Isxf3d5hE6f+Pk0co4w2fhcPX7mQGl7U5ddJah+ydb8hu61njp19cfeLRXx9Pc8YPH1f1H5icPPF7JPzH9VWaKhxb1qwwmc9IbhrE/w2StiN5iB33vxFNBPdkq1gM5tx73eWidrFTnK/y28ZS6XGtuTVLTece4N6trtrZbG4sst98jvaT08lsS1jyleUP6iXA21uM7UF53cDvhfVQRdWXcPex1zhpNebDLv4V3Ubz+BXETngk+owod4bJnx2UARqXW6WrhGmjHAGpUs5g5ILgDingLqZL69loJOBnQTUbHhSHdA4FsTF0kmU/f1T7C50nG2wj4hcB1byeXBzioOrTDuZSYdOv6B6knPMcIr5MQDWk+hc6C/azZFvBlpiz5Zeijp9nubWQLO/oxDtGo14ArlAKBp0Nbmy3WXN4vC3h/wxT32js6/B2ezxN9tCuwXuoAyQ1Z4HDL6iJmtFI27NlRMIym5PCFvE3nIWQw8ZiblN7DtgY798Y+J3+Ax6FnvKC60uelKf3zR0eP9BbbSwY6ZyNkwLj3qz+lkpa/62RtYEiv4wNAu3iXsBF3tEpv9G8sjLY4FgELiIj6IYinFSMHWA2hkAeThALnNH4agTmmCARYUAz3qzs51Vf0jbj9O8ysAWyLQFGKgJoefIyMD9RrnAzaNboBLsr/qTwrzlAOjdZd97UtlsCo8DbUPTudw0SrjiV2uPDwzE24rFtuyyXCCQW5aVv9CXS5WytkTacr68iC2nbEindavBYZatNiz7WilIhew7c1X3N7T4lA3u/LcaNpQQNhy2+fDWXs6TLENU7T+KvDEvKne6pYe8PVXKFl0q/tWWkHHn+hoTT53SNv9rywENcys0AzkNKz8xYbAPEMFPawFNADUTLje7hb7R5BbZIdAF0y+3L0EW0HgSveP8ShOVhfO4QkpDjsp4iCmmF4feazAByLAP4SpzgmTlerYoCLffRvgVlaLK5JBuF43SXOZlwWeCBZ+jBMjpQttDpOwgzA/ClCGZXhWzRy2qKe0ftRtv+uFXHhgbu+HUyzSb1L+9vPLhy9UNX9p94Z8qp3av0cZodqlPn4rQukRA9luMEhb90dRraN3sIDoqtIDn0PgKmjj2I3rMdAqZoVbQN8r37MZSRrfQiLwNJW/MaqZg1KnwFjTmIaz2ZSsWtMrwvxPYn0L45LoZtTDtRFQI65Ja4lTLS6USU+ymRI+muEdT1R5F8p4+rVxu7Nye08rolSsNnb37NPK6JGzqM9T1gLOtBpxdoUyq5qiNNoqPPz3GkkicER/0FAHCJM56bJtBeEVbei9hdBHu7CXkK4JMHoFzEW2E8UyjdMcqfUelVYDzK6kM7T8CZSehbLWYByvzuGZj9i9+l3mwiefBC+9rHrQYPqWFR/AVHsFNCOwnRpmiynCVJ0WVlYS0XwJpvwQPlDhmtQQjXSIhv3ACv7ykFITlHirPzEmnyjmBjljWfUK8eFwinVhNR+c+8+z7f5Xu0zXz9Nz3L+2nauby+5X+D5win8fO+ZXqf5HPY0K5ocYKjjS8QVrtcXpp0ubKCeoadT84LEmwJ4X3fXlECp/5Nj1JkldfuqorFX36Vs7qxUeO3Fa8ZKhr+2RPMNnVEbF8srO/05/ItmybVi/63Kkd7iZP50Q+OdjX1bekvbBmbKTdG22pTyvz87Rfima5VssAxcI9kF5VfqwsKFftys/gn6I4SUNoJJ1cWXgfPP8aupMv8vx/UBbLNiJ7jczE43IFcTlBhf5FnvuF8lN4zlc2JEJLSAuN4T1P6+9/ne7X5k9C+ddpX2aveklNxIvMOb3H4C+KM8hNQ1eWFnKh6XhJzJApd56kNUhhTxSO/xa3DGVZLoLCLMrdbLZq4fhlDm/WqoF7Igt1o6472dy8vbyAhVUKlRHxopq0Y7Ha6AQiFnXSGiEIwCzFqbmole68lDgflE4ude6azdPR1YPvrs9Xma+VwtQ30aKtiE2lR8Tqg8ut7xL3IG/QkrIULYat6QdT9pT6746P33uNtr7ymtpYeVvtrrS+NP1Nbajyc/WztFX9ffehDJ2dT2p3gMxaVs27XxbQ7CD2XytwKpMC40+B5eKCMHM9AsBROI6jDRcJllt6/t8ikjlYyV6RJ5sFWVA7KbuDRiuSnYrCK5Ls/VvGnZMkwTxPEf7AYmkOw8E6JSFsyuvYyTHbZfYtFkyn9QSmz0+RmFRG1x2xhTymShwxJE+RqyCL7x9RE43yHCW8sgpJYicHBSWr6XdaoMdaWF1q4ZnTUl21mePgciGZUTg58ooreKn5Clb5lgGwgVW+s6kUO6xX7jiPizJLGDWWKOw0PS6KDtMCAskMTsqZnUYN/V0VMeE4aI5BFx7rd3TuXeMMnFZNy45fe3Zp7AOf2j60r+jq3VUY2DwSx53s+3Zn3A0tg4vqcNschTNv3n7WXWf1+l0PhEPJsa39xTNG2vwuQd9wb8ci0aNOokevKrdLeuRiepQ30qPa+3+m/KWkmwk5Rxav9zUF95duL6O3kXRfQuW2QHlkyWbUIp5e5Nlf0LOryobdv3Uie7S67yAlwrfDXHBTMvyHkQ6K9+DccpOGjG2b/z3UWkf19wBkU149pSgZIpi1KdZc7OThItdE2Qdr4andhud/VieedzFtvNW8bTAhh6iB3v9LeOoiw/OvwdcNl3G/IqkmHePX/i2HWh2t+gY0VmtEEOp7A2o5z1DfL2R9iWozbCwPmr6njMsQzmp9tHGQNl+B/j+hIYWNKX+oiQpSeIfmqipoEZngpEPQmwuS029eLEt9g4wCFkld5V4XdmZMAQYeYXPLXpO5RW6aV6Uk0lBP5hYPXBGkHo1bPump7pFc0EV2PDl1RaYJ1F1bRdEDlL5O5Nv18AzOqV5yq6cZnFPLK1dWzjp8+bLxKw7vqsw+/vjUJVddfdGUOrxPbU1suv3C827fmlb/et+XL73kkkvFXKD9rml8+qWs8IqUFVy8DlEQKQLMsgLtmUzPDci5+bI+N2V8xh4CJF6a7lekTLNI+WsoQyxSv5BhGkUrlp6mXl1myRA+5XjUc4xY0qPmSorgghpUIJAuLaL+F2DaeSbpskGuqqHThk2YR8RW7tIiLBe3UKZEyUHFW96E+uYVlW8RUXc4rg638LTzltAPO2jPAqEd33748PYHH8S/h9X76EecC9871/xL2u+012l1Pa9ur9mHQeN1Ek3QFePGM3J3YI2VDo0xvZ3te8Jhp13P24Y+JD3kvRqG33aKhEnpUIcO5SVUNuxvegsBjPsybUAV941bL9jl9itC626lwJIwlLTKFzLUoUN5CQmL+2FFZhzYBTP0EgzsnaFSGXR814JN+XaRj7OI3ZYba+JND8KBm8VbZkoZZnYwLAHBEGFs0rxral7ftCEQvHQlble88gPd2ya2TeJe2HeduXNCdbYMdtBmxTlvsR0Bq+3q3X+Fuxa3xc4aO2vmPtwTe2LP2F8HI7hx8VDPGb4gbpkd7POJ+Ud7ghL+Dst59LzkRa6FG3USuYzqvKj22Z8p39LnYISl6Eh1rpjup7n2jUXb8AssVzbS1DHVU8aVKgnoy5QTwkJodIQj4tjG97UxzaA93Og9Y5IG/Kti3is8qlRq9IWoWMnFzoiTbYRwOsozuzZt2XI2VyqG/GWR6hbPCnObKQbeZEDfSnyzOQ2SiA2wybST9GkxZUHKlCrKy8z3RO7DmExFt8WJWCqXXkYuSreSkCCk+Zr9xP1SSa/dUny2Y/N1GzK0q3g77yr+kx2h0o7lH7zif9Aa1DvaNdo7yrD6UVNvJmF8pdU0yZwryczXvPsTSrFJ2gFKE12SZCtwdSuovjncpqmMfhp93HN93HN99FENosecpAIIuV04/Sbdhm3ah7nuYap72I0OSoIclZSk7D64YbwmFyXmfZCAXTo3dulPdOETjaYQQcmZF2wjVJXxpXMUjV033BqobmW1nDYmgXrnMB10t9IlnJzcmEO9jMvmfQqHSvdjQYkIo3GdaKGxRaZOA8F7kEXwZswMOjy49YJC4Zy1vePLz5jsnT67L5bzWF3tHm8q4hrMNDU2NoYzA71dsUyg4Wn1jW2XLPX5CpuWrt4Y0JrOmixvHfDWabdploZQtq0woN062J3PB9P9kYoV5qDYY+xlmIOraK6vVD4u+f097GlfEBtx0dCM8tytfe46ei5JIuwwPDIsEOUQ8WaFh3XxZ7+rv3OC3a3i0t3qXZ/7Pj3XRcx4GJ4dZmerSZjOk+LkEACP0ImgkaKO10QdgCaXYh1cbgno5d+jutG2/LblPtonpEVZrx01zZ9eReYgvpK3GbjHsM2AiL9dhYs1E1DpZjj2wnEVHNKbaRUz4FWKWOEB/LfrTiq34PsFdqfZVyDNWk6aHY/TygvCr0zPhIw+iml66Eo4boHjHjgwhCetp7frlXaJKLTXJhP8p+UC7iAo1GOyXJhAJuHO9VCyikrW54kHrYdXrMcXO6A5G2E6bITCjVC4UanTnQtHcP6MGFaXl2PB8ndLQWqcg8tZYh9ln641Mo/HJEYDSGMuTcZJQaV+AMArNNymDUPK6AMviDcG/zeIZD4NVFU3QAk5r+X+UcPSGhVwG5w2jwo5H/cU8VICaDRVRKGpy0VcANw7IOoVvqtYMAQPD+XJu2MIhmKI2jWIWbv+AXr8ZRlcMKZ/DL5wWlQyTZXgSsp6GXK2muZS2ULBfgRMKmU5S/Rrk+ZrcpcTq0zMCLBV2C2z5o11DDvRUTCNcM9uF/kvtP9Le6FUPiX2pltdLGuP9+wttq8cH/J7CyPl1OI71A3OxFJnjeJ+KZXDYhsVsW/Koda2QEdvsO1rHnd9uC+T6o04vV3juaWTaadFiyR99S3+m7werTXZ2kFbquA2K8JHeT5J+5CtUv/JNA9XQQ/KPCljLNCP8YQcY7l3jFW9MSZrVWdhfR+yVayErmJpRQJzDOjT1m0CgE+tQleEOTTjjyluFovZaxadb1BSH5OzqF2gbTsz13baxYzmsVdyloJYDZo0cKwyTo7yabYyq8ngi+skYfJwLy/Y44wkqDBFB5AElaruCZJh6ae6GtN7gu4vwv1Fcf+V5BYExGoZABvgmIHDQksYZXJYEhi7j/Me7gLUv4TQX6kWY97RIcTRRXZCQ7n7/ZmlFtspra6uznJ6y1TnwBlj7afbSE0dWtQytcPRs3LXkNxhjfnFMuJFUwa+2Sg4VkdVxq697zrjfcnT3/fdd73vNf0+4l8k4x9i7nDIoGfP/4ly/mO93yB7y0pVUcI0nA7ab0OTTNamVO1huE/A+YZnrlNRg8a4lDoyF8mVEXMFddV3ks3I8Px39XcK34baRxS2C9F3iWcuhWeWkn5hTuBlp6yteTiWi1SuKKJK+zhK0nEKXcJaZY50Swtg8qi6wUQx+jnbvNxjy0555XGfLcxOJF3rAixcBphPSx1XQUBEwPazw2g/C9DGe2D+9LvR1waFV7QUNROvTcC1ZknvUQWWe+BJuvQCA3EKa1BQgzC458rFeuGeL/oQa4xSjhvU23Geo5YzpOdK1xP+TrOv2W4BWJWdMPEv5mChabGpCEE+0S0YW4/7T+6j5O7EgFHN8/ap2VKgGkQOE5RdzYMluGbP1kZ+/R1ouBdvW/PJ8RtyawaiXZs/uO7jn+ko7x4M9eeSDZpn65JDY3c2RnPx9j7M097XHs9FG7XbGtz1l8fSKyaG2tbuvmxi6totPbd+bMk5a7rqvfGgVtoSX1GuPB4uZEKhTH84nE8HAukC4O8w7TGA+LdFyomPK8IxVE+0eZyBWxl4gaePEKN4Log8+1jXGXKeH5GyqlJNad+ry6rdRlnV+Nx19FzOtNJBlXQurKTTMBdr6/ku1VMm2a8PGt3H8Zx9gLp9XGkfY2Mf116orX2Rur9PdRepM4YEfuQBWE6Em+od4nqHuN5VC9r6ml7fpVTfxcbP3MvAI7yv4wvCGmeHIckBl83BXMoJWzial5ZzGNwettUpDLxARjtqRD83Ak7m57QurZtiVHPKtkV89oQh2CdteW3yt1uW59CnrzOPzr2UveeE8NropNV7XJUp9JdqnJk8Nef2dn/792u9/2p/H0YX9t6aK+pXagoOHMBvis9/D/p1DGZeh9Kn3lmTl0lm3LmFReSHGdgjAKRt2EkiIELuOtbDVpEeMc4YXHic+3ovlYpcTx65Xo5OLUjFovDbI81yDKV1qE9CRM8KRtwjc2hBmRcpMJC4FQxBSAuS9Ri1AHS1jtFoBKTFEJsRo6xR2AyG0jrUJyEmf40shTSCFCIz5X6aS28C4OMc/fpFAJ6TLMpFT+6E42I4boADs0AehgOTQNpnDNHlSAhV3V6oCr3dF1dlOvTsBYk0Chz5M1Prlq1KdPSdceXEOVPrlqlXRjO4MYUtH87S74bk2SMoZHh9G0fXpM4awQ0oshtH1Q97cX+KtvCUF/eraI2I+SbyCuP83SlpE9I5f1mGCsj5XrUP1t5/Hd0vZYxwVcaove+7dF+yzCsbFD8Xh4ka11l5mOmeePY1/dlL6dkJejbME7dVVHIcgDkRPGWhHWklRU7w5QRcTuhrYTJPIrbrbJPNQYa0CXU/RA7O3C4RNqbv4YF74mbU6xbbw0Pf99qwU4fcgapmXw43ly6+Aba+bUf+/23bDpozxu0N/n/scm3ev0N4PibIicG4q0FK7mrAQrp0DN/BwIXVnSyM+2jcWN31QFKYG1i5vp4ler2yS7gO3ABjJ9Xx7ptWL7r3hWnP6oV7X5h3rBabX+h48pqOJ0JGLhLXCfIQh1hYDjGZCjMKtcJ9rRLtFH3fLPQ5WrP4vlkoelrJCUCr3cMvuogDQXWPK8epP0ItLfPvWH6kHYexzqnfqcmnluQ1TDLDNsE0SYL2lQRynwR0SQK1T5Kx1iaU3CRnZEkyMiYZGdlQK7Rd4WKjJ0u5ipOlFBiYY+AtBjYzcIiBozKm3S0TqghricfNaT8FLKJOSITvNaC33MK5aiiXKfoXyzsmCyJYEBEFWanUltHTQbjSxFi7tVAuKZHVH3005F3CYwjVa5Hi0Su8a6RZBx2MNpFZR190vV8uukZkkjiqOKhwyIe+V8wdBGBwKBbdjvHCM2oyY9Bqi6ruh5M0xrsX29XfxJYnCuOpJn9uRV+85FNfqfxUdZFzzt6Bc4vbP7qrFxeaJu9erU5qA3WpsU25ro3L0nXql9FhxzYwc9uWLQfPHsCctdH5ty3fI1tlRFmjmamcvuvLpgUDfNSQmUAYLXtF6GMvDHkv23F7Wfzq5SiVXk7D08u2AwIc+pN74cBC2vX4EQCOYnX7paXTFI5n11e1MGrAoq/hiBAduZgzb96nRqg5dhJLUvANVYNlfg4Nmh7pJDqYp9jtQXjFILxiEF4xqNQBJozLh067n4zcXLVasBILVhowUho4g7zbqshGi15NI/TufF7aId+R5seVVUetEZmeL1Fd5R+SCDfixm1f5V0D4qNfEmHAVtDHBoHODnJqDxkc/CIDX2FgPwEsA0ntZpLl7ksYmOTl8EsYmFZWS+lhcsFjFzOwhu++mIEpeky3OC6W+SMg04/ppkW/yRppyQlD49VN0a7W1q5oE//O9m24aGTFvoy/UCwGjRZFNEOOl/Je38Dw0tjSC9fmhIlxoLWUi0RypdbWUk8k0lNq/f86u9rQtq4zfM65vpLjD8my5MiWZVuO7Nj5cKXEmd2tTiyFeE2CGxviNnE22yGGxFsdUoXlY7T5gkK7MohZ2Z/sh4032pTSUuj+LIGlMNj+jNWDQsnwSEeXNWxsSUu2biOTd973Pe/VvZJcl4Zc6fjq6Nz3Hp17Pp7zPs87dHzPhkQq2lbvdyDFS6G6ynCiqbm93pfccxzGja167tKH+5F9OG58jL48EZxTb+dlS19hnkRxWGA+8gxiFr8d452TNHeUhWXXtsL3PPuezv7qXv3TQtDT+xz49J2CNn8V/fIZnRiljW4bg3HPs1ALR7Jz5krgLDuA19iJ+xl4L3Re/gFtnvDYPMd92QPTl7GPDQ6CUn93gxpQv9Zr3oueNVU38irYM6bbDASr7v+bLh3hSYiQSSKSEUPO8CNYQkAlOX5Dl96BZ4Dg2Y3hLvuhDTn+aODhnkRtZsYI+8PJE5ejlfGebE9iV3vDutZwXUNtpVU//cLewKYduzY0DbQ0VLYEWprsp74jX5vt3p2OVdVdrKoLROOBg7P5d7IjmwM1gfOVNfGI/C5w2f+i9snj6rZ+gh8WcYoCyCmCmUCAI2gusAJPQYcpy/rjWUcz3MaQuQscB2CEHVRh0zlNXiU2BpRYwD+Qw2h/VQ6jzRxGG/8w7ijGbewjV8ReixzyHT8w9KSdCPdGQcD80OLJC9mhC+r23IEDOC9a+UTXywmoF3moaJde8b6ymTFu4MQDTiwY6VLSKwlAT/c4x2nr5Mpq5BgYwMXh2sDBoZtnng84cdQbz4h26G0qeQvfbBoT4gZqmRTC2lDtOPJY7KyDtSN57HGrClCtW1zrlmeJXTHh1GIWQD/S07fqjNpLYa0AsTkkBhvZBOZAoQMFS+EuwskuUJD/1+LJUyMHT6l9UPVK9Ks+GbXWI6fsWimnDPwN0/rIEKfMwgRS1peYQIZiBq5JQZBH1juU8CPxBJwnRnA4hqHWNI87NG2AHCEUNYIJhUVzzUJot7XED87FI5E4HJn61k3R6KbWen5Xr9EH8Yj7rH6nNvexbnPP6jYXk5EyOsxZF5v/PrsHJXQizcu0+0xXvFrq2knslNplXNmEHZZ/bFncxJjXYXrCT7HD3y1OXKVEtaPaktIHzydtakdhwft5pBJtONemiz/FPpO3OHGVEtWosATE35Q+gO47og9TJqmlsLo0CO3Kgrp0ktWl++WzVn2ipy3StbG9Jtpg77Xq23paI12d7YEtfnW7pXdjtDpQHQnHersbdaKL+nvxO/lQDuvmvNXTwgCHtg25rQLbBOpxwBdAGyikJ7jyYb5GDl8UXI5176uVY9171OiUs02+KePIIdjh+d2dB/moh8FpIkXgwCOBnZsM996+fuwHupTgF5YnGU87SuRx72oOy7OgvF4r+T1dnrqR/5TKW3lVxsUiqOStVV6Kiug3RSzqEpTYJ99UMbTHL44XlWCzzxMTU0zwqmXnto0kP53wu+w2bG60G7BMucQEWCAIhHvx+FBbkf/Q1E7+Uxn8QnssikphO/2eMr2bXHZuk5SvbDphu+zxsCbMT+9H1pS2B0Ko6EOe1qb81FQuGESa46+qGNavXwyXsedLmVCRKr1qJ18198axVxbhMBeVYoe+cFqBmEKuBEe2DHKzTkQeuaVhSmghJQERCvG9CVcVwnrE2q7U4WDnCcqyKHgSSv7prbcW9X959cXXX38xn8P2xraFxStlbfMb+0JoH3isVTHfyeKtJIO6Fmwt7C25TfMjXZZSJCRTYXgxYHTAGA2cf5TDdQwntRZtPJqvX146f/P8yy/rl5fomR4Wb8s3VLW+4pby3Hq3l1YzEShLifbDzenBjo5MKh5PZTo6BtPNcgJeXWcBQz+oX35s2k+1mPJcDwm70ByWoc+oNbfswxQxfWudGW3h14Oq8z8iEgo0quo6qnVqVA1JPtTfr1/Pv0vHIv6D+bhc+av1iVrCfYondL9+UJwQz8vfeOzqSbG8QBbwUQo5Ba47/XQCfAuA0VbzCOGLJj00NOHT2IMiXXg6rRPAGVWmjxjX9zlNX58WpNc6bdbJO1M3dCk9Yhr/GtQXnq4joiQWP6SLH8JyxvXpES5+RBc/gqfBW/0k5z6pT540V/2FOMe5z+nc5xjwvUBP5YC+0i5uk9uhfre72qTpeQtL7jE4MWZO1NGOznZYHCyTAz2kW/X7mH7PLKMxGbRS0awtg9UIn07qXPuXkYm0Xw+v+ynHJZ1gusDMMn5lhhGiGV3QDBJyYc/oNDlonKZP23QipQ+VS2+zi7W31tLm0h3xWrGsiz+X/3lsIBkIJAce2/JEZ12wYyB/LhiqlLIyFOT3ogwyPpp//oD62xrZ8leKMtQk+p7s6n6yr63la3s3w7v82fr2jmCwo309vx8pyfKj/8Umi3ONFecaK86B/UJcZGUX8vwPe9Zb4DhqNF6mRIHT4RZvzPK2VzndRmHo/ynwvAe1xXiBgg/X3aivuw2v+0KREnc1r+6meHbpwP0LLkvWEhpwrHOvCNM8cakwqt6kFSC3uYzTg/7KQ3VWr7+3evoI2P9L0PyiDbZNcuhqltCNMoHPHmD/nUsM6zkhe0aZWoM9UY4gKJKPSaADK/ksuASuBAeJGmUykyjRJR3lzUTQLp3jzcQlz8ZtjiLDRJYQ7Ijo6XgEDW0xW7GtZF6rYFe95JJhAY6KpGseUYIVF+TfKZQrialSz7zZAeZ8+jukRugj0XOzZkxxhDyUTuI81XRdYlgGlkGPEAZUQCNAmZBZe4B1B7DaaBBIGIbHBjPX6jSrPqfWR9FhhSL/+tv97b5orz9J0IWJLtqV7O/d2K9fYA4fVU83DsQGJ6L6Ucz/07b/W/9BdHJnbGejLzncMXj627uDM6GnLGsydDi4+1undk4+rTZXr8t8fSiZHOofrKr6YXVlIns0A38OTO3uiAv0se+UMetXClyX18tuz6gDBMQAiT6QoEutmTcGaD5l4yo6w0BCkFesc15GGtBkaCoCG1ENznDu1hlhrhMsSANLrsCBNsCbMNoQNvyeTizp4yOis/gd0cBROJFjaheZCBMUH8ZYNoX5kTh2Rx/3keWhT7iVPOH7PHaTmhD8pCzqZNZnVbjWkrAYB90giPQXSmKwKnj/47Xx8WuzavzwuJrN//KsPHx2Vt347LP8UVmXf4DHN48cyd+A9eu/1V3xuXVGt8ffl+wlSepjBGMOlz0hd+mMw95R/FQpQjSUEEylNj3TPC+AGQ5SBAYIIuhe0l8BwtA8Veo6D2lokBQZYdNeiRUWvpriq2ZQF4v0OGFfrAmXAeGu3uj3r9zco+7OzcFNHFJ35TN4r++tptXVysZmGMxq5Xvdi8iMoAB91hbvffjRPRrW+nCXFlkqEBszlpp7D4C3TtG9Oz4StoPZKJfDBClO0u25db1+cvPKRevMHGNfd4EXKXyyfi1M0O+pVYvwJUPUKnHNeI5tuMWP0wInLnPilleiBvP4hHShhGWhQE8VlVSgJSZLfot5Bis90OEk25FxRS+1SJ+MoEODGB4mxFDXGSCGcuWerrMZrLN40bgeQJF6ULkPMI96hKvILRRqUUejuMdxQFWTSHoH1SzHknD3U2R1lp0es0bLKedGBeepERahglPcNDMcXG+K29F9QRChqVlCB+fpR10FIcwwkOgrQggN6Pe5Af3uOnjrn3X9zer6i8lN5bEvJzKgo20pCmcM7uXIeQmXXlftcjmoC3bowgh36YlxQ1lwizOATAOgYPMQqIUqjjIp2o4ui36lOEgxQ1sqh9esQjjMfBNRsIayKBjnvKQPgMvmoZv+UoDY7OqAmHWmDCCmVv6h6/4Y9mV++Y2i3oxmpTdRl6qCWu8o+4jAPDFDjxx4zQikrarCxBHPSsSZldPV5/Bj0wTTOpGhj/34hAG0PEjBoD0+uSbwcQ6zFZ5Za4IhkBzmt7EjUaSja1FHbDs9gSoZMKaKugXbadtqrR6UGlWFQQrcsSXqMbaE7hnm5mg+8rj6QDZaPwdMWzYUY9pm/jmBPjc1qHqiaA+6GNjGVmX8dZ8zm6kIdVsMdb9f0vWTQ7t5GFf4Y9dNrnPyQkczxQ/w+0zIZKzclNTMJTVzSc26JORr1jrERTe+DtvePoOxh+gWQnwLBKmvBaefXxVOt/asAqf/HzmJX8IAAAEAAAABAo8ukruxXw889QAZA+gAAAAAxbBeKwAAAADJluBn/+P/BgPoA7QAAAAJAAIAAQAAAAB4nGNgZGBg3vWfDUi++P/4/yPmFwxAERTwHACz4AhFAHicbZLNLgNRFMfPndlUBSHRBU1LpIo0PhrShkbSRCXE2FiwlAw7L2FhqbGw4yHE2lN4ABtCE2FFWIjxO8dMlZjkl3Pv+bhn7vlfkZ/PleFKDr1Qmt6eLMK435JZPy0lF8i+O5IG9BLf9XZkhnwPfx7bcJnokfwxqMNUTApWYBLKMKpry6dWz2hTkro/IgV6pbwzqUGRdZ1eNWI11kXvWupuU9b5x15dW03LYisWD6ViVutDKRHvIa8CafJSaqGb2BD32NF/xhbov+peuHsQvRHLe+cyz15tXvf067H1mVTpH7jN6AG/rTm3qn6LU6eW/Cr1I9i0xUL6X0gXVkkR0/45uZFZtfRvtGe/J2uwANMgmqMz4N+emE/RHcsge5uZzt58Afc4oUZ9TclBllhovQ9kgLOpl4rFLqWf+iX/VHKQgSxzmtC5/0sr+lAtTIcOmMGracEs4NlPR5+JDn/hv5axfbEWnagWlXhG+f9gbhnT4o+fnu+JFto/0SfW4Tf6vpJ4J2hhmqkm31oOwLC+HdWv/VbQS7VgzvfwYLMMolt9M+Tjl7kE8tc60LP1LW2QtwWOHNVmnPM89oX4HtvxPVpwp/fBV/0CzRez2AB4nB3VO2scVxgG4DEBk1SJ0suVmlQujBlWbCkcG9xEsRxb6L8E5grpXCUuzAFdsS6+EGkl0A1ByEFNgrdNlx/gJj9g8s3TPBxmd98z82q+o6Io7hTFV78Vd+78ercovvzil2KpKIeLcDLMw+Xhczgd3oQvh3/C9eHvcGP4I0yuX1vfMLsyH2bFd8XXw8/hApeG27BizYYtO/bh/dj9VTgZtsNlV6aubMTu92PHcX1tfcPsyjx8YMcHdnwQO87CijUbtuzYhw9jx8/hpLgbLnMayQ9jr9EclpH8KvwmksvIH9eLw9vwXiSU9iqLlXj2snjEx1z1zTWfPnflhfW66xvxjKU7LN1h6Q5Ld1i6w9IdlsWm325xmzvc5R7fcp8HPOQRj+14whlPecZzu1zwkle8doc3/DNyJhqeRA+34YL14vBXeI9Lrq/wMZ9Gt5PoYVyvRZOTaGB0Y/g3rFyv2bBlx56b3OI2d7jLPe7zgIc84ju7v+cHfuSxT0844ynPeO4OL3jJK16755twOXqYhQtcjMzlaGB0iSvx/eVoYFyvco0vWLFmw5Yde25K2OI2d7jLPe775gEPecRjnnDGU57xnBe85FU49YZP4y87usDF4UN4L06DaTzXm3Al3oRpPNfo0+G/cNX6x+hhWjyzfmH9MpqcxpOOv6rZsGXHnpt+tcVt7nCXe9znAQ95xHfu4T0/8COPfXrCGU95xnN3eMFLjm/7k+JJ9PCkmBffFmvRxnY4vudr0ca4fhSfrhXf8zF/8M1V62d8y30e8JBH/N33j61POOMpx7/Oy9j3NlwI163XrTesN6wr53PlfK6cz5XzuXI+V87nyvlcOZ8r53PlfK6cz5XzuZZTy6nl1HJqObWcWk4tp5ZTy6nl1HIaOY2cRk4jp5HTyGnkNHIaOY2cRk4jp5XTymnltHJaOa2cVk4rp5XTymnltHI6OZ2cTk4np5PTyenkdHI6OZ2cTk4np5fTy+nl9HJ6Ob2cXk4vp5fTy+nl9HKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msZLKSyUomK5msa2/vtbf3xvrGOmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmsmayZrJmvmU/FpeB0nzvNYz4uf4h2bx//ZcT0fXv8PwZog23icbZJtaM5hFMZ/QsTG8hJpo7xkGK28LY2WJhMhocVoQk1eWiFjI5myskmzNDYsbWttT89seEietY2tLbJh7Y2GzPs++OCDDz74la/+ddV9n/8517nOdW7473cZhkXB8CwYWQ6jemFMtEgXXTA2BSJGiGLhPdLcyFQRgHG/YHwmRN2DCXdgYiNMzoEpU4X3aXkQ7TnaHtF/IMa6mMcwfRLMkHOmXLOew5xOmBsBsebOM2d+BiwwL04s9L4oGeLNj7fnYmuWel5mfLm9Euy54jwkel95CFbZK2kDrP4NyVWwRh1rl4hS8RVSnCfFOVN+wrp8WP8eNqpn01PY4v9t9tqu7lRn2jEadqorzdiut7Bb7nR92SPvXmv2t0GGXAfEQfsd3gpH7JN5Fo7ug+PH4IRasoydfAintDvbGbMD/5AzG07LeaYMzpmbq5e5cl7wnOcOLpqfrzcF1hfIf8k5CtVfOAhXrCnSn6vmFnu+thmu60OJ/pTIU6ovN4zdtPaWPpU5z+14KDe3wntFkbC+wp1WOmNlolB/ld5WW1PtXqrdb401NWqsUUdA7oDzB/Q0qLZggnBXQecN+j6C9qw1Xuu5zlid/HVDUC9nvbupV99d+93X+1Cs0KOQvULuIOR8D+R/5D3sv7Daw77JsHrD9m6Qo8E9NBhrUFuj+2oyv0k/mtTXZJ9mZ2hWwxNna9HfFnfWal1rkpC31bfdZl27u2vXt2fqe+G77IgTaunQ+w61dLqjl+a8Mv7a3Xapodu30K2mbmfr9p30OHuPWnqN9xrr08M+30W/c/bb542+DDjvgPzv/P/Bmo96N+h7+OR8n9Pgi5q+2eu7PD+G/gJs3+JjAAAAAAEAAADnAHwABwBYAAQAAQAAAAAACgAAAgADXQACAAF4nO1XS29ctxWmIzmKHcuIahQ1mkWJFq3tWrqaMWTrsQigGJKiQJEEaewgu3Lu5cwwvq+QvDMZ/YaiQP9A9+ky6/6Hbrppf0ZXRRdFzzkk7zz1cNKiBVoNLnUueXge33mQlzH2s1u/Z7cY/S38GQZHw7jwF0+/w5YW/urpBfZ04e+eXmQPF3/h6dvs3uJHnn6X/XDxU08vsd8u/srT77HlxSDnDm7x9N0x+n32o5q+x35++6Gnlxf+eDvIv89+cue+pz8AUZGnV8boH7CHQC+wW4ugaenbO/uehtUP/ubpd9j9lceeXmCvV154epE1Vn7t6dvs4cofPP0u++XKnzy9dOunK//w9Hvsxw+4p0Hbgx1P3x2j32dRTd9jnz7oeXp56XcPvvX0ffbRh6eeBr8+/I2nV5A+FdryosNtT/JEdZUVaTrkMo+LRCY8E3FP5ZJrKRLRTiUvKpviRCKs4J1C81IXSRWrvEsSWsNSdkQsDc73FYpQhsdFOdSq27Pw+g1vbm81+Rp/1mhs8yOVFxb28IOs/ckqHwwGUeqnorjIIr6bppy2GrDBSN2XScRbPRBqio4dCC1RAaoGhaXUdojOTIkVOXoy5DDJ2+iMM1omq7wyOCbKlKkYIpkVieooPxmnBaxzcNNqkZuO1BpeB8r2AAfSKr8uwS7DB1pZK3MuSnRcpDNWRBzMvhHEtWNXwZuqWOZomy34sKimUX4cP0Gct1Zh3G7QuMF3kwK8Px8aKzPjoD1z0J7dHNoJIfwQnNBloQUqRZiVDbYV2vzHkCcjI76vK6u6UqMfAgUlMhP6zUxswK6uAodQhcpJ+qvoPOKn4FZuyYlWvfmk0wH/as/Iq/HdMSAl4H8BYjT/stLKJCq2qsiNh9f6KKJZBURM5WA1lOGgcLbtJlqJvLY+cokjjermQSW4amVsJzVO6mK190ct/nmjyTef849TEb85k90qFZpNQLBzGffOs0azcams11Ib0MabUaMZeI5awLG2+ZwY2H9dDCb9Zj1ry5319enOc9n8eqfIrYsFuM6OT1qH+4cvd1uHJ8f8ZJ8fHb7cOz7f47sHZ3t7n+0dt5bvLt/9AuqzJ/rQPNtoFRYtpgFKGpWaVGRrojTEFdpDRxfZFEJYDEVXEh9WwmgzFIzVql1hQrShTKGdjOH7qG4X0kRoUGtWPUUHqqeiFiSMkXZOC3uVp1hyw+AQRMZDDm1IcFPKGEo4Duq46GopM4xfF6rYYhvDvSJJFAZDhN6+itMaW4I7iuaZl6pM2brhAQJQLcYKlEOdkiaLQY5SIo6Yh8aDjRHBG6E0R0XEDzsjx0Q+5F9V0lDKYHIJnXjrde0d+J6B6WUqhcEM7Cs5oMSddR8FQ2Cl6vsuRny1bgzKgYSMAkQmpFOKV0Z0ZTgFY+gMkO+oC1uunTkz172AkVCZQkiP1IXML9oS3ajyLjTMCkQfV/YC3gzYBucG76g8gZVzJWHVYppdJfwUwSjTyvDkkcohBplweMVFDhWYQ8Q5aIY3KHsLTNAJUmVcyJKKp0VXxUqm0Nt4WaBkQLMvKwX2XuA2U6VoBKiHFDAQfT6Q7attmqwYDxZaIKhbCrtDBSDTaIc/3dh+3Hjyorn5jG9sbaxtNLcurXqvYqIPvoQCDX2QnTLBNLOMs4J1YLSsxyT8T5hiXXgsrKfwG8KcZDmLgS8BKoH3DNZi4Fcwj3s0jAJWBGvDDkkyK5CQ1hy4hhI56CqAn7MSRpRYgSTk6o7Z0AKtJVAd0iOZqfn7wBusUDSPdpXAr8nuHshwq9/A02TbbAtGztbgecYa8NsG6og0FsDr9HB2AD612SdsFegB/SJv/YgrIl0Z/Odsl7DhY1qNx8HAo8FOtCIiX3reUkNIW5AtiDN4ELx2Hpa03xLuLjJXWytgLcQE9zhODushMuNIo1W4qyI7HZ2QHSX4gxLCbEZ7FFigpjhj4Cz8fu6jaWFESwzwo/3arw4ok3o+H0a+SvY12YV4GeLTxGkp19Crso64IKSvwwKxdmj/67J4NmLfNXsxl2KyIOBmYT8HTkTmulx+DCtP6nzeolggvQ35PKI3KC8TkOFifw6SDMnI4P941p5NZO3ZvyVrL7eEs0MfCQ37Csqc4GnIZuVtG8cNOc3/YM6PkMTI7AMHysUISrLDxUPUFiWEM0brzQ3qxuHVJSmWJIbumo/Z/gp0n5P+Ux+tnHwLkWjN0XwCmjs+frMxG8XqMt2xzynh3wtvDfr8JWCgaV9CGhCPgmIxmb12qhYDWoWvMZTssHan4YBW3kxgj5yCLJjGPuhyHQfjiiv5jJcuquhhXGf6fB+v8ms28kegnbPPoQvgGbfJnsP4MeV0DD6cEbYVvesrMmDnrSXv0FnahOdtd74mLuO9ws4VEee0HJTiZKyRjJGE/+f/dfl/ua896jYlxG8dftfdc96Oe53ORkRlvBJctI8BixZ0/X14XkJNIX0Cs4jRPkUH5/dg5hxGrLoDyN49+H1Gsy22zO7S84U/L3uASt/fNNs1RuFkDdUfLJp3iknfpR2eiKL29eluCx2q2eya3AknQUHZOJIXzoB5mhMfb4xfm3LZ2d32p2fu/ZqXt4/m3CYkRT0g1LqR96OacWdNNXbrEXQ+ybFvg6tvXa9gLa1PteFMhFytTGa3u/0Isq0k3JWvlWnvkKtLe7G2Qt11/dlr69tX0ItVmBD6riLEzD19tebGSFVey+gr6KbooZ0ZaZq90bkccGeJofwM9ozukCPOAnjz2hbENOT59A0n3BBD5s3LpZt5gVoOyefZiCGyqOMrmJckP3SX0LFQRjKFvZ4TOxf3zKNeUp4Iv4aS+nTTGox12ptEP1jsKhYruT919xrJm/U7VMoByZOUSemVto+6N0ZIUK1Pf/vF/o7g+nrwK9xqLbv+u3J9yoJ5lkq6wUtfkxc0f0E6QzQqGqXPJ2f1MWXGhV8zHreez5YO7Uz8nnOy3O21dTf7rpaf1plRUpcxlLOPSI6rg2ysNsI3UO7PvtzXOPc+xz6btUcUJbm7QEr5Pl5lCWVISp1ZUX+RFOXE38iK2maXm5hBFUlCXRe1NkM3qICE8177zFIeQYxz+3vhdNUZM5lZAQMxdpdEv3fGTgD0NIIZzp7CV+E2fD824PvxBdymNuHmxmFuC541eJpAve05P+HDPwEoM6nHAAAAeJxjYGYAg/9bGYwYsAAALMIB6gB4nF2PPU7DQBCFvw2QOIH8mNiBEEBBILAwUNBQpgEaOiqgpKOhSZ0r0HMLl9YW5igcBd6uFiS7mvn0Zua9KSHHYujSyo2lR981lZpDpiQMpER5xSYZR+wxVud4iwtO2CdV57gvdSYaBX0Q9ESK4yE3XHKsmdjzSP0BO6o9zzFXnMoz1abjbc6Ya/rPb9zIk/j9yf9+yjsv3HOtOceT4DeVc5RT6cV64FYwiIPBWoPX/YFM54aeN/hkxasszj23awYVnUagqBGoWw9k9XubTl7C/G71tntrWcjdLC1foX6H+hPqQvfN8qEke3wqzKzguTAfvwpvOToAAHiczVZLbuNGEN0HyB0KBDKYASRS8ge2J5QNB8jHgJMZjJ3FLFvdRanjZjfT3ZSs3RwkOUDOkEWAHGUukCukqknKkscwZpdsaLNZn/defVr//PlXeXFfG1ihD9rZWTbNJxmglU5pu5hlbazGp9nF+ZdflDVGoUQU+7b0BaBsrf61Ra1Aq1l2MhHqoJoej89wiuMjcXQwPq2UHB9ODg9OsDqeTuRhBkXnuUKrnAcrapxllbMx5NLVGbTezLJljM3rotg57r2kR6VjSC/b1z7I1qjYtSoVBul1Ewn54BbxPgKxf20Ec0WbnZcFH/b+j11KoyXagHvg1ut1vgVYyDZEV6Mv1jgfp+MxtkZkz6S8XeoAbArBVXEtPAIdxCXCSphWzA1C412DPm7AVfCjsy5uGoSrWiyoRnBlZT4C4gmiqrTRImKAF6JuvobQzoNWWniNYQTCqoKkZsvQNo3RVEd4KZ0xKKNeodnAxw+/DfE/fvj9Fbsk+5ZIzzewcS1jk45aABW0VqFPSCP6OjA6fhlUEguPWCMRm2NcI9rkzyG3HF6yPSW97lw4Zw7vyaoWG3jz0/X7lDk+oZAFIaXzSliJsNZxuY+jD5jDt/cSmwiCODcodaWlMESU5Kx1jESCaLFn7zBKGDk7IQRhKOCI+DabEZB0Sofo9byNT2HK4apK3kuxIvJ2AzQSgZuHtG8MCmIiyUHIuBUg3+u3Xri+xSmp14tlfKZ13gofB9WVXuiYuKXpJWa1kEttETzS3HIbuTYaPkhTXBEf6ivVSm4ijnBLgCohqXvofKU5RCp2j4Ne//4DpmenUxjDwWRyRpr1Zfy+nv8wAp4E0x/xMORwaQwk30AgAvoVqhxSvz9u9d0OfxSWG2YoyJzZdKhRjbg56ElVaYzY8L81ra1K94fSOPrOdYte2FCh56blXiEhUla8bwhXgLXnXqCWapi5MJ+gyIFgf5bGW2LP6dsXWkF0DzP1IPNL+Yp1Ph3R82ySnkdwqRyxv9mEiHXopH3XSfvu86XdC8Kbw/nGecFJh1HvsDkf/jPlE8gcvvNt1AtaMMRDcCCFtfB3n9SGcC1oLtNGorXA0X/Ob3J4S7RoPJnE7db5Da1IiVtmidWutySlBP11FMbDL63XQWmZhriXN/ZVZFiOKqYtoaY5XLsO26XyWtgt+rxrHAx6YYeURDXSyt3PuJ9rby/sr4JyK8Uzm+F/J94eoX0GJX2gltu5mDW1Z/opwVuku1y71ot5QOHlkvfM3XCpkgPf/I93Y+cAbFkWbPBgzhfrY/snr/Mu28NlftEdMJXZIPFXB5PrW3qcHNPjGyPk3YubZHVlZ1vHskg5B4IFM+zF2GVfFsOvrPN/AYCNVII=) format("woff");
                }

                html {
                    font-size: 16px;
                    color: #333333;
                }

                body {
                    margin: 0px;
                    padding: 0px;
                    background: #FFFFFF; 
                }

                body, div {
                    font-family: Frutiger, Arial, sans-serif;   
                }

                #container {
                    margin-left: auto;
                    margin-right: auto;
                    width: 1200px;
                    max-width: 95%;
                    background-color: #FFFFFF;        
                }

                .logo {
                    margin-top: 20px;
                    text-align: right;
                    min-width: 50px;
                }

                #logo {
                    max-width: 100%;
                    min-width: 200px;     
                }

                .breadcrumb {
                    font-size: 13px;
                    line-height: 40px;
                    display: inline-block;
                    vertical-align: middle;
                }

                ul.breadcrumb {
                    line-height: 40px;
                    padding: 10px 10px;
                    list-style: none;
                    background-color: white;
                }

                ul.breadcrumb li {
                    display: inline;
                    font-size: 13px;
                }

                ul.breadcrumb li.active {
                    color: #777777;
                }

                ul.breadcrumb li+li:before {
                    padding: 8px;
                    content: ">";
                }

                ul.breadcrumb li a {
                    color: #001c00;
                    text-decoration: none;
                }

                ul.breadcrumb li a:hover {
                    color: #001c00;
                    text-decoration: underline;
                }

                ul.breadcrumb li a:visited {
                    color: #001c00;
                    text-decoration: underline;
                } 

                #title {
                    margin-top: 20px;
                    margin-bottom: 30px;
                    font-size: 28px;
                    font-weight: 700;
                }

                h2 {
                    font-size: 18px;
                }

                h3 {
                    font-size: 16px;
                    font-style: italic;
                    font-weight: 700;
                    margin-top: 10px;
                    margin-bottom: 10px;
                }

                p {
                    font-size: 16px;
                    line-height: 1.5;
                    margin-bottom: 40px;
                }

                p.datenebene {
                    margin-top: 10px;
                    margin-bottom: 15px;
                }

                a.black-link {
                    overflow: hidden;
                    text-overflow: ellipsis;
                    color: #333333; 
                    text-decoration: none !important;
                }

                a.black-link:hover {
                    color: #333333;
                    text-decoration: underline !important;
                }  

                a.black-link:visited {
                    color: #333333; 
                    text-decoration: underline !important;
                }  

                a {
                    overflow: hidden;
                    text-overflow: ellipsis;
                    color: #c62828; 
                    text-decoration: none !important;
                }

                a:hover {
                    color: #c62828;
                    text-decoration: underline !important;
                }  

                a:visited {
                    color: #c62828; 
                    text-decoration: underline !important;
                }  

                table { 
                    border-collapse: collapse; 
                    width: 100%;
                    table-layout: auto;
                    margin-bottom: 40px;
                }

                th {
                    text-align: left;
                    font-style: italic;
                    font-weight: 400;
                }

                tr {
                    line-height: 1.5;
                }

                tr:first-child {
                    border-bottom: 1px solid #eee;
                }

                tr:nth-child(even) {
                    background-color: rgba(237, 237, 237, 0.4);
                }

                tr:hover {
                    background-color: #e8e8e8;
                }

                td {
                    vertical-align: top;
                    padding-left: 5px;
                    padding-top: 3px;
                    padding-bottom: 3px;
                    padding-right: 10px;
                }

                @media print {

                    @page {
                        size: A4;
                    }

                    #logo {
                        width: 60mm;
                    }

                    #title { 
                        /*font-family: serif;*/
                        margin-top: 5mm;
                        font-size: 20pt; 
                    }

                    h2 {
                        font-size: 14pt;
                    }
                    
                    h3 {
                        font-size: 12pt;
                    }

                    p { 
                        font-size: 12pt;
                        line-height: 1.1;
                        margin-bottom: 8mm;
                    }

                    table { 
                        font-size: 10pt;
                    }

                }
            </style>
        </head>

        <body>
            <div id="container">
                <div class="logo">
                    <div>
                        <img id="logo" src="data:image/png;base64,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" alt="Logo Kanton Solothurn"/>
                    </div>
                </div>

                <div id="breadcrumb">
                    <span style="line-height:40px; vertical-align:middle;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-house-door-fill" viewBox="0 0 16 16">
                            <path d="M6.5 14.5v-3.505c0-.245.25-.495.5-.495h2c.25 0 .5.25.5.5v3.5a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.146-.354L13 5.793V2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1.293L8.354 1.146a.5.5 0 0 0-.708 0l-6 6A.5.5 0 0 0 1.5 7.5v7a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 .5-.5z"/>
                        </svg>
                    </span>
                    <i style="line-height:40px; vertical-align:middle;" ></i>
                    <ul class="breadcrumb">
                        <li><a href="https://geo.so.ch">Home</a></li>
                        <li><a href="https://sogis-sodata-kfjfk.ondigitalocean.app/">Datenbezug</a></li>
                        <li class="active">Datenbeschreibung</li>
                    </ul>
                </div>

                <div id="title">
                    <xsl:value-of select="title"/>
                </div>

                <h2>Beschreibung</h2>
                <p>
                    <xsl:value-of disable-output-escaping="yes" select="shortDescription"/>
                    <xsl:if test="furtherInformation">
                        <br/><br/>
                        Weiterführende Informationen: 
                        <xsl:element name="a">
                            <xsl:attribute name="target">
                                <xsl:text>_blank</xsl:text>
                            </xsl:attribute>
                            <xsl:attribute name="href"><xsl:value-of select="furtherInformation"/></xsl:attribute>
                            <xsl:value-of select="furtherInformation"/>
                        </xsl:element>
                    </xsl:if>

                </p>

                <h2>Datum der letzten Publikation</h2>
                <p>
                    <xsl:value-of select="format-date(lastPublishingDate,'[D01]. [MNn] [Y0001]')"/>
                </p>

                <xsl:if test="model">
	                <h2>Datenmodell</h2>
	                <p>
	                    <xsl:element name="a">
	                        <xsl:attribute name="target">
	                            <xsl:text>_blank</xsl:text>
	                        </xsl:attribute>
	                        <xsl:attribute name="href">https://geo.so.ch/modelfinder/?expanded=true&amp;query=<xsl:value-of select="model"/></xsl:attribute>
	                        <xsl:value-of select="model"/>
	                    </xsl:element>
	                </p>
	            </xsl:if>

                <h2>Lizenz</h2>
                <p>
                    <xsl:element name="a">
                        <xsl:attribute name="target">
                            <xsl:text>_blank</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="href"><xsl:value-of select="licence"/></xsl:attribute>
                        <xsl:value-of select="licence"/>
                    </xsl:element>
                </p>

                <h2>Kontakt (fachlich)</h2>
                <p>
                    <xsl:value-of select="owner/agencyName"/><br/>
                    <xsl:if test="owner/division">
                        <xsl:value-of select="owner/division"/><br/>
                    </xsl:if>
                    Telefon <xsl:value-of select="owner/phone"/><br/>
                    <xsl:element name="a">
                        <xsl:attribute name="href"><xsl:value-of select="owner/email"/></xsl:attribute><xsl:value-of select="substring(owner/email, 8)"/>
                    </xsl:element><br/>
                    <xsl:element name="a">
                        <xsl:attribute name="target">
                            <xsl:text>_blank</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="href"><xsl:value-of select="owner/officeAtWeb"/></xsl:attribute>
                        <xsl:value-of select="substring(owner/officeAtWeb, 9)"/>
                    </xsl:element>
                </p>

                <h2>Kontakt (technisch)</h2>
                <p>
                    <xsl:value-of select="servicer/agencyName"/><br/>
                    Telefon <xsl:value-of select="servicer/phone"/><br/>
                    <xsl:element name="a">
                        <xsl:attribute name="href"><xsl:value-of select="servicer/email"/></xsl:attribute><xsl:value-of select="substring(servicer/email, 8)"/>
                    </xsl:element><br/>
                    <xsl:element name="a">
                        <xsl:attribute name="target">
                            <xsl:text>_blank</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="href"><xsl:value-of select="servicer/officeAtWeb"/></xsl:attribute>
                        <xsl:value-of select="substring(servicer/officeAtWeb, 9)"/>
                    </xsl:element>
                </p>

                <h2>Dienste / Web GIS Client</h2>
                <p class="datenebene">
                    <xsl:if test="services">
                        <xsl:if test="wgcPreviewLayer">
                            <xsl:variable name="wgcPreviewLayerUrl">https://geo.so.ch/map?l=<xsl:value-of select="wgcPreviewLayer/identifier"/></xsl:variable> 
                            Themenvorschau im <a href="{$wgcPreviewLayerUrl}" target="_blank">Web GIS Client</a>.
                        </xsl:if>

                        <br/>
                        <br/>
                        Tabellen dieses Themas sind in folgenden Diensten als Karten- oder Datenlayer publiziert:

                        <table>
                            <colgroup>
                                <col span="1" style="width: 70%;"/>
                                <col span="1" style="width: 10%;"/>
                                <col span="1" style="width: 10%;"/>
                                <col span="1" style="width: 10%;"/>
                            </colgroup>
                            <thead>
                                <tr>
                                    <th>Karten-/Datenlayer</th>
                                    <th style="text-align:center;"><a href="https://geo.so.ch/map" target="_blank">WGC</a></th>
                                    <th style="text-align:center;"><a href="https://geo.so.ch/api/wms?SERVICE=WMS&amp;REQUEST=GetCapabilities&amp;VERSION=1.3.0" target="_blank">WMS</a></th>
                                    <th style="text-align:center;"><a href="https://geo.so.ch/api/wfs?SERVICE=WFS&amp;VERSION=1.0.0&amp;REQUEST=GetCapabilities" target="_blank">WFS</a></th>
                                    <th style="text-align:center;"><a href="https://geo.so.ch/api/data/v1/api/" target="_blank">Dataservice</a></th>
                                </tr>
                            </thead>
                            <tbody>

                                <xsl:for-each-group select="services/service" group-by="layers/layer/identifier">
                                    <xsl:sort select="current-grouping-key()" data-type="text" order="ascending"/>
                                    <tr>
                                        <td><xsl:value-of select="current-grouping-key()"/></td>

                                        <xsl:comment>https://icons.getbootstrap.com/</xsl:comment>
                                        <td style="text-align:center;">
                                            <xsl:choose>
                                                <xsl:when test="current-group()[type='WGC']">
                                                    <xsl:variable name="wgcUrl">https://geo.so.ch/map?l=<xsl:value-of select="current-grouping-key()"/></xsl:variable> 
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-box-arrow-up-right" viewBox="0 0 16 16">
                                                        <a class="black-link" href="{$wgcUrl}" target="_blank">
                                                            <rect width="16" height="16" style="fill:#FFFFFF00;stroke:none" />
                                                            <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
                                                            <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
                                                        </a>
                                                    </svg>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                    <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                                    </svg>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                        <td style="text-align:center;">
                                            <xsl:choose>
                                                <xsl:when test="current-group()[type='WMS']">
                                                    <xsl:variable name="wgcUrl">https://geo.so.ch/map?l=<xsl:value-of select="current-grouping-key()"/></xsl:variable> 
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-lg" viewBox="0 0 16 16">
                                                    <path d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1 .02-.022Z"/>
                                                    </svg>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                    <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                                    </svg>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                        <td style="text-align:center;">
                                            <xsl:choose>
                                                <xsl:when test="current-group()[type='WFS']">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-lg" viewBox="0 0 16 16">
                                                    <path d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1 .02-.022Z"/>
                                                    </svg>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                    <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                                    </svg>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                        <td style="text-align:center;">
                                            <xsl:choose>
                                                <xsl:when test="current-group()[type='Dataservice']">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-lg" viewBox="0 0 16 16">
                                                    <path d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1 .02-.022Z"/>
                                                    </svg>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                    <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                                    </svg>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                    </tr>
                                </xsl:for-each-group>
                            </tbody>
                        </table>

                        Geobasidaten nach Bundesrecht werden ebenfalls auf <a href="https://geodienste.ch">geodienste.ch</a> publiziert.
                    </xsl:if>
                </p>

                <h2>Inhalt</h2>

                <xsl:apply-templates select="tablesInfo/tableInfo" /> 

            </div>
        </body>
        </html>
    </xsl:template>

    <xsl:template match="tableInfo">

        <h3><xsl:value-of select="sqlName"/></h3>

        <p class="datenebene"><xsl:value-of disable-output-escaping="yes" select="shortDescription"/></p>

            <table>
                <colgroup>
                    <col span="1" style="width: 25%;"/>
                    <col span="1" style="width: 50%;"/>
                    <col span="1" style="width: 13%;"/>
                    <col span="1" style="width: 12%;"/>
                </colgroup>

                <tr style="border-bottom: 1px solid #eee;">
                    <th>
                        Name
                    </th>
                    <th>
                        Beschreibung
                    </th>
                    <th>
                        Datentyp
                    </th>
                    <th>
                        Pflichtattribut
                    </th>
                </tr>

                <xsl:for-each select="attributesInfo/attributeInfo">
                    <xsl:sort select="name"/>
                    <tr>
                        <td>
                            <xsl:value-of select="name"/>
                        </td>
                        <td>
                            <xsl:value-of disable-output-escaping="yes" select="shortDescription"/>
                        </td>
                        <td>
                            <xsl:value-of select="datatype"/>
                        </td>
                        <td>
                            <xsl:if test="mandatory='true'">
                                <xsl:text>ja</xsl:text>
                            </xsl:if>
                            <xsl:if test="mandatory='false'">
                                <xsl:text>nein</xsl:text>
                            </xsl:if>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>

    </xsl:template>

</xsl:stylesheet>