/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine;

import eu.solven.cleanthat.engine.IEngineFormatterFactory;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.language.IEngineProperties;
import java.util.Map;
import java.util.Set;

public class StringFormatterFactory
implements IEngineFormatterFactory {
    final Map<String, IEngineLintFixerFactory> engineToFormatter;

    public StringFormatterFactory(Map<String, IEngineLintFixerFactory> languageToFormatter) {
        this.engineToFormatter = languageToFormatter;
    }

    @Override
    public IEngineLintFixerFactory makeLanguageFormatter(IEngineProperties languageProperties) {
        String language = languageProperties.getEngine();
        IEngineLintFixerFactory formatter = this.engineToFormatter.get(language);
        if (formatter == null) {
            throw new IllegalArgumentException("There is no formatter for language=" + language + " languages=" + this.engineToFormatter.keySet());
        }
        return formatter;
    }

    @Override
    public Set<String> getDefaultIncludes(String engine) {
        return this.engineToFormatter.get(engine).getDefaultIncludes();
    }
}

