/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.formatter;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.AtomicLongMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriter;
import eu.solven.cleanthat.codeprovider.IListOnlyModifiedFiles;
import eu.solven.cleanthat.config.ConfigHelpers;
import eu.solven.cleanthat.config.IncludeExcludeHelpers;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatRepositoryProperties;
import eu.solven.cleanthat.engine.EngineAndLinters;
import eu.solven.cleanthat.engine.ICodeFormatterApplier;
import eu.solven.cleanthat.engine.IEngineFormatterFactory;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.formatter.CleanthatSession;
import eu.solven.cleanthat.formatter.CodeFormatResult;
import eu.solven.cleanthat.formatter.ICodeProviderFormatter;
import eu.solven.cleanthat.formatter.PathAndContent;
import eu.solven.cleanthat.formatter.SourceCodeFormatterHelper;
import eu.solven.cleanthat.github.IHasSourceCodeProperties;
import eu.solven.cleanthat.language.IEngineProperties;
import eu.solven.cleanthat.language.ISourceCodeProperties;
import eu.solven.pepper.thread.PepperExecutorsHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeProviderFormatter
implements ICodeProviderFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeProviderFormatter.class);
    public static final String EOL = "\r\n";
    private static final int MAX_LOG_MANY_FILES = 128;
    final IEngineFormatterFactory formatterFactory;
    final ICodeFormatterApplier formatterApplier;
    final SourceCodeFormatterHelper sourceCodeFormatterHelper;
    final ConfigHelpers configHelpers;

    public CodeProviderFormatter(ConfigHelpers configHelpers, IEngineFormatterFactory formatterFactory, ICodeFormatterApplier formatterApplier) {
        this.configHelpers = configHelpers;
        this.formatterFactory = formatterFactory;
        this.formatterApplier = formatterApplier;
        this.sourceCodeFormatterHelper = new SourceCodeFormatterHelper();
    }

    @Override
    public CodeFormatResult formatCode(CleanthatRepositoryProperties repoProperties, ICodeProviderWriter codeWriter, boolean dryRun) {
        boolean isEmpty;
        AtomicBoolean configIsChanged = new AtomicBoolean();
        ArrayList prComments = new ArrayList();
        if (codeWriter instanceof IListOnlyModifiedFiles) {
            try {
                codeWriter.listFilesForFilenames(fileChanged -> {
                    if (fileChanged.getPath().startsWith(".cleanthat")) {
                        configIsChanged.set(true);
                        prComments.add("Spotless configuration has changed");
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("Issue while checking for config change", e);
            }
        } else {
            LOGGER.debug("We will clean everything");
        }
        AtomicLongMap languageToNbAddedFiles = AtomicLongMap.create();
        AtomicLongMap languagesCounters = AtomicLongMap.create();
        LinkedHashMap pathToMutatedContent = new LinkedHashMap();
        CleanthatSession cleanthatSession = new CleanthatSession(codeWriter.getRepositoryRoot(), (ICodeProvider)codeWriter, repoProperties);
        repoProperties.getEngines().stream().filter(lp -> !lp.isSkip()).forEach(dirtyLanguageConfig -> {
            IEngineProperties languageP = this.prepareLanguageConfiguration(repoProperties, (CleanthatEngineProperties)dirtyLanguageConfig);
            AtomicLongMap<String> languageCounters = this.processFiles(cleanthatSession, (AtomicLongMap<String>)languageToNbAddedFiles, pathToMutatedContent, languageP);
            String details = languageCounters.asMap().entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(EOL));
            prComments.add("engine=" + languageP.getEngine() + EOL + details);
            languageCounters.asMap().forEach((l, c) -> languagesCounters.addAndGet(l, c.longValue()));
        });
        if (languageToNbAddedFiles.isEmpty() && !configIsChanged.get()) {
            LOGGER.info("Not a single file to commit ({})", (Object)codeWriter);
            isEmpty = true;
        } else {
            LOGGER.info("(No config change) About to commit+push {} files into {}", (Object)languageToNbAddedFiles.sum(), (Object)codeWriter);
            if (dryRun) {
                LOGGER.info("Skip persisting changes as dryRun=true");
                isEmpty = true;
            } else {
                codeWriter.persistChanges(pathToMutatedContent, prComments, (Collection)repoProperties.getMeta().getLabels());
                isEmpty = false;
            }
        }
        codeWriter.cleanTmpFiles();
        return new CodeFormatResult(isEmpty, new LinkedHashMap(languagesCounters.asMap()));
    }

    private IEngineProperties prepareLanguageConfiguration(CleanthatRepositoryProperties repoProperties, CleanthatEngineProperties dirtyEngine) {
        IEngineProperties cleanEngine = this.configHelpers.mergeEngineProperties((IHasSourceCodeProperties)repoProperties, (IEngineProperties)dirtyEngine);
        String language = cleanEngine.getEngine();
        LOGGER.info("About to prepare files for language: {}", (Object)language);
        ISourceCodeProperties sourceCodeProperties = cleanEngine.getSourceCode();
        List includes = cleanEngine.getSourceCode().getIncludes();
        if (includes.isEmpty()) {
            Set<String> defaultIncludes = this.formatterFactory.getDefaultIncludes(cleanEngine.getEngine());
            LOGGER.info("Default includes to: {}", defaultIncludes);
            cleanEngine = this.configHelpers.forceIncludes(cleanEngine, defaultIncludes);
            sourceCodeProperties = cleanEngine.getSourceCode();
            includes = cleanEngine.getSourceCode().getIncludes();
        }
        LOGGER.info("language={} Applying includes rules: {}", (Object)language, (Object)includes);
        LOGGER.info("language={} Applying excludes rules: {}", (Object)language, (Object)sourceCodeProperties.getExcludes());
        return cleanEngine;
    }

    protected AtomicLongMap<String> processFiles(CleanthatSession cleanthatSession, AtomicLongMap<String> languageToNbMutatedFiles, Map<Path, String> pathToMutatedContent, IEngineProperties engineP) {
        ISourceCodeProperties sourceCodeProperties = engineP.getSourceCode();
        AtomicLongMap languageCounters = AtomicLongMap.create();
        FileSystem fs = cleanthatSession.getRepositoryRoot().getFileSystem();
        List includeMatchers = IncludeExcludeHelpers.prepareMatcher((FileSystem)fs, (Collection)sourceCodeProperties.getIncludes());
        List excludeMatchers = IncludeExcludeHelpers.prepareMatcher((FileSystem)fs, (Collection)sourceCodeProperties.getExcludes());
        ListeningExecutorService executor = PepperExecutorsHelper.newShrinkableFixedThreadPool((String)"Cleanthat-CodeFormatter-");
        ExecutorCompletionService cs = new ExecutorCompletionService((Executor)executor);
        ThreadLocal<EngineAndLinters> currentThreadEngine = ThreadLocal.withInitial(() -> this.buildProcessors(engineP, cleanthatSession));
        try {
            cleanthatSession.getCodeProvider().listFilesForContent(file -> {
                Path filePath = file.getPath();
                Optional matchingInclude = IncludeExcludeHelpers.findMatching((List)includeMatchers, (Path)filePath);
                Optional matchingExclude = IncludeExcludeHelpers.findMatching((List)excludeMatchers, (Path)filePath);
                if (matchingInclude.isPresent()) {
                    if (matchingExclude.isEmpty()) {
                        cs.submit(() -> {
                            EngineAndLinters engineSteps = (EngineAndLinters)currentThreadEngine.get();
                            try {
                                return this.doFormat(cleanthatSession, engineSteps, pathToMutatedContent, filePath);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Issue with file: " + filePath, e);
                            }
                            catch (RuntimeException e) {
                                throw new RuntimeException("Issue with file: " + filePath, e);
                            }
                        });
                    } else {
                        languageCounters.incrementAndGet((Object)"nb_files_both_included_excluded");
                    }
                } else if (matchingExclude.isPresent()) {
                    languageCounters.incrementAndGet((Object)"nb_files_excluded_not_included");
                } else {
                    languageCounters.incrementAndGet((Object)"nb_files_neither_included_nor_excluded");
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue listing files", e);
        }
        finally {
            if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)1L, (TimeUnit)TimeUnit.DAYS)) {
                LOGGER.warn("Executor not terminated");
            }
        }
        try {
            Future polled;
            while ((polled = cs.poll()) != null) {
                boolean result = (Boolean)polled.get();
                if (result) {
                    languageToNbMutatedFiles.incrementAndGet((Object)engineP.getEngine());
                    languageCounters.incrementAndGet((Object)"nb_files_formatted");
                    continue;
                }
                languageCounters.incrementAndGet((Object)"nb_files_already_formatted");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Issue while one of the asynchronous tasks", e);
        }
        return languageCounters;
    }

    private boolean doFormat(CleanthatSession cleanthatSession, EngineAndLinters engineAndLinters, Map<Path, String> pathToMutatedContent, Path filePath) throws IOException {
        Optional<String> optCode = this.loadCodeOptMutated(cleanthatSession.getCodeProvider(), pathToMutatedContent, filePath);
        if (optCode.isEmpty()) {
            LOGGER.warn("Skip processing {} as its content is not available", (Object)filePath);
            return false;
        }
        String code = optCode.get();
        LOGGER.debug("Processing path={}", (Object)filePath);
        String output = this.doFormat(engineAndLinters, new PathAndContent(filePath, code));
        if (!Strings.isNullOrEmpty((String)output) && !code.equals(output)) {
            LOGGER.info("Path={} successfully cleaned by {}", (Object)filePath, (Object)engineAndLinters);
            pathToMutatedContent.put(filePath, output);
            if (pathToMutatedContent.size() > 128 && Integer.bitCount(pathToMutatedContent.size()) == 1) {
                LOGGER.warn("We are about to commit {} files. That's quite a lot.", (Object)pathToMutatedContent.size());
            }
            return true;
        }
        return false;
    }

    public Optional<String> loadCodeOptMutated(ICodeProvider codeProvider, Map<Path, String> pathToMutatedContent, Path filePath) {
        Optional<String> optAlreadyMutated = Optional.ofNullable(pathToMutatedContent.get(filePath));
        if (optAlreadyMutated.isPresent()) {
            return optAlreadyMutated;
        }
        try {
            return codeProvider.loadContentForPath(filePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private EngineAndLinters buildProcessors(IEngineProperties properties, CleanthatSession cleanthatSession) {
        IEngineLintFixerFactory formattersFactory = this.formatterFactory.makeLanguageFormatter(properties);
        return this.sourceCodeFormatterHelper.compile(properties, cleanthatSession, formattersFactory);
    }

    private String doFormat(EngineAndLinters compiledProcessors, PathAndContent pathAndContent) throws IOException {
        return this.formatterApplier.applyProcessors(compiledProcessors, pathAndContent);
    }
}

