/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider;

import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.codeprovider.ICodeProviderFile;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriter;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriterLogic;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeProviderDecoratingWriter
implements ICodeProviderWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeProviderDecoratingWriter.class);
    protected final ICodeProvider codeProvider;
    protected final Supplier<ICodeProviderWriterLogic> writerLogicSupplier;

    public CodeProviderDecoratingWriter(ICodeProvider codeProvider, Supplier<ICodeProviderWriterLogic> writerLogicSupplier) {
        this.codeProvider = codeProvider;
        this.writerLogicSupplier = writerLogicSupplier;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.codeProvider.getFileSystem();
    }

    public ICodeProvider getDecorated() {
        return this.codeProvider;
    }

    @Override
    public void listFilesForContent(Set<String> includePatterns, Consumer<ICodeProviderFile> consumer) throws IOException {
        this.codeProvider.listFilesForContent(includePatterns, consumer);
    }

    public String toString() {
        return this.codeProvider.toString();
    }

    @Override
    public Optional<String> loadContentForPath(String path) throws IOException {
        return this.codeProvider.loadContentForPath(path);
    }

    @Override
    public String getRepoUri() {
        return this.codeProvider.getRepoUri();
    }

    @Override
    public void persistChanges(Map<String, String> pathToMutatedContent, List<String> prComments, Collection<String> prLabels) {
        this.writerLogicSupplier.get().persistChanges(pathToMutatedContent, prComments, prLabels);
    }

    @Override
    public void cleanTmpFiles() {
        LOGGER.debug("Nothing to clean");
    }
}

