/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.config.ConfigHelpers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeProviderHelpers {
    public static final String PATH_SEPARATOR = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeProviderHelpers.class);
    public static final String FILENAME_CLEANTHAT_FOLDER = ".cleanthat";
    public static final String FILENAME_CLEANTHAT_YAML = "cleanthat.yaml";
    public static final String FILENAME_CLEANTHAT_YML = "cleanthat.yml";
    @Deprecated
    public static final String FILENAME_CLEANTHAT_JSON = "cleanthat.json";
    public static final List<String> PATHES_CLEANTHAT = Arrays.asList("/.cleanthat/cleanthat.yaml", "/.cleanthat/cleanthat.yml", "/cleanthat.yaml", "/cleanthat.yml", "/cleanthat.json");
    protected Collection<ObjectMapper> objectMappers;

    public CodeProviderHelpers(Collection<ObjectMapper> objectMappers) {
        this.objectMappers = objectMappers;
    }

    public Optional<Map<String, ?>> unsafeConfig(ICodeProvider codeProvider) {
        ObjectMapper objectMapper;
        Optional optPathAndContent = PATHES_CLEANTHAT.stream().map(p -> {
            try {
                return codeProvider.loadContentForPath((String)p).map(content -> Maps.immutableEntry((Object)p, (Object)content));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }).flatMap(Optional::stream).findFirst();
        if (optPathAndContent.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry pathAndContent = (Map.Entry)optPathAndContent.get();
        LOGGER.info("Loaded config from {}", pathAndContent.getKey());
        if (((String)pathAndContent.getKey()).endsWith(".json")) {
            objectMapper = ConfigHelpers.getJson(this.objectMappers);
        } else if (((String)pathAndContent.getKey()).endsWith(".yml") || ((String)pathAndContent.getKey()).endsWith(".yaml")) {
            objectMapper = ConfigHelpers.getYaml(this.objectMappers);
        } else {
            throw new IllegalArgumentException("Not managed extention: " + (String)pathAndContent.getKey());
        }
        return optPathAndContent.map(content -> {
            try {
                return (Map)objectMapper.readValue((String)content.getValue(), Map.class);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Invalid config (json vs yaml?)", e);
            }
        });
    }

    public static File pathToConfig(Path localFolder) {
        return PATHES_CLEANTHAT.stream().map(s -> {
            String prefix = PATH_SEPARATOR;
            if (!s.startsWith(prefix)) {
                throw new IllegalArgumentException("We expect cleanpath config pathes to start with '" + prefix + "'");
            }
            File file = localFolder.resolve(s.substring(prefix.length())).toFile();
            return file;
        }).filter(File::exists).findAny().orElseThrow(() -> new IllegalStateException("No configuration at pathes: " + PATHES_CLEANTHAT));
    }
}

