/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider;

import eu.solven.cleanthat.codeprovider.ICodeProviderFile;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public interface ICodeProvider {
    public FileSystem getFileSystem();

    default public void listFilesForContent(Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForContent(Set.of("glob:**/*"), consumer);
    }

    default public void listFilesForFilenames(Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForFilenames(Set.of("glob:**/*"), consumer);
    }

    public void listFilesForContent(Set<String> var1, Consumer<ICodeProviderFile> var2) throws IOException;

    default public void listFilesForFilenames(Set<String> includes, Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForContent(includes, consumer);
    }

    public Optional<String> loadContentForPath(String var1) throws IOException;

    default public Optional<String> loadContentForPath(Path path) throws IOException {
        return this.loadContentForPath(path.toString());
    }

    public String getRepoUri();
}

