/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider;

import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.codeprovider.ICodeProviderFile;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriter;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriterLogic;
import eu.solven.cleanthat.codeprovider.ICodeWritingMetadata;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeProviderDecoratingWriter
implements ICodeProviderWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeProviderDecoratingWriter.class);
    protected final ICodeProvider codeProvider;
    protected final Supplier<ICodeProviderWriterLogic> writerLogicSupplier;

    public CodeProviderDecoratingWriter(ICodeProvider codeProvider, Supplier<ICodeProviderWriterLogic> writerLogicSupplier) {
        this.codeProvider = codeProvider;
        this.writerLogicSupplier = writerLogicSupplier;
    }

    @Override
    public Path getRepositoryRoot() {
        return this.codeProvider.getRepositoryRoot();
    }

    public ICodeProvider getDecorated() {
        return this.codeProvider;
    }

    @Override
    public void listFilesForContent(Set<String> includePatterns, Consumer<ICodeProviderFile> consumer) throws IOException {
        this.codeProvider.listFilesForContent(includePatterns, consumer);
    }

    public String toString() {
        return this.codeProvider.toString();
    }

    @Override
    public Optional<String> loadContentForPath(Path path) throws IOException {
        return this.codeProvider.loadContentForPath(path);
    }

    @Override
    public String getRepoUri() {
        return this.codeProvider.getRepoUri();
    }

    @Override
    public boolean persistChanges(Map<Path, String> pathToMutatedContent, ICodeWritingMetadata metadata) {
        return this.writerLogicSupplier.get().persistChanges(pathToMutatedContent, metadata);
    }

    @Override
    public void cleanTmpFiles() {
        LOGGER.debug("Nothing to clean");
    }
}

