/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider;

import eu.solven.cleanthat.code_provider.CleanthatPathHelpers;
import eu.solven.cleanthat.codeprovider.ICodeProviderFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public interface ICodeProvider {
    public Path getRepositoryRoot();

    default public void listFilesForContent(Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForContent(Set.of("glob:**/*"), consumer);
    }

    default public void listFilesForFilenames(Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForFilenames(Set.of("glob:**/*"), consumer);
    }

    public void listFilesForContent(Set<String> var1, Consumer<ICodeProviderFile> var2) throws IOException;

    default public void listFilesForFilenames(Set<String> includes, Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForContent(includes, consumer);
    }

    public Optional<String> loadContentForPath(Path var1) throws IOException;

    default public Optional<String> loadContentForPath(String rawPath) throws IOException {
        Path path = CleanthatPathHelpers.makeContentPath((Path)this.getRepositoryRoot(), (String)rawPath);
        return this.loadContentForPath(path);
    }

    public String getRepoUri();
}

