/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatRepositoryProperties;
import eu.solven.cleanthat.config.pojo.SourceCodeProperties;
import eu.solven.cleanthat.github.IHasSourceCodeProperties;
import eu.solven.cleanthat.language.IEngineProperties;
import eu.solven.cleanthat.language.ISourceCodeProperties;
import eu.solven.pepper.collection.PepperMapHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ConfigHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHelpers.class);
    private static final String KEY_EXCLUDES = "excludes";
    private static final String KEY_INCLUDES = "includes";
    public static final String KEY_SOURCE_CODE = "source_code";
    final Collection<ObjectMapper> objectMappers;
    final ObjectMapper objectMapper;

    public ConfigHelpers(Collection<ObjectMapper> objectMappers) {
        this.objectMappers = objectMappers;
        this.objectMapper = ConfigHelpers.getYaml(objectMappers);
    }

    public static ConfigHelpers forTests() {
        return new ConfigHelpers(Arrays.asList(ConfigHelpers.makeYamlObjectMapper()));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Deprecated
    public static ObjectMapper makeJsonObjectMapper() {
        return new ObjectMapper();
    }

    public static ObjectMapper makeYamlObjectMapper() {
        YAMLFactory yamlFactory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.USE_PLATFORM_LINE_BREAKS);
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    public CleanthatRepositoryProperties loadRepoConfig(Resource resource) {
        return this.loadResource(resource, CleanthatRepositoryProperties.class);
    }

    public CleanthatRepositoryProperties loadResource(Resource resource, Class<CleanthatRepositoryProperties> clazz) {
        ObjectMapper objectMapper;
        String filenameLowerCase = resource.getFilename().toLowerCase(Locale.US);
        if (filenameLowerCase.endsWith(".json")) {
            objectMapper = ConfigHelpers.getJson(this.objectMappers);
        } else if (filenameLowerCase.endsWith(".yml") || filenameLowerCase.endsWith(".yaml")) {
            objectMapper = ConfigHelpers.getYaml(this.objectMappers);
        } else {
            throw new IllegalArgumentException("Not managed filename: " + filenameLowerCase);
        }
        try {
            return (CleanthatRepositoryProperties)objectMapper.readValue(resource.getInputStream(), clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue loading: " + resource, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Issue loading: " + resource, e);
        }
    }

    public IEngineProperties mergeEngineProperties(IHasSourceCodeProperties properties, IEngineProperties dirtyEngine) {
        Map<String, Object> dirtyLanguageAsMap = this.makeDeepCopy(dirtyEngine);
        ISourceCodeProperties sourceConfig = this.mergeSourceConfig(properties, dirtyLanguageAsMap);
        LinkedHashMap<String, Object> languageConfig = new LinkedHashMap<String, Object>();
        languageConfig.putAll(dirtyLanguageAsMap);
        languageConfig.put(KEY_SOURCE_CODE, sourceConfig);
        IEngineProperties languageP = (IEngineProperties)this.objectMapper.convertValue(languageConfig, CleanthatEngineProperties.class);
        return languageP;
    }

    protected ISourceCodeProperties mergeSourceConfig(IHasSourceCodeProperties properties, Map<String, ?> dirtyLanguageConfig) {
        Map rootSourceConfigAsMap = (Map)this.objectMapper.convertValue((Object)properties.getSourceCode(), Map.class);
        Map explicitSourceCodeProperties = PepperMapHelper.getOptionalAs(dirtyLanguageConfig, (Object)KEY_SOURCE_CODE, (Object[])new Object[0]).orElse(Map.of());
        Map<String, Object> sourceConfig = this.mergeSourceCodeProperties(rootSourceConfigAsMap, explicitSourceCodeProperties);
        return (ISourceCodeProperties)this.objectMapper.convertValue(sourceConfig, SourceCodeProperties.class);
    }

    protected Map<String, Object> mergeSourceCodeProperties(Map<String, ?> outer, Map<String, ?> inner) {
        LinkedHashMap<String, Object> merged = new LinkedHashMap<String, Object>();
        if (outer != null) {
            merged.putAll(outer);
        }
        if (inner != null) {
            merged.putAll(inner);
        }
        if (outer != null && inner != null) {
            Object outerLineEnding;
            Object innerLineEnding = inner.get("line_ending");
            if (innerLineEnding == null && (outerLineEnding = outer.get("line_ending")) != null) {
                LOGGER.debug("Outer lineEnding is more explicit than the innerOne");
                merged.put("line_ending", outerLineEnding);
            }
            List<?> outerIncludes = this.getAsNonNullList(outer, KEY_INCLUDES);
            List<?> innerIncludes = this.getAsNonNullList(inner, KEY_INCLUDES);
            List<?> outerExcludes = this.getAsNonNullList(outer, KEY_EXCLUDES);
            List<?> innerExcludes = this.getAsNonNullList(inner, KEY_EXCLUDES);
            if (innerIncludes.isEmpty()) {
                Stream<Object> outerIncludesWithoutInnerExclude = outerIncludes.stream().filter(includes -> !innerExcludes.contains(includes));
                List mergedIncludes = Stream.concat(outerIncludesWithoutInnerExclude, innerIncludes.stream()).distinct().collect(Collectors.toList());
                merged.put(KEY_INCLUDES, mergedIncludes);
            } else {
                merged.put(KEY_INCLUDES, innerIncludes);
            }
            Stream<Object> outerExcludesWithoutInnerInclude = outerExcludes.stream().filter(exclude -> !innerIncludes.contains(exclude));
            List mergedExcludes = Stream.concat(outerExcludesWithoutInnerInclude, innerExcludes.stream()).distinct().collect(Collectors.toList());
            merged.put(KEY_EXCLUDES, mergedExcludes);
        }
        return merged;
    }

    private List<?> getAsNonNullList(Map<String, ?> outer, String k) {
        List outerIncludes = (List)outer.get(k);
        if (outerIncludes == null) {
            outerIncludes = Collections.emptyList();
        }
        return outerIncludes;
    }

    public <T> Map<String, Object> makeDeepCopy(T object) {
        try {
            byte[] serialized = this.objectMapper.writeValueAsBytes(object);
            Map fromJackson = (Map)this.objectMapper.readValue(serialized, Map.class);
            return new LinkedHashMap<String, Object>(fromJackson);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Issue with: " + object, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue with: " + object, e);
        }
    }

    public IEngineProperties forceIncludes(IEngineProperties engine, Collection<String> includes) {
        Map engineAsMap = (Map)this.objectMapper.convertValue((Object)engine, Map.class);
        Map sourceCodeAsMap = (Map)this.objectMapper.convertValue((Object)engine.getSourceCode(), Map.class);
        sourceCodeAsMap.put(KEY_INCLUDES, includes);
        engineAsMap.put(KEY_SOURCE_CODE, sourceCodeAsMap);
        return (IEngineProperties)this.objectMapper.convertValue((Object)engineAsMap, CleanthatEngineProperties.class);
    }

    public static ObjectMapper getJson(Collection<ObjectMapper> objectMappers) {
        return objectMappers.stream().filter(om -> "JSON".equals(om.getFactory().getFormatName())).findAny().get();
    }

    public static ObjectMapper getYaml(Collection<ObjectMapper> objectMappers) {
        return objectMappers.stream().filter(om -> "YAML".equals(om.getFactory().getFormatName())).findAny().get();
    }
}

