/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java;

import eu.solven.cleanthat.config.ConfigHelpers;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatStepProperties;
import eu.solven.cleanthat.config.pojo.ICleanthatStepParametersProperties;
import eu.solven.cleanthat.engine.ASourceCodeFormatterFactory;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorer;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.formatter.CleanthatSession;
import eu.solven.cleanthat.formatter.ILintFixer;
import eu.solven.cleanthat.language.IEngineProperties;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFormattersFactory
extends ASourceCodeFormatterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaFormattersFactory.class);

    public JavaFormattersFactory(ConfigHelpers configHelpers) {
        super(configHelpers);
    }

    public String getEngine() {
        return "java";
    }

    public ILintFixer makeLintFixer(CleanthatSession cleanthatSession, IEngineProperties engineProperties, CleanthatStepProperties stepProperties) {
        JavaRefactorer processor;
        String stepId = stepProperties.getId();
        ICleanthatStepParametersProperties parameters = this.getParameters(stepProperties);
        LOGGER.debug("Processing: {}", (Object)stepId);
        switch (stepId) {
            case "refactorer": {
                JavaRefactorerProperties processorConfig = (JavaRefactorerProperties)this.convertValue(parameters, JavaRefactorerProperties.class);
                processor = new JavaRefactorer(engineProperties, processorConfig);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown step: " + stepId);
            }
        }
        if (!processor.getId().equals(stepId)) {
            throw new IllegalStateException("Inconsistency: " + processor.getId() + " vs " + stepId);
        }
        return processor;
    }

    public CleanthatEngineProperties makeDefaultProperties() {
        return CleanthatEngineProperties.builder().engine(this.getEngine()).step(CleanthatStepProperties.builder().id("refactorer").parameters((ICleanthatStepParametersProperties)JavaRefactorerProperties.defaults()).build()).build();
    }

    public Map<String, String> makeCustomDefaultFiles(CleanthatEngineProperties engineProperties) {
        return Map.of();
    }

    public Set<String> getDefaultIncludes() {
        return Set.of("glob:**/src/**/*.java");
    }
}

