/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import eu.solven.cleanthat.engine.java.refactorer.function.OnMethodName;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IRuleExternalUrls;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AJavaParserMutator
implements IMutator,
IRuleExternalUrls {
    private static final Logger LOGGER = LoggerFactory.getLogger(AJavaParserMutator.class);
    private static final ThreadLocal<JavaParserFacade> TL_JAVAPARSER = ThreadLocal.withInitial(() -> {
        CombinedTypeSolver ts = new CombinedTypeSolver(new TypeSolver[0]);
        boolean jreOnly = false;
        ts.add((TypeSolver)new ReflectionTypeSolver(jreOnly));
        return JavaParserFacade.get((TypeSolver)ts);
    });

    protected final JavaParserFacade getThreadJavaParser() {
        return TL_JAVAPARSER.get();
    }

    @Override
    public boolean walkNode(Node tree) {
        AtomicBoolean transformed = new AtomicBoolean();
        tree.walk(node -> {
            if (this.processNotRecursively((Node)node)) {
                if (!this.getIds().contains("NoOp") && this.processNotRecursively((Node)node)) {
                    LOGGER.warn("Applying {} over {} is not idem-potent. It is a bug!", (Object)this, (Object)tree);
                }
                transformed.set(true);
            }
        });
        return transformed.get();
    }

    protected boolean processNotRecursively(Node node) {
        Optional<Node> optReplacement = this.replaceNode(node);
        if (optReplacement.isPresent()) {
            Node replacement = optReplacement.get();
            return this.tryReplace(node, replacement);
        }
        return false;
    }

    public boolean tryReplace(Node node, Node replacement) {
        LOGGER.info("Turning {} into {}", (Object)node, (Object)replacement);
        return node.replace(replacement);
    }

    protected Optional<Node> replaceNode(Node node) {
        throw new UnsupportedOperationException("TODO Implement me in overriden classes");
    }

    protected Optional<ResolvedType> optResolvedType(Expression scope) {
        ResolvedType calculateResolvedType;
        try {
            calculateResolvedType = scope.calculateResolvedType();
        }
        catch (RuntimeException e) {
            try {
                Optional<ResolvedType> fallbackType = Optional.of(this.getThreadJavaParser().getType((Node)scope));
                if (fallbackType.isPresent()) {
                    LOGGER.debug("1- Does this still happen? As of 2022-12: Yes!", (Throwable)e);
                }
                return fallbackType;
            }
            catch (RuntimeException ee) {
                LOGGER.debug("Issue with JavaParser: {} {}", (Object)ee.getClass().getName(), (Object)ee.getMessage());
                return Optional.empty();
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("We encounter a case of {} for {}. Full-stack is available in 'debug'", (Object)"https://github.com/javaparser/javaparser/issues/3504", (Object)scope);
            LOGGER.debug("We encounter a case of {} for {}. Full-stack is available in 'debug'", new Object[]{"https://github.com/javaparser/javaparser/issues/3504", scope, e});
            return Optional.empty();
        }
        try {
            ResolvedType manualResolvedType = this.getThreadJavaParser().getType((Node)scope);
            if (!manualResolvedType.toString().equals(calculateResolvedType.toString())) {
                throw new IllegalStateException(manualResolvedType.toString() + " not equals to " + calculateResolvedType.toString());
            }
            return Optional.of(manualResolvedType);
        }
        catch (RuntimeException e) {
            LOGGER.warn("2- Does this still happen? Yes!", (Throwable)e);
            LOGGER.debug("Issue with JavaParser: {} {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    protected void onMethodName(Node node, String methodName, OnMethodName consumer) {
        if (node instanceof MethodCallExpr && methodName.equals(((MethodCallExpr)node).getName().getIdentifier())) {
            MethodCallExpr methodCall = (MethodCallExpr)node;
            Optional optScope = methodCall.getScope();
            if (optScope.isEmpty()) {
                return;
            }
            Expression scope = (Expression)optScope.get();
            Optional<ResolvedType> type = this.optResolvedType(scope);
            if (type.isPresent()) {
                consumer.onMethodName(methodCall, scope, type.get());
            }
        }
    }

    protected boolean scopeHasRequiredType(Optional<Expression> optScope, Class<?> requiredType) {
        return this.scopeHasRequiredType(optScope, requiredType.getName());
    }

    protected boolean scopeHasRequiredType(Optional<Expression> optScope, String requiredType) {
        Optional optType = optScope.flatMap(this::optResolvedType);
        if (optType.isEmpty()) {
            return false;
        }
        ResolvedType type = (ResolvedType)optType.get();
        boolean isCorrectClass = false;
        if (type.isConstraint()) {
            type = type.asConstraintType().getBound();
        }
        if (type.isReferenceType() && type.asReferenceType().getQualifiedName().equals(requiredType)) {
            isCorrectClass = true;
        } else if (type.isPrimitive() && type.asPrimitive().describe().equals(requiredType)) {
            isCorrectClass = true;
        }
        return isCorrectClass;
    }
}

