/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import eu.solven.cleanthat.engine.java.IJdkVersionConstants;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.engine.java.refactorer.MutatorsScanner;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.VersionWrapper;
import eu.solven.cleanthat.formatter.ILintFixerWithId;
import eu.solven.cleanthat.formatter.LineEnding;
import eu.solven.cleanthat.language.IEngineProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRefactorer
implements ILintFixerWithId {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaRefactorer.class);
    public static final String ID_REFACTORER = "refactorer";
    private final IEngineProperties engineProperties;
    private final JavaRefactorerProperties refactorerProperties;
    private static final Supplier<List<IMutator>> ALL_TRANSFORMERS = Suppliers.memoize(() -> ImmutableList.copyOf(new MutatorsScanner().getMutators()));
    private final List<IMutator> transformers;

    public static final Set<String> getAllIncluded() {
        return ALL_TRANSFORMERS.get().stream().flatMap(ct -> ct.getIds().stream()).sorted().collect(Collectors.toCollection(TreeSet::new));
    }

    public JavaRefactorer(IEngineProperties engineProperties, JavaRefactorerProperties properties) {
        this.engineProperties = engineProperties;
        this.refactorerProperties = properties;
        VersionWrapper engineVersion = new VersionWrapper(engineProperties.getEngineVersion());
        List<String> includedRules = properties.getIncluded();
        List<String> excludedRules = properties.getExcluded();
        boolean productionReadyOnly = properties.isProductionReadyOnly();
        this.transformers = ALL_TRANSFORMERS.get().stream().filter(ct -> {
            VersionWrapper transformerVersion = new VersionWrapper(ct.minimalJavaVersion());
            return engineVersion.compareTo(transformerVersion) >= 0;
        }).filter(ct -> {
            boolean isIncluded;
            boolean isExcluded = excludedRules.stream().anyMatch(excludedRule -> ct.getIds().contains(excludedRule));
            boolean bl = isIncluded = includedRules.isEmpty() || includedRules.stream().filter(includedRule -> "*".equals(includedRule) || ct.getIds().contains(includedRule)).findAny().isPresent();
            if (isExcluded) {
                LOGGER.info("We exclude '{}'", ct.getIds());
            } else if (!isIncluded) {
                LOGGER.info("We do not include '{}'", ct.getIds());
            }
            return !isExcluded && isIncluded;
        }).filter(ct -> {
            if (productionReadyOnly) {
                return ct.isProductionReady();
            }
            return true;
        }).collect(Collectors.toList());
        this.transformers.forEach(ct -> LOGGER.debug("Using transformer: {}", ct.getIds()));
    }

    public String getId() {
        return ID_REFACTORER;
    }

    public List<IMutator> getMutators() {
        return this.transformers;
    }

    public String doFormat(String dirtyCode, LineEnding ending) throws IOException {
        LOGGER.debug("{}", (Object)this.refactorerProperties);
        String cleanCode = this.applyTransformers(dirtyCode);
        return this.fixJavaparserUnexpectedChanges(dirtyCode, cleanCode);
    }

    private String applyTransformers(String dirtyCode) {
        AtomicReference<String> refCleanCode = new AtomicReference<String>(dirtyCode);
        AtomicReference optCompilationUnit = new AtomicReference();
        JavaParser parser = this.makeJavaParser();
        this.transformers.stream().filter(ct -> {
            int codeVersion;
            int ruleMinimal = JavaRefactorer.getVersionIndex(ct.minimalJavaVersion());
            if (ruleMinimal > (codeVersion = JavaRefactorer.getVersionIndex(this.engineProperties.getEngineVersion()))) {
                LOGGER.debug("We skip {} as {} > {}", new Object[]{ct, ct.minimalJavaVersion(), this.engineProperties.getEngineVersion()});
                return false;
            }
            return true;
        }).forEach(ct -> {
            boolean walkNodeResult;
            LOGGER.debug("Applying {}", ct);
            if (optCompilationUnit.get() == null) {
                try {
                    String sourceCode = (String)refCleanCode.get();
                    CompilationUnit compilationUnit = this.parseRawCode(parser, sourceCode);
                    optCompilationUnit.set(compilationUnit);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Issue parsing the code", e);
                }
            }
            CompilationUnit compilationUnit = (CompilationUnit)optCompilationUnit.get();
            try {
                walkNodeResult = ct.walkNode((Node)compilationUnit);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Issue with classTransformer: " + ct, e);
            }
            if (walkNodeResult) {
                LOGGER.debug("A rule based on JavaParser actually modified the code");
                refCleanCode.set(this.toString(compilationUnit));
                optCompilationUnit.set(null);
            }
        });
        return refCleanCode.get();
    }

    private static int getVersionIndex(String v) {
        int ruleMinimal = IJdkVersionConstants.ORDERED.indexOf(v);
        if (ruleMinimal < 0) {
            throw new IllegalArgumentException("Unknown version: " + v);
        }
        return ruleMinimal;
    }

    public CompilationUnit parseRawCode(JavaParser parser, String sourceCode) {
        ParseResult parsed = parser.parse(sourceCode);
        CompilationUnit compilationUnit = (CompilationUnit)parsed.getResult().get();
        LexicalPreservingPrinter.setup((Node)compilationUnit);
        return compilationUnit;
    }

    public JavaParser makeJavaParser() {
        boolean isJreOnly = false;
        JavaParser parser = JavaRefactorer.makeDefaultJavaParser(isJreOnly);
        return parser;
    }

    protected String fixJavaparserUnexpectedChanges(String dirtyCode, String cleanCode) throws IOException {
        List fixedPatchApplied;
        if (dirtyCode.equals(cleanCode)) {
            return dirtyCode;
        }
        String lineEndingChars = LineEnding.getOrGuess((LineEnding)this.engineProperties.getSourceCode().getLineEndingAsEnum(), () -> cleanCode);
        Optional optLineEnding = LineEnding.determineLineEnding((String)lineEndingChars);
        if (optLineEnding.isEmpty()) {
            return cleanCode;
        }
        List<String> dirtyRows = Arrays.asList(dirtyCode.split(lineEndingChars, -1));
        List<String> cleanRows = Arrays.asList(cleanCode.split(lineEndingChars, -1));
        Patch diff = DiffUtils.diff(dirtyRows, cleanRows);
        this.assertPatchIsValid(dirtyRows, cleanRows, (Patch<String>)diff);
        List<AbstractDelta<String>> fixedDelta = this.computeFixedDelta((Patch<String>)diff);
        if (fixedDelta.isEmpty()) {
            return dirtyCode;
        }
        Patch fixedPatch = new Patch();
        fixedDelta.forEach(arg_0 -> ((Patch)fixedPatch).addDelta(arg_0));
        try {
            fixedPatchApplied = diff.applyTo(dirtyRows);
        }
        catch (PatchFailedException e) {
            throw new RuntimeException(e);
        }
        return fixedPatchApplied.stream().collect(Collectors.joining(lineEndingChars));
    }

    public List<AbstractDelta<String>> computeFixedDelta(Patch<String> diff) {
        List<AbstractDelta<String>> fixedDelta = diff.getDeltas().stream().filter(p -> {
            if (p.getType() == DeltaType.DELETE) {
                String uniqueTrimmer;
                List sourceLines = p.getSource().getLines();
                Set unique = sourceLines.stream().distinct().collect(Collectors.toSet());
                return unique.size() != 1 || !(uniqueTrimmer = ((String)unique.iterator().next()).trim()).isEmpty() && !"*".equals(uniqueTrimmer);
            }
            return true;
        }).collect(Collectors.toList());
        return fixedDelta;
    }

    protected void assertPatchIsValid(List<String> dirtyRows, List<String> cleanRows, Patch<String> diff) {
        List patchApplied;
        try {
            patchApplied = diff.applyTo(dirtyRows);
        }
        catch (PatchFailedException e) {
            throw new RuntimeException(e);
        }
        if (!cleanRows.equals(patchApplied)) {
            throw new IllegalArgumentException("Issue aplying the patch");
        }
        List patchRestored = diff.restore(cleanRows);
        if (!dirtyRows.equals(patchRestored)) {
            throw new IllegalArgumentException("Issue restoring the patch");
        }
    }

    protected String toString(CompilationUnit compilationUnit) {
        return LexicalPreservingPrinter.print((Node)compilationUnit);
    }

    public static JavaParser makeDefaultJavaParser(boolean jreOnly) {
        ReflectionTypeSolver reflectionTypeSolver = new ReflectionTypeSolver(jreOnly);
        JavaSymbolSolver symbolResolver = new JavaSymbolSolver((TypeSolver)new CombinedTypeSolver(new TypeSolver[]{reflectionTypeSolver}));
        ParserConfiguration configuration = new ParserConfiguration().setSymbolResolver((SymbolResolver)symbolResolver);
        JavaParser parser = new JavaParser(configuration);
        return parser;
    }
}

